/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;

public final class UnsupportedDateTimeField
extends DateTimeField
implements Serializable {
    private static final long serialVersionUID = -1934618396111902255L;
    private static HashMap cCache;
    private final DateTimeFieldType iType;
    private final DurationField iDurationField;

    public static synchronized UnsupportedDateTimeField getInstance(DateTimeFieldType type, DurationField durationField) {
        UnsupportedDateTimeField field;
        if (cCache == null) {
            cCache = new HashMap(7);
            field = null;
        } else {
            field = (UnsupportedDateTimeField)cCache.get(type);
            if (field != null && field.getDurationField() != durationField) {
                field = null;
            }
        }
        if (field == null) {
            field = new UnsupportedDateTimeField(type, durationField);
            cCache.put(type, field);
        }
        return field;
    }

    private UnsupportedDateTimeField(DateTimeFieldType type, DurationField durationField) {
        if (type == null || durationField == null) {
            throw new IllegalArgumentException();
        }
        this.iType = type;
        this.iDurationField = durationField;
    }

    public DateTimeFieldType getType() {
        return this.iType;
    }

    public String getName() {
        return this.iType.getName();
    }

    public boolean isSupported() {
        return false;
    }

    public boolean isLenient() {
        return false;
    }

    public int get(long instant) {
        throw this.unsupported();
    }

    public String getAsText(long instant, Locale locale) {
        throw this.unsupported();
    }

    public String getAsText(long instant) {
        throw this.unsupported();
    }

    public String getAsText(ReadablePartial partial, int fieldValue, Locale locale) {
        throw this.unsupported();
    }

    public String getAsText(ReadablePartial partial, Locale locale) {
        throw this.unsupported();
    }

    public String getAsShortText(long instant, Locale locale) {
        throw this.unsupported();
    }

    public String getAsShortText(long instant) {
        throw this.unsupported();
    }

    public String getAsShortText(ReadablePartial partial, int fieldValue, Locale locale) {
        throw this.unsupported();
    }

    public String getAsShortText(ReadablePartial partial, Locale locale) {
        throw this.unsupported();
    }

    public long add(long instant, int value) {
        return this.getDurationField().add(instant, value);
    }

    public long add(long instant, long value) {
        return this.getDurationField().add(instant, value);
    }

    public int[] add(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        throw this.unsupported();
    }

    public long addWrapField(long instant, int value) {
        throw this.unsupported();
    }

    public int[] addWrapField(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        throw this.unsupported();
    }

    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return this.getDurationField().getDifference(minuendInstant, subtrahendInstant);
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return this.getDurationField().getDifferenceAsLong(minuendInstant, subtrahendInstant);
    }

    public long set(long instant, int value) {
        throw this.unsupported();
    }

    public int[] set(ReadablePartial instant, int fieldIndex, int[] values, int newValue) {
        throw this.unsupported();
    }

    public long set(long instant, String text, Locale locale) {
        throw this.unsupported();
    }

    public long set(long instant, String text) {
        throw this.unsupported();
    }

    public int[] set(ReadablePartial instant, int fieldIndex, int[] values, String text, Locale locale) {
        throw this.unsupported();
    }

    public DurationField getDurationField() {
        return this.iDurationField;
    }

    public DurationField getRangeDurationField() {
        return null;
    }

    public boolean isLeap(long instant) {
        throw this.unsupported();
    }

    public int getLeapAmount(long instant) {
        throw this.unsupported();
    }

    public DurationField getLeapDurationField() {
        return null;
    }

    public int getMinimumValue() {
        throw this.unsupported();
    }

    public int getMinimumValue(long instant) {
        throw this.unsupported();
    }

    public int getMinimumValue(ReadablePartial instant) {
        throw this.unsupported();
    }

    public int getMinimumValue(ReadablePartial instant, int[] values) {
        throw this.unsupported();
    }

    public int getMaximumValue() {
        throw this.unsupported();
    }

    public int getMaximumValue(long instant) {
        throw this.unsupported();
    }

    public int getMaximumValue(ReadablePartial instant) {
        throw this.unsupported();
    }

    public int getMaximumValue(ReadablePartial instant, int[] values) {
        throw this.unsupported();
    }

    public int getMaximumTextLength(Locale locale) {
        throw this.unsupported();
    }

    public int getMaximumShortTextLength(Locale locale) {
        throw this.unsupported();
    }

    public long roundFloor(long instant) {
        throw this.unsupported();
    }

    public long roundCeiling(long instant) {
        throw this.unsupported();
    }

    public long roundHalfFloor(long instant) {
        throw this.unsupported();
    }

    public long roundHalfCeiling(long instant) {
        throw this.unsupported();
    }

    public long roundHalfEven(long instant) {
        throw this.unsupported();
    }

    public long remainder(long instant) {
        throw this.unsupported();
    }

    public String toString() {
        return "UnsupportedDateTimeField";
    }

    private Object readResolve() {
        return UnsupportedDateTimeField.getInstance(this.iType, this.iDurationField);
    }

    private UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException(this.iType + " field is unsupported");
    }
}

