/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadWritableInstant;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.FormatUtils;

public abstract class BaseDateTimeFormatter {
    public void printTo(StringBuffer buf, ReadableInstant instant) {
        long millis = DateTimeUtils.getInstantMillis(instant);
        Chronology chrono = DateTimeUtils.getInstantChronology(instant);
        this.printTo(buf, millis, chrono);
    }

    public void printTo(Writer out, ReadableInstant instant) throws IOException {
        long millis = DateTimeUtils.getInstantMillis(instant);
        Chronology chrono = DateTimeUtils.getInstantChronology(instant);
        this.printTo(out, millis, chrono);
    }

    public void printTo(StringBuffer buf, long instant) {
        this.printTo(buf, instant, (Chronology)ISOChronology.getInstance());
    }

    public void printTo(Writer out, long instant) throws IOException {
        this.printTo(out, instant, (Chronology)ISOChronology.getInstance());
    }

    public void printTo(StringBuffer buf, long instant, DateTimeZone zone) {
        zone = DateTimeUtils.getZone(zone);
        this.printTo(buf, instant, (Chronology)ISOChronology.getInstance(zone));
    }

    public void printTo(Writer out, long instant, DateTimeZone zone) throws IOException {
        zone = DateTimeUtils.getZone(zone);
        this.printTo(out, instant, (Chronology)ISOChronology.getInstance(zone));
    }

    public void printTo(StringBuffer buf, long instant, Chronology chrono) {
        chrono = DateTimeUtils.getChronology(chrono);
        this.printTo(buf, instant + (long)chrono.getZone().getOffset(instant), chrono.withUTC(), instant, chrono);
    }

    public void printTo(Writer out, long instant, Chronology chrono) throws IOException {
        chrono = DateTimeUtils.getChronology(chrono);
        this.printTo(out, instant + (long)chrono.getZone().getOffset(instant), chrono.withUTC(), instant, chrono);
    }

    public String print(ReadableInstant instant) {
        long millis = DateTimeUtils.getInstantMillis(instant);
        Chronology chrono = DateTimeUtils.getInstantChronology(instant);
        return this.print(millis, chrono);
    }

    public String print(long instant) {
        return this.print(instant, ISOChronology.getInstance());
    }

    public String print(long instant, DateTimeZone zone) {
        zone = DateTimeUtils.getZone(zone);
        return this.print(instant, ISOChronology.getInstance(zone));
    }

    public String print(long instant, Chronology chrono) {
        chrono = DateTimeUtils.getChronology(chrono);
        return this.print(instant + (long)chrono.getZone().getOffset(instant), chrono.withUTC(), instant, chrono);
    }

    public String print(ReadablePartial partial) {
        StringBuffer buf = new StringBuffer(this.estimatePrintedLength());
        this.printTo(buf, partial);
        return buf.toString();
    }

    protected int estimatePrintedLength() {
        throw new UnsupportedOperationException("Printing not supported");
    }

    protected void printTo(StringBuffer buf, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
        throw new UnsupportedOperationException("Printing not supported");
    }

    protected void printTo(Writer out, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) throws IOException {
        throw new UnsupportedOperationException("Printing not supported");
    }

    public void printTo(StringBuffer buf, ReadablePartial partial) {
        throw new UnsupportedOperationException("Printing not supported");
    }

    public void printTo(Writer out, ReadablePartial partial) throws IOException {
        throw new UnsupportedOperationException("Printing not supported");
    }

    protected String print(long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
        StringBuffer buf = new StringBuffer(this.estimatePrintedLength());
        this.printTo(buf, instantLocal, chronoLocal, instant, chrono);
        return buf.toString();
    }

    public int parseInto(ReadWritableInstant instant, String text, int position) {
        if (instant == null) {
            throw new IllegalArgumentException("Instant must not be null");
        }
        long millis = instant.getMillis();
        Chronology chrono = instant.getChronology();
        long instantLocal = millis + (long)chrono.getZone().getOffset(millis);
        ParseBucket bucket = new ParseBucket(instantLocal, chrono);
        int resultPos = this.parseInto(bucket, text, position);
        instant.setMillis(bucket.computeMillis());
        return resultPos;
    }

    public long parseMillis(String text) {
        return this.parseMillis(text, ISOChronology.getInstance());
    }

    public long parseMillis(String text, Chronology chrono) {
        ParseBucket bucket = new ParseBucket(0L, chrono);
        int newPos = this.parseInto(bucket, text, 0);
        if (newPos >= 0) {
            if (newPos >= text.length()) {
                return bucket.computeMillis(true);
            }
        } else {
            newPos ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(text, newPos));
    }

    public long parseMillis(String text, long instant) {
        return this.parseMillis(text, instant, ISOChronology.getInstance());
    }

    public long parseMillis(String text, long instant, Chronology chrono) {
        long instantLocal = instant + (long)(chrono = DateTimeUtils.getChronology(chrono)).getZone().getOffset(instant);
        ParseBucket bucket = new ParseBucket(instantLocal, chrono);
        int newPos = this.parseInto(bucket, text, 0);
        if (newPos >= 0) {
            if (newPos >= text.length()) {
                return bucket.computeMillis();
            }
        } else {
            newPos ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(text, newPos));
    }

    public DateTime parseDateTime(String text) {
        return this.parseDateTime(text, ISOChronology.getInstance());
    }

    public DateTime parseDateTime(String text, Chronology chrono) {
        return new DateTime(this.parseMillis(text, chrono), chrono);
    }

    public DateTime parseDateTime(String text, ReadableInstant instant) {
        Chronology chrono = DateTimeUtils.getInstantChronology(instant);
        long millis = DateTimeUtils.getInstantMillis(instant);
        return new DateTime(this.parseMillis(text, millis, chrono), chrono);
    }

    public MutableDateTime parseMutableDateTime(String text) {
        return this.parseMutableDateTime(text, ISOChronology.getInstance());
    }

    public MutableDateTime parseMutableDateTime(String text, Chronology chrono) {
        return new MutableDateTime(this.parseMillis(text, chrono), chrono);
    }

    public MutableDateTime parseMutableDateTime(String text, ReadableInstant instant) {
        Chronology chrono = DateTimeUtils.getInstantChronology(instant);
        long millis = DateTimeUtils.getInstantMillis(instant);
        return new MutableDateTime(this.parseMillis(text, millis, chrono), chrono);
    }

    protected int estimateParsedLength() {
        throw new UnsupportedOperationException("Parsing not supported");
    }

    protected int parseInto(ParseBucket bucket, String text, int position) {
        throw new UnsupportedOperationException("Parsing not supported");
    }

    public static class ParseBucket {
        private final Chronology iChrono;
        private final long iMillis;
        DateTimeZone iZone;
        int iOffset;
        SavedField[] iSavedFields = new SavedField[8];
        int iSavedFieldsCount;
        boolean iSavedFieldsShared;
        private Object iSavedState;

        public ParseBucket(long instantLocal, Chronology chrono) {
            chrono = DateTimeUtils.getChronology(chrono);
            this.iMillis = instantLocal;
            this.iChrono = chrono.withUTC();
            this.setZone(chrono.getZone());
        }

        public Chronology getChronology() {
            return this.iChrono;
        }

        public DateTimeZone getZone() {
            return this.iZone;
        }

        public void setZone(DateTimeZone zone) {
            this.iSavedState = null;
            this.iZone = zone == DateTimeZone.UTC ? null : zone;
            this.iOffset = 0;
        }

        public int getOffset() {
            return this.iOffset;
        }

        public void setOffset(int offset) {
            this.iSavedState = null;
            this.iOffset = offset;
            this.iZone = null;
        }

        public void saveField(DateTimeField field, int value) {
            this.saveField(new SavedField(field, value));
        }

        public void saveField(DateTimeFieldType fieldType, int value) {
            this.saveField(new SavedField(fieldType.getField(this.iChrono), value));
        }

        public void saveField(DateTimeFieldType fieldType, String text, Locale locale) {
            this.saveField(new SavedField(fieldType.getField(this.iChrono), text, locale));
        }

        private void saveField(SavedField field) {
            int savedFieldsCount = this.iSavedFieldsCount;
            SavedField[] savedFields = this.iSavedFields;
            if (savedFieldsCount == savedFields.length || this.iSavedFieldsShared) {
                SavedField[] newArray = new SavedField[savedFieldsCount == savedFields.length ? savedFieldsCount * 2 : savedFields.length];
                System.arraycopy(savedFields, 0, newArray, 0, savedFieldsCount);
                savedFields = newArray;
                this.iSavedFields = newArray;
                this.iSavedFieldsShared = false;
            }
            this.iSavedState = null;
            savedFields[savedFieldsCount] = field;
            this.iSavedFieldsCount = savedFieldsCount + 1;
        }

        public Object saveState() {
            if (this.iSavedState == null) {
                this.iSavedState = new SavedState();
            }
            return this.iSavedState;
        }

        public boolean restoreState(Object savedState) {
            if (savedState instanceof SavedState && ((SavedState)savedState).restoreState(this)) {
                this.iSavedState = savedState;
                return true;
            }
            return false;
        }

        public long computeMillis() {
            return this.computeMillis(false);
        }

        public long computeMillis(boolean resetFields) {
            Comparable[] savedFields = this.iSavedFields;
            int count = this.iSavedFieldsCount;
            if (this.iSavedFieldsShared) {
                savedFields = (SavedField[])this.iSavedFields.clone();
                this.iSavedFields = savedFields;
                this.iSavedFieldsShared = false;
            }
            ParseBucket.sort(savedFields, count);
            long millis = this.iMillis;
            int i = 0;
            while (i < count) {
                millis = ((SavedField)savedFields[i]).set(millis, resetFields);
                ++i;
            }
            if (this.iZone == null) {
                millis -= (long)this.iOffset;
            } else {
                int offset = this.iZone.getOffsetFromLocal(millis);
                if (offset != this.iZone.getOffset(millis -= (long)offset)) {
                    throw new IllegalArgumentException("Illegal instant due to time zone offset transition");
                }
            }
            return millis;
        }

        private static void sort(Comparable[] array, int high) {
            if (high > 10) {
                Arrays.sort(array, 0, high);
            } else {
                int i = 0;
                while (i < high) {
                    int j = i;
                    while (j > 0 && array[j - 1].compareTo(array[j]) > 0) {
                        Comparable t = array[j];
                        array[j] = array[j - 1];
                        array[j - 1] = t;
                        --j;
                    }
                    ++i;
                }
            }
        }

        static class SavedField
        implements Comparable {
            final DateTimeField iField;
            final int iValue;
            final String iText;
            final Locale iLocale;

            SavedField(DateTimeField field, int value) {
                this.iField = field;
                this.iValue = value;
                this.iText = null;
                this.iLocale = null;
            }

            SavedField(DateTimeField field, String text, Locale locale) {
                this.iField = field;
                this.iValue = 0;
                this.iText = text;
                this.iLocale = locale;
            }

            long set(long millis, boolean reset) {
                millis = this.iText == null ? this.iField.set(millis, this.iValue) : this.iField.set(millis, this.iText, this.iLocale);
                if (reset) {
                    millis = this.iField.roundFloor(millis);
                }
                return millis;
            }

            public int compareTo(Object obj) {
                DateTimeField other = ((SavedField)obj).iField;
                int result = this.compareReverse(this.iField.getRangeDurationField(), other.getRangeDurationField());
                if (result != 0) {
                    return result;
                }
                return this.compareReverse(this.iField.getDurationField(), other.getDurationField());
            }

            private int compareReverse(Comparable a, Comparable b) {
                if (a == null) {
                    if (b == null) {
                        return 0;
                    }
                    return -1;
                }
                if (b == null) {
                    return 1;
                }
                return -a.compareTo(b);
            }
        }

        class SavedState {
            final DateTimeZone iZone;
            final int iOffset;
            final SavedField[] iSavedFields;
            final int iSavedFieldsCount;

            SavedState() {
                this.iZone = ParseBucket.this.iZone;
                this.iOffset = ParseBucket.this.iOffset;
                this.iSavedFields = ParseBucket.this.iSavedFields;
                this.iSavedFieldsCount = ParseBucket.this.iSavedFieldsCount;
            }

            boolean restoreState(ParseBucket enclosing) {
                if (enclosing != ParseBucket.this) {
                    return false;
                }
                enclosing.iZone = this.iZone;
                enclosing.iOffset = this.iOffset;
                enclosing.iSavedFields = this.iSavedFields;
                if (this.iSavedFieldsCount < enclosing.iSavedFieldsCount) {
                    enclosing.iSavedFieldsShared = true;
                }
                enclosing.iSavedFieldsCount = this.iSavedFieldsCount;
                return true;
            }
        }
    }
}

