/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.PeriodParser;

public abstract class BasePeriodFormatter {
    protected int calculatePrintedLength(ReadablePeriod period) {
        throw new UnsupportedOperationException("Printing not supported");
    }

    protected int countFieldsToPrint(ReadablePeriod period) {
        return this.countFieldsToPrint(period, Integer.MAX_VALUE);
    }

    protected int countFieldsToPrint(ReadablePeriod period, int stopAt) {
        throw new UnsupportedOperationException("Printing not supported");
    }

    public void printTo(StringBuffer buf, ReadablePeriod period) {
        throw new UnsupportedOperationException("Printing not supported");
    }

    public void printTo(Writer out, ReadablePeriod period) throws IOException {
        throw new UnsupportedOperationException("Printing not supported");
    }

    public String print(ReadablePeriod period) {
        StringBuffer buf = new StringBuffer(this.calculatePrintedLength(period));
        this.printTo(buf, period);
        return buf.toString();
    }

    public int parseInto(ReadWritablePeriod period, String periodStr, int position) {
        throw new UnsupportedOperationException("Parsing not supported");
    }

    public Period parsePeriod(PeriodType type, String text) {
        return this.parseMutablePeriod(type, text).toPeriod();
    }

    public MutablePeriod parseMutablePeriod(PeriodType type, String text) {
        PeriodParser p = (PeriodParser)((Object)this);
        MutablePeriod period = new MutablePeriod(0L, type);
        int newPos = p.parseInto(period, text, 0);
        if (newPos >= 0) {
            if (newPos >= text.length()) {
                return period;
            }
        } else {
            newPos ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(text, newPos));
    }
}

