/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadWritableInstant;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.field.RemainderDateTimeField;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimePrinter;

public class DateTimeFormat {
    private static Map cInstanceCache = new HashMap(7);
    private final Locale iLocale;
    private transient Map iPatternedCache = new HashMap(7);
    private transient Map iStyledCache = new HashMap(7);

    public static DateTimeFormat getInstance() {
        return DateTimeFormat.getInstance(Locale.getDefault());
    }

    public static synchronized DateTimeFormat getInstance(Locale locale) {
        DateTimeFormat dtf;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((dtf = (DateTimeFormat)cInstanceCache.get(locale)) == null) {
            dtf = new DateTimeFormat(locale);
            cInstanceCache.put(locale, dtf);
        }
        return dtf;
    }

    public static void appendPatternTo(DateTimeFormatterBuilder builder, String pattern) {
        int length = pattern.length();
        int[] indexRef = new int[1];
        int i = 0;
        while (i < length) {
            indexRef[0] = i;
            String token = DateTimeFormat.parseToken(pattern, indexRef);
            i = indexRef[0];
            int tokenLen = token.length();
            if (tokenLen == 0) break;
            char c = token.charAt(0);
            switch (c) {
                case 'G': {
                    builder.appendEraText();
                    break;
                }
                case 'C': {
                    builder.appendCenturyOfEra(tokenLen, tokenLen);
                    break;
                }
                case 'Y': 
                case 'x': 
                case 'y': {
                    if (tokenLen == 2) {
                        RemainderType type;
                        switch (c) {
                            case 'x': {
                                type = new RemainderType(DateTimeFieldType.weekyear(), DateTimeFieldType.weekyearOfCentury(), 100);
                                break;
                            }
                            default: {
                                type = new RemainderType(DateTimeFieldType.year(), DateTimeFieldType.yearOfCentury(), 100);
                                break;
                            }
                            case 'Y': {
                                type = new RemainderType(DateTimeFieldType.yearOfEra(), DateTimeFieldType.yearOfCentury(), 100);
                            }
                        }
                        builder.appendDecimal(type, 2, 2);
                        break;
                    }
                    int maxDigits = 9;
                    if (i + 1 < length) {
                        indexRef[0] = indexRef[0] + 1;
                        if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(pattern, indexRef))) {
                            maxDigits = tokenLen;
                        }
                        indexRef[0] = indexRef[0] - 1;
                    }
                    switch (c) {
                        case 'x': {
                            builder.appendWeekyear(tokenLen, maxDigits);
                            break;
                        }
                        case 'y': {
                            builder.appendYear(tokenLen, maxDigits);
                            break;
                        }
                        case 'Y': {
                            builder.appendYearOfEra(tokenLen, maxDigits);
                        }
                    }
                    break;
                }
                case 'M': {
                    if (tokenLen >= 3) {
                        if (tokenLen >= 4) {
                            builder.appendMonthOfYearText();
                            break;
                        }
                        builder.appendMonthOfYearShortText();
                        break;
                    }
                    builder.appendMonthOfYear(tokenLen);
                    break;
                }
                case 'd': {
                    builder.appendDayOfMonth(tokenLen);
                    break;
                }
                case 'h': {
                    builder.appendClockhourOfHalfday(tokenLen);
                    break;
                }
                case 'H': {
                    builder.appendHourOfDay(tokenLen);
                    break;
                }
                case 'm': {
                    builder.appendMinuteOfHour(tokenLen);
                    break;
                }
                case 's': {
                    builder.appendSecondOfMinute(tokenLen);
                    break;
                }
                case 'S': {
                    builder.appendFractionOfSecond(tokenLen, tokenLen);
                    break;
                }
                case 'e': {
                    builder.appendDayOfWeek(tokenLen);
                    break;
                }
                case 'E': {
                    if (tokenLen >= 4) {
                        builder.appendDayOfWeekText();
                        break;
                    }
                    builder.appendDayOfWeekShortText();
                    break;
                }
                case 'D': {
                    builder.appendDayOfYear(tokenLen);
                    break;
                }
                case 'w': {
                    builder.appendWeekOfWeekyear(tokenLen);
                    break;
                }
                case 'a': {
                    builder.appendHalfdayOfDayText();
                    break;
                }
                case 'k': {
                    builder.appendClockhourOfDay(tokenLen);
                    break;
                }
                case 'K': {
                    builder.appendClockhourOfHalfday(tokenLen);
                    break;
                }
                case 'z': {
                    if (tokenLen >= 4) {
                        builder.appendTimeZoneName();
                        break;
                    }
                    builder.appendTimeZoneShortName();
                    break;
                }
                case 'Z': {
                    if (tokenLen >= 4) {
                        builder.appendTimeZoneOffset(null, true, 2, 2);
                        break;
                    }
                    builder.appendTimeZoneOffset(null, false, 2, 2);
                    break;
                }
                case '\'': {
                    String sub = token.substring(1);
                    if (sub.length() == 1) {
                        builder.appendLiteral(sub.charAt(0));
                        break;
                    }
                    builder.appendLiteral(new String(sub));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + token);
                }
            }
            ++i;
        }
    }

    private static String parseToken(String pattern, int[] indexRef) {
        StringBuffer buf = new StringBuffer();
        int i = indexRef[0];
        int length = pattern.length();
        char c = pattern.charAt(i);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            buf.append(c);
            while (i + 1 < length) {
                char peek = pattern.charAt(i + 1);
                if (peek == c) {
                    buf.append(c);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            buf.append('\'');
            boolean inLiteral = false;
            while (i < length) {
                c = pattern.charAt(i);
                if (c == '\'') {
                    if (i + 1 < length && pattern.charAt(i + 1) == '\'') {
                        ++i;
                        buf.append(c);
                    } else {
                        inLiteral = !inLiteral;
                    }
                } else {
                    if (!inLiteral && (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) break;
                    buf.append(c);
                }
                ++i;
            }
        }
        indexRef[0] = --i;
        return buf.toString();
    }

    private static boolean isNumericToken(String token) {
        int tokenLen = token.length();
        if (tokenLen > 0) {
            char c = token.charAt(0);
            switch (c) {
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'K': 
                case 'S': 
                case 'W': 
                case 'Y': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'k': 
                case 'm': 
                case 's': 
                case 'w': 
                case 'x': 
                case 'y': {
                    return true;
                }
                case 'M': {
                    if (tokenLen > 2) break;
                    return true;
                }
            }
        }
        return false;
    }

    private DateTimeFormat(Locale locale) {
        this.iLocale = locale;
    }

    public synchronized DateTimeFormatter forPattern(String pattern) {
        DateTimeFormatter formatter = (DateTimeFormatter)this.iPatternedCache.get(pattern);
        if (formatter != null) {
            return formatter;
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Invalid pattern specification");
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder(this.iLocale);
        DateTimeFormat.appendPatternTo(builder, pattern);
        if (builder.canBuildFormatter()) {
            formatter = builder.toFormatter();
        } else if (builder.canBuildPrinter()) {
            formatter = new FPrinter(builder.toPrinter());
        } else if (builder.canBuildParser()) {
            formatter = new FParser(builder.toParser());
        } else {
            throw new UnsupportedOperationException("Pattern unsupported: " + pattern);
        }
        this.iPatternedCache.put(pattern, formatter);
        return formatter;
    }

    public synchronized DateTimeFormatter forStyle(String style) {
        DateTimeFormatter formatter = (DateTimeFormatter)this.iStyledCache.get(style);
        if (formatter == null) {
            formatter = this.forPattern(this.getPatternForStyle(style));
            this.iStyledCache.put(style, formatter);
        }
        return formatter;
    }

    public String getPatternForStyle(String style) {
        if (style == null || style.length() != 2) {
            throw new IllegalArgumentException("Invalid style specification: " + style);
        }
        if (style.charAt(1) == '-') {
            return this.getDatePattern(style.charAt(0));
        }
        if (style.charAt(0) == '-') {
            return this.getTimePattern(style.charAt(1));
        }
        return this.getDateTimePattern(style.charAt(0), style.charAt(1));
    }

    private String getDatePattern(char style) {
        int istyle = this.selectStyle(style);
        try {
            return ((SimpleDateFormat)DateFormat.getDateInstance(istyle, this.iLocale)).toPattern();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No date pattern for locale: " + this.iLocale);
        }
    }

    private String getTimePattern(char style) {
        int istyle = this.selectStyle(style);
        try {
            return ((SimpleDateFormat)DateFormat.getTimeInstance(istyle, this.iLocale)).toPattern();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No time pattern for locale: " + this.iLocale);
        }
    }

    private String getDateTimePattern(char dateStyle, char timeStyle) {
        int idateStyle = this.selectStyle(dateStyle);
        int itimeStyle = this.selectStyle(dateStyle);
        try {
            return ((SimpleDateFormat)DateFormat.getDateTimeInstance(idateStyle, itimeStyle, this.iLocale)).toPattern();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No datetime pattern for locale: " + this.iLocale);
        }
    }

    private int selectStyle(char c) {
        switch (c) {
            case 'S': {
                return 3;
            }
            case 'M': {
                return 2;
            }
            case 'L': {
                return 1;
            }
            case 'F': {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid style character: " + c);
    }

    static class FParser
    implements DateTimeFormatter {
        private final DateTimeParser mParser;

        FParser(DateTimeParser parser) {
            this.mParser = parser;
        }

        public void printTo(StringBuffer buf, ReadableInstant instant) {
            throw this.unsupported();
        }

        public void printTo(Writer out, ReadableInstant instant) throws IOException {
            throw this.unsupported();
        }

        public void printTo(StringBuffer buf, long instant) {
            throw this.unsupported();
        }

        public void printTo(Writer out, long instant) throws IOException {
            throw this.unsupported();
        }

        public void printTo(StringBuffer buf, long instant, DateTimeZone zone) {
            throw this.unsupported();
        }

        public void printTo(Writer out, long instant, DateTimeZone zone) {
            throw this.unsupported();
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono) {
            throw this.unsupported();
        }

        public void printTo(Writer out, long instant, Chronology chrono) throws IOException {
            throw this.unsupported();
        }

        public void printTo(StringBuffer buf, ReadablePartial instant) {
            throw this.unsupported();
        }

        public void printTo(Writer out, ReadablePartial instant) throws IOException {
            throw this.unsupported();
        }

        public String print(ReadableInstant instant) {
            throw this.unsupported();
        }

        public String print(long instant) {
            throw this.unsupported();
        }

        public String print(long instant, DateTimeZone zone) {
            throw this.unsupported();
        }

        public String print(long instant, Chronology chrono) {
            throw this.unsupported();
        }

        public String print(ReadablePartial partial) {
            throw this.unsupported();
        }

        public int parseInto(ReadWritableInstant instant, String text, int position) {
            return this.mParser.parseInto(instant, text, position);
        }

        public long parseMillis(String text) {
            return this.mParser.parseMillis(text);
        }

        public long parseMillis(String text, Chronology chrono) {
            return this.mParser.parseMillis(text, chrono);
        }

        public long parseMillis(String text, long instant) {
            return this.mParser.parseMillis(text, instant);
        }

        public long parseMillis(String text, long instant, Chronology chrono) {
            return this.mParser.parseMillis(text, instant, chrono);
        }

        public DateTime parseDateTime(String text) {
            return this.mParser.parseDateTime(text);
        }

        public DateTime parseDateTime(String text, Chronology chrono) {
            return this.mParser.parseDateTime(text, chrono);
        }

        public DateTime parseDateTime(String text, ReadableInstant instant) {
            return this.mParser.parseDateTime(text, instant);
        }

        public MutableDateTime parseMutableDateTime(String text) {
            return this.mParser.parseMutableDateTime(text);
        }

        public MutableDateTime parseMutableDateTime(String text, Chronology chrono) {
            return this.mParser.parseMutableDateTime(text, chrono);
        }

        public MutableDateTime parseMutableDateTime(String text, ReadableInstant instant) {
            return this.mParser.parseMutableDateTime(text, instant);
        }

        private UnsupportedOperationException unsupported() {
            return new UnsupportedOperationException("Printing not supported");
        }
    }

    static class FPrinter
    implements DateTimeFormatter {
        private final DateTimePrinter mPrinter;

        FPrinter(DateTimePrinter printer) {
            this.mPrinter = printer;
        }

        public void printTo(StringBuffer buf, ReadableInstant instant) {
            this.mPrinter.printTo(buf, instant);
        }

        public void printTo(Writer out, ReadableInstant instant) throws IOException {
            this.mPrinter.printTo(out, instant);
        }

        public void printTo(StringBuffer buf, long instant) {
            this.mPrinter.printTo(buf, instant);
        }

        public void printTo(Writer out, long instant) throws IOException {
            this.mPrinter.printTo(out, instant);
        }

        public void printTo(StringBuffer buf, long instant, DateTimeZone zone) {
            this.mPrinter.printTo(buf, instant, zone);
        }

        public void printTo(Writer out, long instant, DateTimeZone zone) throws IOException {
            this.mPrinter.printTo(out, instant, zone);
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono) {
            this.mPrinter.printTo(buf, instant, chrono);
        }

        public void printTo(Writer out, long instant, Chronology chrono) throws IOException {
            this.mPrinter.printTo(out, instant, chrono);
        }

        public void printTo(StringBuffer buf, ReadablePartial instant) {
            this.mPrinter.printTo(buf, instant);
        }

        public void printTo(Writer out, ReadablePartial instant) throws IOException {
            this.mPrinter.printTo(out, instant);
        }

        public String print(ReadableInstant instant) {
            return this.mPrinter.print(instant);
        }

        public String print(long instant) {
            return this.mPrinter.print(instant);
        }

        public String print(long instant, DateTimeZone zone) {
            return this.mPrinter.print(instant, zone);
        }

        public String print(long instant, Chronology chrono) {
            return this.mPrinter.print(instant, chrono);
        }

        public String print(ReadablePartial partial) {
            return this.mPrinter.print(partial);
        }

        public int estimateParsedLength() {
            return 0;
        }

        public int parseInto(ReadWritableInstant instant, String text, int position) {
            throw this.unsupported();
        }

        public long parseMillis(String text) {
            throw this.unsupported();
        }

        public long parseMillis(String text, Chronology chrono) {
            throw this.unsupported();
        }

        public long parseMillis(String text, long instantLocal) {
            throw this.unsupported();
        }

        public long parseMillis(String text, long instant, Chronology chrono) {
            throw this.unsupported();
        }

        public DateTime parseDateTime(String text) {
            throw this.unsupported();
        }

        public DateTime parseDateTime(String text, Chronology chrono) {
            throw this.unsupported();
        }

        public DateTime parseDateTime(String text, ReadableInstant instant) {
            throw this.unsupported();
        }

        public MutableDateTime parseMutableDateTime(String text) {
            throw this.unsupported();
        }

        public MutableDateTime parseMutableDateTime(String text, Chronology chrono) {
            throw this.unsupported();
        }

        public MutableDateTime parseMutableDateTime(String text, ReadableInstant instant) {
            throw this.unsupported();
        }

        private UnsupportedOperationException unsupported() {
            return new UnsupportedOperationException("Parsing not supported");
        }
    }

    static class RemainderType
    extends DateTimeFieldType {
        private final DateTimeFieldType iWrappedType;
        private final DateTimeFieldType iType;
        private final int iDivisor;
        private transient RemainderDateTimeField iRecent;

        RemainderType(DateTimeFieldType wrappedType, DateTimeFieldType type, int divisor) {
            super(type.getName());
            this.iWrappedType = wrappedType;
            this.iType = type;
            this.iDivisor = divisor;
        }

        public DurationFieldType getDurationType() {
            return this.iType.getDurationType();
        }

        public DurationFieldType getRangeDurationType() {
            return this.iType.getRangeDurationType();
        }

        public DateTimeField getField(Chronology chrono) {
            DateTimeField wrappedField = this.iWrappedType.getField(chrono);
            RemainderDateTimeField field = this.iRecent;
            if (field.getWrappedField() == wrappedField) {
                return field;
            }
            this.iRecent = field = new RemainderDateTimeField(wrappedField, this.iType, this.iDivisor);
            return field;
        }
    }
}

