/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.tz.CachedDateTimeZone;
import org.joda.time.tz.FixedDateTimeZone;

public class DateTimeZoneBuilder {
    private final ArrayList iRuleSets = new ArrayList(10);

    public static DateTimeZone readFrom(InputStream in, String id) throws IOException {
        if (in instanceof DataInput) {
            return DateTimeZoneBuilder.readFrom((DataInput)((Object)in), id);
        }
        return DateTimeZoneBuilder.readFrom(new DataInputStream(in), id);
    }

    public static DateTimeZone readFrom(DataInput in, String id) throws IOException {
        switch (in.readUnsignedByte()) {
            case 70: {
                DateTimeZone fixed = new FixedDateTimeZone(id, in.readUTF(), (int)DateTimeZoneBuilder.readMillis(in), (int)DateTimeZoneBuilder.readMillis(in));
                if (((DateTimeZone)fixed).equals(DateTimeZone.UTC)) {
                    fixed = DateTimeZone.UTC;
                }
                return fixed;
            }
            case 67: {
                return CachedDateTimeZone.forZone(PrecalculatedZone.readFrom(in, id));
            }
            case 80: {
                return PrecalculatedZone.readFrom(in, id);
            }
        }
        throw new IOException("Invalid encoding");
    }

    static void writeMillis(DataOutput out, long millis) throws IOException {
        long seconds;
        long minutes;
        long units;
        if (millis % 1800000L == 0L && (units = millis / 1800000L) << 58 >> 58 == units) {
            out.writeByte((int)(units & 0x3FL));
            return;
        }
        if (millis % 60000L == 0L && (minutes = millis / 60000L) << 34 >> 34 == minutes) {
            out.writeInt(0x40000000 | (int)(minutes & 0x3FFFFFFFL));
            return;
        }
        if (millis % 1000L == 0L && (seconds = millis / 1000L) << 26 >> 26 == seconds) {
            out.writeByte(0x80 | (int)(seconds >> 32 & 0x3FL));
            out.writeInt((int)(seconds & 0xFFFFFFFFFFFFFFFFL));
            return;
        }
        out.writeByte(millis < 0L ? 255 : 192);
        out.writeLong(millis);
    }

    static long readMillis(DataInput in) throws IOException {
        int v = in.readUnsignedByte();
        switch (v >> 6) {
            default: {
                v = v << 26 >> 26;
                return (long)v * 1800000L;
            }
            case 1: {
                v = v << 26 >> 2;
                v |= in.readUnsignedByte() << 16;
                v |= in.readUnsignedByte() << 8;
                return (long)(v |= in.readUnsignedByte()) * 60000L;
            }
            case 2: {
                long w = (long)v << 58 >> 26;
                w |= (long)(in.readUnsignedByte() << 24);
                w |= (long)(in.readUnsignedByte() << 16);
                w |= (long)(in.readUnsignedByte() << 8);
                return (w |= (long)in.readUnsignedByte()) * 1000L;
            }
            case 3: 
        }
        return in.readLong();
    }

    private static DateTimeZone buildFixedZone(String id, String nameKey, int wallOffset, int standardOffset) {
        if ("UTC".equals(id) && id.equals(nameKey) && wallOffset == 0 && standardOffset == 0) {
            return DateTimeZone.UTC;
        }
        return new FixedDateTimeZone(id, nameKey, wallOffset, standardOffset);
    }

    public DateTimeZoneBuilder addCutover(int year, char mode, int monthOfYear, int dayOfMonth, int dayOfWeek, boolean advanceDayOfWeek, int millisOfDay) {
        OfYear ofYear = new OfYear(mode, monthOfYear, dayOfMonth, dayOfWeek, advanceDayOfWeek, millisOfDay);
        if (this.iRuleSets.size() > 0) {
            RuleSet lastRuleSet = (RuleSet)this.iRuleSets.get(this.iRuleSets.size() - 1);
            lastRuleSet.setUpperLimit(year, ofYear);
        }
        this.iRuleSets.add(new RuleSet());
        return this;
    }

    public DateTimeZoneBuilder setStandardOffset(int standardOffset) {
        this.getLastRuleSet().setStandardOffset(standardOffset);
        return this;
    }

    public DateTimeZoneBuilder setFixedSavings(String nameKey, int saveMillis) {
        this.getLastRuleSet().setFixedSavings(nameKey, saveMillis);
        return this;
    }

    public DateTimeZoneBuilder addRecurringSavings(String nameKey, int saveMillis, int fromYear, int toYear, char mode, int monthOfYear, int dayOfMonth, int dayOfWeek, boolean advanceDayOfWeek, int millisOfDay) {
        if (fromYear <= toYear) {
            OfYear ofYear = new OfYear(mode, monthOfYear, dayOfMonth, dayOfWeek, advanceDayOfWeek, millisOfDay);
            Recurrence recurrence = new Recurrence(ofYear, nameKey, saveMillis);
            Rule rule = new Rule(recurrence, fromYear, toYear);
            this.getLastRuleSet().addRule(rule);
        }
        return this;
    }

    private RuleSet getLastRuleSet() {
        if (this.iRuleSets.size() == 0) {
            this.addCutover(Integer.MIN_VALUE, 'w', 1, 1, 0, false, 0);
        }
        return (RuleSet)this.iRuleSets.get(this.iRuleSets.size() - 1);
    }

    public DateTimeZone toDateTimeZone(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        ArrayList transitions = new ArrayList();
        DSTZone tailZone = null;
        long millis = Long.MIN_VALUE;
        int saveMillis = 0;
        int ruleSetCount = this.iRuleSets.size();
        int i = 0;
        while (i < ruleSetCount) {
            RuleSet rs = (RuleSet)this.iRuleSets.get(i);
            Transition next = rs.firstTransition(millis);
            if (next != null) {
                this.addTransition(transitions, next);
                millis = next.getMillis();
                saveMillis = next.getSaveMillis();
                rs = new RuleSet(rs);
                while ((next = rs.nextTransition(millis, saveMillis)) != null) {
                    if (this.addTransition(transitions, next) && tailZone != null) break;
                    millis = next.getMillis();
                    saveMillis = next.getSaveMillis();
                    if (tailZone != null || i != ruleSetCount - 1) continue;
                    tailZone = rs.buildTailZone(id);
                }
                millis = rs.getUpperLimit(saveMillis);
            }
            ++i;
        }
        if (transitions.size() == 0) {
            if (tailZone != null) {
                return tailZone;
            }
            return DateTimeZoneBuilder.buildFixedZone(id, "UTC", 0, 0);
        }
        if (transitions.size() == 1 && tailZone == null) {
            Transition tr = (Transition)transitions.get(0);
            return DateTimeZoneBuilder.buildFixedZone(id, tr.getNameKey(), tr.getWallOffset(), tr.getStandardOffset());
        }
        PrecalculatedZone zone = new PrecalculatedZone(id, transitions, tailZone);
        if (zone.isCachable()) {
            return CachedDateTimeZone.forZone(zone);
        }
        return zone;
    }

    private boolean addTransition(ArrayList transitions, Transition tr) {
        int size = transitions.size();
        if (size == 0) {
            transitions.add(tr);
            return true;
        }
        Transition last = (Transition)transitions.get(size - 1);
        if (!tr.isTransitionFrom(last)) {
            return false;
        }
        int offsetForLast = 0;
        if (size >= 2) {
            offsetForLast = ((Transition)transitions.get(size - 2)).getWallOffset();
        }
        int offsetForNew = last.getWallOffset();
        long lastLocal = last.getMillis() + (long)offsetForLast;
        long newLocal = tr.getMillis() + (long)offsetForNew;
        if (newLocal != lastLocal) {
            transitions.add(tr);
            return true;
        }
        transitions.remove(size - 1);
        return this.addTransition(transitions, tr);
    }

    public void writeTo(OutputStream out) throws IOException {
        if (out instanceof DataOutput) {
            this.writeTo((DataOutput)((Object)out));
        } else {
            this.writeTo(new DataOutputStream(out));
        }
    }

    public void writeTo(DataOutput out) throws IOException {
        DateTimeZone zone = this.toDateTimeZone("");
        if (zone instanceof FixedDateTimeZone) {
            out.writeByte(70);
            out.writeUTF(zone.getNameKey(0L));
            DateTimeZoneBuilder.writeMillis(out, zone.getOffset(0L));
            DateTimeZoneBuilder.writeMillis(out, zone.getStandardOffset(0L));
        } else {
            if (zone instanceof CachedDateTimeZone) {
                out.writeByte(67);
                zone = ((CachedDateTimeZone)zone).getUncachedZone();
            } else {
                out.writeByte(80);
            }
            ((PrecalculatedZone)zone).writeTo(out);
        }
    }

    private static final class PrecalculatedZone
    extends DateTimeZone {
        private static final long serialVersionUID = 7811976468055766265L;
        private final long[] iTransitions;
        private final int[] iWallOffsets;
        private final int[] iStandardOffsets;
        private final String[] iNameKeys;
        private final DSTZone iTailZone;

        static PrecalculatedZone readFrom(DataInput in, String id) throws IOException {
            int poolSize = in.readUnsignedShort();
            String[] pool = new String[poolSize];
            int i = 0;
            while (i < poolSize) {
                pool[i] = in.readUTF();
                ++i;
            }
            int size = in.readInt();
            long[] transitions = new long[size];
            int[] wallOffsets = new int[size];
            int[] standardOffsets = new int[size];
            String[] nameKeys = new String[size];
            int i2 = 0;
            while (i2 < size) {
                transitions[i2] = DateTimeZoneBuilder.readMillis(in);
                wallOffsets[i2] = (int)DateTimeZoneBuilder.readMillis(in);
                standardOffsets[i2] = (int)DateTimeZoneBuilder.readMillis(in);
                try {
                    int index = poolSize < 256 ? in.readUnsignedByte() : in.readUnsignedShort();
                    nameKeys[i2] = pool[index];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IOException("Invalid encoding");
                }
                ++i2;
            }
            DSTZone tailZone = null;
            if (in.readBoolean()) {
                tailZone = DSTZone.readFrom(in, id);
            }
            return new PrecalculatedZone(id, transitions, wallOffsets, standardOffsets, nameKeys, tailZone);
        }

        PrecalculatedZone(String id, long[] transitions, int[] wallOffsets, int[] standardOffsets, String[] nameKeys, DSTZone tailZone) {
            super(id);
            this.iTransitions = transitions;
            this.iWallOffsets = wallOffsets;
            this.iStandardOffsets = standardOffsets;
            this.iNameKeys = nameKeys;
            this.iTailZone = tailZone;
        }

        PrecalculatedZone(String id, ArrayList transitions, DSTZone tailZone) {
            super(id);
            int size = transitions.size();
            if (size == 0) {
                throw new IllegalArgumentException();
            }
            this.iTransitions = new long[size];
            this.iWallOffsets = new int[size];
            this.iStandardOffsets = new int[size];
            this.iNameKeys = new String[size];
            Transition last = null;
            int i = 0;
            while (i < size) {
                Transition tr = (Transition)transitions.get(i);
                if (!tr.isTransitionFrom(last)) {
                    throw new IllegalArgumentException(id);
                }
                this.iTransitions[i] = tr.getMillis();
                this.iWallOffsets[i] = tr.getWallOffset();
                this.iStandardOffsets[i] = tr.getStandardOffset();
                this.iNameKeys[i] = tr.getNameKey();
                last = tr;
                ++i;
            }
            this.iTailZone = tailZone;
        }

        public String getNameKey(long instant) {
            long[] transitions = this.iTransitions;
            int i = Arrays.binarySearch(transitions, instant);
            if (i >= 0) {
                return this.iNameKeys[i];
            }
            if ((i ^= 0xFFFFFFFF) < transitions.length) {
                if (i > 0) {
                    return this.iNameKeys[i - 1];
                }
                return "UTC";
            }
            if (this.iTailZone == null) {
                return this.iNameKeys[i - 1];
            }
            return this.iTailZone.getNameKey(instant);
        }

        public int getOffset(long instant) {
            long[] transitions = this.iTransitions;
            int i = Arrays.binarySearch(transitions, instant);
            if (i >= 0) {
                return this.iWallOffsets[i];
            }
            if ((i ^= 0xFFFFFFFF) < transitions.length) {
                if (i > 0) {
                    return this.iWallOffsets[i - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iWallOffsets[i - 1];
            }
            return this.iTailZone.getOffset(instant);
        }

        public int getStandardOffset(long instant) {
            long[] transitions = this.iTransitions;
            int i = Arrays.binarySearch(transitions, instant);
            if (i >= 0) {
                return this.iStandardOffsets[i];
            }
            if ((i ^= 0xFFFFFFFF) < transitions.length) {
                if (i > 0) {
                    return this.iStandardOffsets[i - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iStandardOffsets[i - 1];
            }
            return this.iTailZone.getStandardOffset(instant);
        }

        public boolean isFixed() {
            return false;
        }

        public long nextTransition(long instant) {
            long[] transitions = this.iTransitions;
            int i = Arrays.binarySearch(transitions, instant);
            int n = i = i >= 0 ? i + 1 : ~i;
            if (i < transitions.length) {
                return transitions[i];
            }
            if (this.iTailZone == null) {
                return instant;
            }
            long end = transitions[transitions.length - 1];
            if (instant < end) {
                instant = end;
            }
            return this.iTailZone.nextTransition(instant);
        }

        public long previousTransition(long instant) {
            long prev;
            long[] transitions = this.iTransitions;
            int i = Arrays.binarySearch(transitions, instant);
            if (i >= 0) {
                if (instant > Long.MIN_VALUE) {
                    return instant - 1L;
                }
                return instant;
            }
            if ((i ^= 0xFFFFFFFF) < transitions.length) {
                long prev2;
                if (i > 0 && (prev2 = transitions[i - 1]) > Long.MIN_VALUE) {
                    return prev2 - 1L;
                }
                return instant;
            }
            if (this.iTailZone != null && (prev = this.iTailZone.previousTransition(instant)) < instant) {
                return prev;
            }
            prev = transitions[i - 1];
            if (prev > Long.MIN_VALUE) {
                return prev - 1L;
            }
            return instant;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PrecalculatedZone)) return false;
            PrecalculatedZone other = (PrecalculatedZone)obj;
            if (!this.getID().equals(other.getID())) return false;
            if (!Arrays.equals(this.iTransitions, other.iTransitions)) return false;
            if (!Arrays.equals(this.iNameKeys, other.iNameKeys)) return false;
            if (!Arrays.equals(this.iWallOffsets, other.iWallOffsets)) return false;
            if (!Arrays.equals(this.iStandardOffsets, other.iStandardOffsets)) return false;
            if (this.iTailZone == null) {
                if (null != other.iTailZone) return false;
                return true;
            }
            boolean bl = this.iTailZone.equals(other.iTailZone);
            if (!bl) return false;
            return true;
        }

        public void writeTo(DataOutput out) throws IOException {
            int size = this.iTransitions.length;
            HashSet<String> poolSet = new HashSet<String>();
            int i = 0;
            while (i < size) {
                poolSet.add(this.iNameKeys[i]);
                ++i;
            }
            int poolSize = poolSet.size();
            if (poolSize > 65535) {
                throw new UnsupportedOperationException("String pool is too large");
            }
            String[] pool = new String[poolSize];
            Iterator it = poolSet.iterator();
            int i2 = 0;
            while (it.hasNext()) {
                pool[i2] = (String)it.next();
                ++i2;
            }
            out.writeShort(poolSize);
            int i3 = 0;
            while (i3 < poolSize) {
                out.writeUTF(pool[i3]);
                ++i3;
            }
            out.writeInt(size);
            int i4 = 0;
            while (i4 < size) {
                DateTimeZoneBuilder.writeMillis(out, this.iTransitions[i4]);
                DateTimeZoneBuilder.writeMillis(out, this.iWallOffsets[i4]);
                DateTimeZoneBuilder.writeMillis(out, this.iStandardOffsets[i4]);
                String nameKey = this.iNameKeys[i4];
                int j = 0;
                while (j < poolSize) {
                    if (pool[j].equals(nameKey)) {
                        if (poolSize < 256) {
                            out.writeByte(j);
                            break;
                        }
                        out.writeShort(j);
                        break;
                    }
                    ++j;
                }
                ++i4;
            }
            out.writeBoolean(this.iTailZone != null);
            if (this.iTailZone != null) {
                this.iTailZone.writeTo(out);
            }
        }

        public boolean isCachable() {
            if (this.iTailZone != null) {
                return true;
            }
            long[] transitions = this.iTransitions;
            if (transitions.length <= 1) {
                return false;
            }
            double distances = 0.0;
            int count = 0;
            int i = 1;
            while (i < transitions.length) {
                long diff = transitions[i] - transitions[i - 1];
                if (diff < 63158400000L) {
                    distances += (double)diff;
                    ++count;
                }
                ++i;
            }
            if (count > 0) {
                double avg = distances / (double)count;
                if ((avg /= 8.64E7) >= 25.0) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class DSTZone
    extends DateTimeZone {
        private static final long serialVersionUID = 6941492635554961361L;
        private final int iStandardOffset;
        private final Recurrence iStartRecurrence;
        private final Recurrence iEndRecurrence;

        static DSTZone readFrom(DataInput in, String id) throws IOException {
            return new DSTZone(id, (int)DateTimeZoneBuilder.readMillis(in), Recurrence.readFrom(in), Recurrence.readFrom(in));
        }

        DSTZone(String id, int standardOffset, Recurrence startRecurrence, Recurrence endRecurrence) {
            super(id);
            this.iStandardOffset = standardOffset;
            this.iStartRecurrence = startRecurrence;
            this.iEndRecurrence = endRecurrence;
        }

        public String getNameKey(long instant) {
            return this.findMatchingRecurrence(instant).getNameKey();
        }

        public int getOffset(long instant) {
            return this.iStandardOffset + this.findMatchingRecurrence(instant).getSaveMillis();
        }

        public int getStandardOffset(long instant) {
            return this.iStandardOffset;
        }

        public boolean isFixed() {
            return false;
        }

        public long nextTransition(long instant) {
            long end;
            long start;
            int standardOffset = this.iStandardOffset;
            Recurrence startRecurrence = this.iStartRecurrence;
            Recurrence endRecurrence = this.iEndRecurrence;
            try {
                start = startRecurrence.next(instant, standardOffset, endRecurrence.getSaveMillis());
                if (instant > 0L && start < 0L) {
                    start = instant;
                }
            }
            catch (IllegalArgumentException e) {
                start = instant;
            }
            try {
                end = endRecurrence.next(instant, standardOffset, startRecurrence.getSaveMillis());
                if (instant > 0L && end < 0L) {
                    end = instant;
                }
            }
            catch (IllegalArgumentException e) {
                end = instant;
            }
            return start > end ? end : start;
        }

        public long previousTransition(long instant) {
            long end;
            long start;
            ++instant;
            int standardOffset = this.iStandardOffset;
            Recurrence startRecurrence = this.iStartRecurrence;
            Recurrence endRecurrence = this.iEndRecurrence;
            try {
                start = startRecurrence.previous(instant, standardOffset, endRecurrence.getSaveMillis());
                if (instant < 0L && start > 0L) {
                    start = instant;
                }
            }
            catch (IllegalArgumentException e) {
                start = instant;
            }
            try {
                end = endRecurrence.previous(instant, standardOffset, startRecurrence.getSaveMillis());
                if (instant < 0L && end > 0L) {
                    end = instant;
                }
            }
            catch (IllegalArgumentException e) {
                end = instant;
            }
            return (start > end ? start : end) - 1L;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof DSTZone) {
                DSTZone other = (DSTZone)obj;
                return this.getID().equals(other.getID()) && this.iStandardOffset == other.iStandardOffset && this.iStartRecurrence.equals(other.iStartRecurrence) && this.iEndRecurrence.equals(other.iEndRecurrence);
            }
            return false;
        }

        public void writeTo(DataOutput out) throws IOException {
            DateTimeZoneBuilder.writeMillis(out, this.iStandardOffset);
            this.iStartRecurrence.writeTo(out);
            this.iEndRecurrence.writeTo(out);
        }

        private Recurrence findMatchingRecurrence(long instant) {
            long end;
            long start;
            int standardOffset = this.iStandardOffset;
            Recurrence startRecurrence = this.iStartRecurrence;
            Recurrence endRecurrence = this.iEndRecurrence;
            try {
                start = startRecurrence.next(instant, standardOffset, endRecurrence.getSaveMillis());
            }
            catch (IllegalArgumentException e) {
                start = instant;
            }
            try {
                end = endRecurrence.next(instant, standardOffset, startRecurrence.getSaveMillis());
            }
            catch (IllegalArgumentException e) {
                end = instant;
            }
            return start > end ? startRecurrence : endRecurrence;
        }
    }

    private static final class RuleSet {
        private static final int YEAR_LIMIT;
        private int iStandardOffset;
        private ArrayList iRules;
        private String iInitialNameKey;
        private int iInitialSaveMillis;
        private int iUpperYear;
        private OfYear iUpperOfYear;

        RuleSet() {
            this.iRules = new ArrayList(10);
            this.iUpperYear = Integer.MAX_VALUE;
        }

        RuleSet(RuleSet rs) {
            this.iStandardOffset = rs.iStandardOffset;
            this.iRules = new ArrayList(rs.iRules);
            this.iInitialNameKey = rs.iInitialNameKey;
            this.iInitialSaveMillis = rs.iInitialSaveMillis;
            this.iUpperYear = rs.iUpperYear;
            this.iUpperOfYear = rs.iUpperOfYear;
        }

        public int getStandardOffset() {
            return this.iStandardOffset;
        }

        public void setStandardOffset(int standardOffset) {
            this.iStandardOffset = standardOffset;
        }

        public void setFixedSavings(String nameKey, int saveMillis) {
            this.iInitialNameKey = nameKey;
            this.iInitialSaveMillis = saveMillis;
        }

        public void addRule(Rule rule) {
            if (!this.iRules.contains(rule)) {
                this.iRules.add(rule);
            }
        }

        public void setUpperLimit(int year, OfYear ofYear) {
            this.iUpperYear = year;
            this.iUpperOfYear = ofYear;
        }

        /*
         * WARNING - void declaration
         */
        public Transition firstTransition(long firstMillis) {
            Transition next;
            if (this.iInitialNameKey != null) {
                return new Transition(firstMillis, this.iInitialNameKey, this.iStandardOffset + this.iInitialSaveMillis, this.iStandardOffset);
            }
            ArrayList copy = new ArrayList(this.iRules);
            long millis = Long.MIN_VALUE;
            int saveMillis = 0;
            Transition first = null;
            while ((next = this.nextTransition(millis, saveMillis)) != null) {
                void var8_6;
                millis = var8_6.getMillis();
                if (millis == firstMillis) {
                    first = new Transition(firstMillis, (Transition)var8_6);
                    break;
                }
                if (millis > firstMillis) {
                    if (first == null) {
                        Iterator it = ((AbstractList)copy).iterator();
                        while (it.hasNext()) {
                            Rule rule = (Rule)it.next();
                            if (rule.getSaveMillis() != 0) continue;
                            first = new Transition(firstMillis, rule, this.iStandardOffset);
                            break;
                        }
                    }
                    if (first != null) break;
                    first = new Transition(firstMillis, var8_6.getNameKey(), this.iStandardOffset, this.iStandardOffset);
                    break;
                }
                first = new Transition(firstMillis, (Transition)var8_6);
                saveMillis = var8_6.getSaveMillis();
            }
            this.iRules = copy;
            return first;
        }

        public Transition nextTransition(long instant, int saveMillis) {
            long upperMillis;
            ISOChronology chrono = ISOChronology.getInstanceUTC();
            Rule nextRule = null;
            long nextMillis = Long.MAX_VALUE;
            Iterator it = ((AbstractList)this.iRules).iterator();
            while (it.hasNext()) {
                Rule rule = (Rule)it.next();
                long next = rule.next(instant, this.iStandardOffset, saveMillis);
                if (next <= instant) {
                    it.remove();
                    continue;
                }
                if (next > nextMillis) continue;
                nextRule = rule;
                nextMillis = next;
            }
            if (nextRule == null) {
                return null;
            }
            if (((Chronology)chrono).year().get(nextMillis) >= YEAR_LIMIT) {
                return null;
            }
            if (this.iUpperYear < Integer.MAX_VALUE && nextMillis >= (upperMillis = this.iUpperOfYear.setInstant(this.iUpperYear, this.iStandardOffset, saveMillis))) {
                return null;
            }
            return new Transition(nextMillis, nextRule, this.iStandardOffset);
        }

        public long getUpperLimit(int saveMillis) {
            if (this.iUpperYear == Integer.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            return this.iUpperOfYear.setInstant(this.iUpperYear, this.iStandardOffset, saveMillis);
        }

        public DSTZone buildTailZone(String id) {
            if (this.iRules.size() == 2) {
                Rule startRule = (Rule)this.iRules.get(0);
                Rule endRule = (Rule)this.iRules.get(1);
                if (startRule.getToYear() == Integer.MAX_VALUE && endRule.getToYear() == Integer.MAX_VALUE) {
                    return new DSTZone(id, this.iStandardOffset, startRule.iRecurrence, endRule.iRecurrence);
                }
            }
            return null;
        }

        static {
            long now = DateTimeUtils.currentTimeMillis();
            YEAR_LIMIT = ISOChronology.getInstanceUTC().year().get(now) + 100;
        }
    }

    private static final class Transition {
        private final long iMillis;
        private final String iNameKey;
        private final int iWallOffset;
        private final int iStandardOffset;

        Transition(long millis, Transition tr) {
            this.iMillis = millis;
            this.iNameKey = tr.iNameKey;
            this.iWallOffset = tr.iWallOffset;
            this.iStandardOffset = tr.iStandardOffset;
        }

        Transition(long millis, Rule rule, int standardOffset) {
            this.iMillis = millis;
            this.iNameKey = rule.getNameKey();
            this.iWallOffset = standardOffset + rule.getSaveMillis();
            this.iStandardOffset = standardOffset;
        }

        Transition(long millis, String nameKey, int wallOffset, int standardOffset) {
            this.iMillis = millis;
            this.iNameKey = nameKey;
            this.iWallOffset = wallOffset;
            this.iStandardOffset = standardOffset;
        }

        public long getMillis() {
            return this.iMillis;
        }

        public String getNameKey() {
            return this.iNameKey;
        }

        public int getWallOffset() {
            return this.iWallOffset;
        }

        public int getStandardOffset() {
            return this.iStandardOffset;
        }

        public int getSaveMillis() {
            return this.iWallOffset - this.iStandardOffset;
        }

        public boolean isTransitionFrom(Transition other) {
            if (other == null) {
                return true;
            }
            return this.iMillis > other.iMillis && (this.iWallOffset != other.iWallOffset || !this.iNameKey.equals(other.iNameKey));
        }
    }

    private static final class Rule {
        final Recurrence iRecurrence;
        final int iFromYear;
        final int iToYear;

        Rule(Recurrence recurrence, int fromYear, int toYear) {
            this.iRecurrence = recurrence;
            this.iFromYear = fromYear;
            this.iToYear = toYear;
        }

        public int getFromYear() {
            return this.iFromYear;
        }

        public int getToYear() {
            return this.iToYear;
        }

        public OfYear getOfYear() {
            return this.iRecurrence.getOfYear();
        }

        public String getNameKey() {
            return this.iRecurrence.getNameKey();
        }

        public int getSaveMillis() {
            return this.iRecurrence.getSaveMillis();
        }

        public long next(long instant, int standardOffset, int saveMillis) {
            long next;
            ISOChronology chrono = ISOChronology.getInstanceUTC();
            int wallOffset = standardOffset + saveMillis;
            long testInstant = instant;
            int year = instant == Long.MIN_VALUE ? Integer.MIN_VALUE : ((Chronology)chrono).year().get(instant + (long)wallOffset);
            if (year < this.iFromYear) {
                testInstant = ((Chronology)chrono).year().set(0L, this.iFromYear) - (long)wallOffset;
                --testInstant;
            }
            if ((next = this.iRecurrence.next(testInstant, standardOffset, saveMillis)) > instant && (year = ((Chronology)chrono).year().get(next + (long)wallOffset)) > this.iToYear) {
                next = instant;
            }
            return next;
        }
    }

    private static final class Recurrence {
        final OfYear iOfYear;
        final String iNameKey;
        final int iSaveMillis;

        static Recurrence readFrom(DataInput in) throws IOException {
            return new Recurrence(OfYear.readFrom(in), in.readUTF(), (int)DateTimeZoneBuilder.readMillis(in));
        }

        Recurrence(OfYear ofYear, String nameKey, int saveMillis) {
            this.iOfYear = ofYear;
            this.iNameKey = nameKey;
            this.iSaveMillis = saveMillis;
        }

        public OfYear getOfYear() {
            return this.iOfYear;
        }

        public long next(long instant, int standardOffset, int saveMillis) {
            return this.iOfYear.next(instant, standardOffset, saveMillis);
        }

        public long previous(long instant, int standardOffset, int saveMillis) {
            return this.iOfYear.previous(instant, standardOffset, saveMillis);
        }

        public String getNameKey() {
            return this.iNameKey;
        }

        public int getSaveMillis() {
            return this.iSaveMillis;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Recurrence) {
                Recurrence other = (Recurrence)obj;
                return this.iSaveMillis == other.iSaveMillis && this.iNameKey.equals(other.iNameKey) && this.iOfYear.equals(other.iOfYear);
            }
            return false;
        }

        public void writeTo(DataOutput out) throws IOException {
            this.iOfYear.writeTo(out);
            out.writeUTF(this.iNameKey);
            DateTimeZoneBuilder.writeMillis(out, this.iSaveMillis);
        }
    }

    private static final class OfYear {
        final char iMode;
        final int iMonthOfYear;
        final int iDayOfMonth;
        final int iDayOfWeek;
        final boolean iAdvance;
        final int iMillisOfDay;

        static OfYear readFrom(DataInput in) throws IOException {
            return new OfYear((char)in.readUnsignedByte(), in.readUnsignedByte(), in.readByte(), in.readUnsignedByte(), in.readBoolean(), (int)DateTimeZoneBuilder.readMillis(in));
        }

        OfYear(char mode, int monthOfYear, int dayOfMonth, int dayOfWeek, boolean advanceDayOfWeek, int millisOfDay) {
            if (mode != 'u' && mode != 'w' && mode != 's') {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
            this.iMode = mode;
            this.iMonthOfYear = monthOfYear;
            this.iDayOfMonth = dayOfMonth;
            this.iDayOfWeek = dayOfWeek;
            this.iAdvance = advanceDayOfWeek;
            this.iMillisOfDay = millisOfDay;
        }

        public long setInstant(int year, int standardOffset, int saveMillis) {
            int offset = this.iMode == 'w' ? standardOffset + saveMillis : (this.iMode == 's' ? standardOffset : 0);
            ISOChronology chrono = ISOChronology.getInstanceUTC();
            long millis = ((Chronology)chrono).year().set(0L, year);
            millis = ((Chronology)chrono).monthOfYear().set(millis, this.iMonthOfYear);
            millis = ((Chronology)chrono).millisOfDay().set(millis, this.iMillisOfDay);
            millis = this.setDayOfMonth(chrono, millis);
            if (this.iDayOfWeek != 0) {
                millis = this.setDayOfWeek(chrono, millis);
            }
            return millis - (long)offset;
        }

        public long next(long instant, int standardOffset, int saveMillis) {
            int offset = this.iMode == 'w' ? standardOffset + saveMillis : (this.iMode == 's' ? standardOffset : 0);
            ISOChronology chrono = ISOChronology.getInstanceUTC();
            long next = ((Chronology)chrono).monthOfYear().set(instant += (long)offset, this.iMonthOfYear);
            next = ((Chronology)chrono).millisOfDay().set(next, 0);
            next = ((Chronology)chrono).millisOfDay().add(next, this.iMillisOfDay);
            next = this.setDayOfMonthNext(chrono, next);
            if (this.iDayOfWeek == 0) {
                if (next <= instant) {
                    next = ((Chronology)chrono).year().add(next, 1);
                    next = this.setDayOfMonthNext(chrono, next);
                }
            } else if ((next = this.setDayOfWeek(chrono, next)) <= instant) {
                next = ((Chronology)chrono).year().add(next, 1);
                next = ((Chronology)chrono).monthOfYear().set(next, this.iMonthOfYear);
                next = this.setDayOfMonthNext(chrono, next);
                next = this.setDayOfWeek(chrono, next);
            }
            return next - (long)offset;
        }

        public long previous(long instant, int standardOffset, int saveMillis) {
            int offset = this.iMode == 'w' ? standardOffset + saveMillis : (this.iMode == 's' ? standardOffset : 0);
            ISOChronology chrono = ISOChronology.getInstanceUTC();
            long prev = ((Chronology)chrono).monthOfYear().set(instant += (long)offset, this.iMonthOfYear);
            prev = ((Chronology)chrono).millisOfDay().set(prev, 0);
            prev = ((Chronology)chrono).millisOfDay().add(prev, this.iMillisOfDay);
            prev = this.setDayOfMonthPrevious(chrono, prev);
            if (this.iDayOfWeek == 0) {
                if (prev >= instant) {
                    prev = ((Chronology)chrono).year().add(prev, -1);
                    prev = this.setDayOfMonthPrevious(chrono, prev);
                }
            } else if ((prev = this.setDayOfWeek(chrono, prev)) >= instant) {
                prev = ((Chronology)chrono).year().add(prev, -1);
                prev = ((Chronology)chrono).monthOfYear().set(prev, this.iMonthOfYear);
                prev = this.setDayOfMonthPrevious(chrono, prev);
                prev = this.setDayOfWeek(chrono, prev);
            }
            return prev - (long)offset;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OfYear) {
                OfYear other = (OfYear)obj;
                return this.iMode == other.iMode && this.iMonthOfYear == other.iMonthOfYear && this.iDayOfMonth == other.iDayOfMonth && this.iDayOfWeek == other.iDayOfWeek && this.iAdvance == other.iAdvance && this.iMillisOfDay == other.iMillisOfDay;
            }
            return false;
        }

        public void writeTo(DataOutput out) throws IOException {
            out.writeByte(this.iMode);
            out.writeByte(this.iMonthOfYear);
            out.writeByte(this.iDayOfMonth);
            out.writeByte(this.iDayOfWeek);
            out.writeBoolean(this.iAdvance);
            DateTimeZoneBuilder.writeMillis(out, this.iMillisOfDay);
        }

        /*
         * Unable to fully structure code
         */
        private long setDayOfMonthNext(Chronology chrono, long next) {
            block3: {
                block4: {
                    try {
                        next = this.setDayOfMonth(chrono, next);
                        break block3;
                    }
                    catch (IllegalArgumentException e) {
                        if (this.iMonthOfYear != 2 || this.iDayOfMonth != 29) break block4;
                        ** while (!chrono.year().isLeap((long)next))
                    }
lbl-1000:
                    // 1 sources

                    {
                        next = chrono.year().add(next, 1);
                        continue;
                    }
lbl9:
                    // 1 sources

                    next = this.setDayOfMonth(chrono, next);
                    break block3;
                }
                throw e;
            }
            return next;
        }

        /*
         * Unable to fully structure code
         */
        private long setDayOfMonthPrevious(Chronology chrono, long prev) {
            block3: {
                block4: {
                    try {
                        prev = this.setDayOfMonth(chrono, prev);
                        break block3;
                    }
                    catch (IllegalArgumentException e) {
                        if (this.iMonthOfYear != 2 || this.iDayOfMonth != 29) break block4;
                        ** while (!chrono.year().isLeap((long)prev))
                    }
lbl-1000:
                    // 1 sources

                    {
                        prev = chrono.year().add(prev, -1);
                        continue;
                    }
lbl9:
                    // 1 sources

                    prev = this.setDayOfMonth(chrono, prev);
                    break block3;
                }
                throw e;
            }
            return prev;
        }

        private long setDayOfMonth(Chronology chrono, long instant) {
            if (this.iDayOfMonth >= 0) {
                instant = chrono.dayOfMonth().set(instant, this.iDayOfMonth);
            } else {
                instant = chrono.dayOfMonth().set(instant, 1);
                instant = chrono.monthOfYear().add(instant, 1);
                instant = chrono.dayOfMonth().add(instant, this.iDayOfMonth);
            }
            return instant;
        }

        private long setDayOfWeek(Chronology chrono, long instant) {
            int dayOfWeek = chrono.dayOfWeek().get(instant);
            int daysToAdd = this.iDayOfWeek - dayOfWeek;
            if (daysToAdd != 0) {
                if (this.iAdvance) {
                    if (daysToAdd < 0) {
                        daysToAdd += 7;
                    }
                } else if (daysToAdd > 0) {
                    daysToAdd -= 7;
                }
                instant = chrono.dayOfWeek().add(instant, daysToAdd);
            }
            return instant;
        }
    }
}

