/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.session;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.apache.log4j.Logger;
import org.hibernate.id.UUIDHexGenerator;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.web.session.SessionVisitor;

public class SessionManager {
    private static final Logger log = Logger.getLogger(SessionManager.class);
    private static SessionManager sessionMgr;
    private Map sessionContainer = new ConcurrentReaderHashMap();
    private ThreadLocal currentSessionIdContainer = new ThreadLocal();
    private Monitor monitor;
    private short monitorPeriod = (short)20;

    private static SessionManager getInstance() {
        if (sessionMgr == null) {
            log.error((Object)"init SessionManager failed");
        }
        return sessionMgr;
    }

    public static HttpSession getSession() {
        String sessionId = (String)SessionManager.getInstance().currentSessionIdContainer.get();
        return SessionManager.getSession(sessionId);
    }

    public static HttpSession getSession(String sessionId) {
        if (sessionId == null) {
            log.error((Object)"Failed on finding current system session with null sessionId");
            return null;
        }
        return (HttpSession)SessionManager.getInstance().sessionContainer.get(sessionId);
    }

    static void createSession(String sessionId) {
        SessionManager sessionManager = SessionManager.getInstance();
        sessionManager.getClass();
        SessionImpl session = sessionManager.new SessionImpl(sessionId);
        SessionManager.getInstance().sessionContainer.put(sessionId, session);
        log.debug((Object)("SessionManager: creating new session " + sessionId));
    }

    static SessionVisitor getSessionVisitor() {
        return (SessionVisitor)SessionManager.getSession();
    }

    static void setCurrentSessionId(String currentSessionId) {
        SessionManager.getInstance().currentSessionIdContainer.set(currentSessionId);
    }

    public void init() {
        if (sessionMgr == null) {
            sessionMgr = this;
            if (this.monitorPeriod > 0) {
                this.monitor = new Monitor();
                this.monitor.start();
            }
        }
    }

    public void destroy() {
        if (this.monitor != null) {
            sessionMgr = null;
            this.monitor.stop();
            this.monitor = null;
        }
    }

    public short getMonitorPeriod() {
        return this.monitorPeriod;
    }

    public void setMonitorPeriod(short monitorPeriod) {
        this.monitorPeriod = monitorPeriod;
    }

    public static void startSession(ServletRequest req, ServletResponse res) {
        Cookie ssoCookie = SessionManager.findCookie((HttpServletRequest)req, "JSESSIONIDSSO");
        if (ssoCookie == null) {
            log.debug((Object)"==>Couldn't find the sso cookie");
            String value = (String)((Object)new UUIDHexGenerator().generate(null, null));
            ssoCookie = SessionManager.createCookie((HttpServletResponse)res, "JSESSIONIDSSO", value);
            log.debug((Object)("==>Created one - " + ssoCookie.getValue()));
        }
        Cookie cookie = SessionManager.findCookie((HttpServletRequest)req, "JSESSIONID");
        String currentSessionId = null;
        if (cookie != null) {
            currentSessionId = cookie.getValue();
            HttpSession obj = SessionManager.getSession(currentSessionId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SessionManager: cookie is not null, currentSessionId=" + currentSessionId + " session=" + obj));
            }
            if (obj == null) {
                SessionManager.createSession(currentSessionId);
            }
        }
        if (cookie == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SessionManager: cookie is null, generating a new session");
            }
            currentSessionId = (String)((Object)new UUIDHexGenerator().generate(null, null));
            SessionManager.createSession(currentSessionId);
            cookie = SessionManager.createCookie((HttpServletResponse)res, "JSESSIONID", currentSessionId);
        }
        SessionManager.setCurrentSessionId(currentSessionId);
        SessionVisitor sessionVisitor = SessionManager.getSessionVisitor();
        sessionVisitor.accessed();
    }

    public static void endSession() {
        SessionManager.setCurrentSessionId(null);
    }

    private static Cookie findCookie(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(name)) continue;
                return cookies[i];
            }
        }
        return null;
    }

    private static Cookie removeCookie(HttpServletResponse res, String name) {
        Cookie cookie = new Cookie(name, "");
        cookie.setPath("/");
        cookie.setMaxAge(0);
        res.addCookie(cookie);
        return cookie;
    }

    private static Cookie createCookie(HttpServletResponse res, String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(-1);
        res.addCookie(cookie);
        return cookie;
    }

    class SessionImpl
    implements HttpSession,
    SessionVisitor {
        private String sessionId;
        private long createTime;
        private long accessTime;
        private int timeout;
        private Map valueMap;

        public SessionImpl(String sessionId) {
            this.sessionId = sessionId;
            this.accessTime = this.createTime = System.currentTimeMillis();
            this.timeout = Configuration.getAsInt((String)ConfigurationKeys.INACTIVE_TIME);
            this.valueMap = new ConcurrentReaderHashMap();
        }

        public long getCreationTime() {
            return this.createTime;
        }

        public String getId() {
            return this.sessionId;
        }

        public long getLastAccessedTime() {
            return this.accessTime;
        }

        public void setMaxInactiveInterval(int timeout) {
            this.timeout = timeout;
        }

        public int getMaxInactiveInterval() {
            return this.timeout;
        }

        public Object getAttribute(String name) {
            return this.valueMap.get(name);
        }

        public Enumeration getAttributeNames() {
            return new Enumeration(){
                Iterator iter;
                {
                    this.iter = SessionImpl.this.valueMap.keySet().iterator();
                }

                public boolean hasMoreElements() {
                    return this.iter.hasNext();
                }

                public Object nextElement() {
                    return this.iter.next();
                }
            };
        }

        public void setAttribute(String name, Object value) {
            if (value == null) {
                this.removeAttribute(name);
            }
            Object old = this.valueMap.put(name, value);
            this.fireBound(name, value);
            if (old != null) {
                this.fireUnbound(name, old);
            }
        }

        public void removeAttribute(String name) {
            Object value = this.valueMap.remove(name);
            if (value != null) {
                this.fireUnbound(name, value);
            }
        }

        public void invalidate() {
            for (Map.Entry entry : this.valueMap.entrySet()) {
                this.fireUnbound((String)entry.getKey(), entry.getValue());
            }
            this.valueMap.clear();
        }

        public boolean isNew() {
            return false;
        }

        public void putValue(String name, Object value) {
            this.setAttribute(name, value);
        }

        public void removeValue(String name) {
            this.removeAttribute(name);
        }

        public Object getValue(String name) {
            return this.getAttribute(name);
        }

        public String[] getValueNames() {
            return this.valueMap.keySet().toArray(new String[this.valueMap.size()]);
        }

        public HttpSessionContext getSessionContext() {
            return new HttpSessionContext(){

                public HttpSession getSession(String sessionId) {
                    return SessionImpl.this;
                }

                public Enumeration getIds() {
                    return new Enumeration(){

                        public boolean hasMoreElements() {
                            return false;
                        }

                        public Object nextElement() {
                            return null;
                        }
                    };
                }
            };
        }

        public ServletContext getServletContext() {
            return null;
        }

        public void accessed() {
            this.accessTime = System.currentTimeMillis();
        }

        private void fireUnbound(String name, Object value) {
            if (value instanceof HttpSessionBindingListener) {
                HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, value);
                ((HttpSessionBindingListener)value).valueUnbound(event);
            }
        }

        private void fireBound(String name, Object value) {
            if (value instanceof HttpSessionBindingListener) {
                HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, value);
                ((HttpSessionBindingListener)value).valueBound(event);
            }
        }
    }

    class Monitor
    implements Runnable {
        private static final String THREAD_NAME = "LAMS SYSTEM SESSION MONITOR";
        private Thread monitoringThread;
        private boolean stopSign = false;

        Monitor() {
        }

        public void start() {
            this.monitoringThread = new Thread((Runnable)this, THREAD_NAME);
            this.stopSign = false;
            this.monitoringThread.start();
        }

        public void run() {
            while (!this.stopSign) {
                try {
                    for (SessionImpl session : SessionManager.this.sessionContainer.values()) {
                        if (session.getMaxInactiveInterval() <= 0 || System.currentTimeMillis() - session.getLastAccessedTime() - (long)session.getMaxInactiveInterval() * 1000L <= 0L) continue;
                        session.invalidate();
                    }
                }
                catch (Throwable e) {
                    log.warn((Object)("Monitor thread exception: " + e));
                }
                if (this.stopSign) continue;
                try {
                    Thread.sleep((long)SessionManager.this.monitorPeriod * 1000L);
                }
                catch (Exception exception) {}
            }
        }

        public void stop() {
            if (this.monitoringThread != null) {
                this.stopSign = true;
                this.monitoringThread.interrupt();
                try {
                    this.monitoringThread.join();
                }
                catch (InterruptedException ignore) {
                    log.error((Object)"Exception when interruptting Session Monitoring Thread");
                }
                this.monitoringThread = null;
            }
        }
    }
}

