/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.util.LoginRequestDispatcher;

public class LoginRequestValve
extends ValveBase {
    private static final Logger log = Logger.getLogger(LoginRequestValve.class);
    private static final String PARAM_USERID = "uid";
    private static final String LOGIN_REQUEST = "LoginRequest";

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        HttpServletRequest hreq = request.getRequest();
        this.getNext().invoke(request, response);
        if (hreq.getRequestURI().endsWith(LOGIN_REQUEST)) {
            boolean isLoginSuccessful = false;
            String[] headerNames = response.getHeaderNames();
            log.info((Object)("There are " + headerNames.length + " headers in the response"));
            for (String name : headerNames) {
                String[] values = response.getHeaderValues(name);
                if (values.length > 0) {
                    log.info((Object)(name + " = " + values[0]));
                    if (!name.toLowerCase().equals("location") || !values[0].matches(".*/j_security_check.*")) continue;
                    isLoginSuccessful = true;
                    continue;
                }
                log.info((Object)("empty header-" + name));
            }
            if (!isLoginSuccessful) {
                log.info((Object)"LOGIN REQUEST DETECTED - BUT NO LOGIN IS CARRIED OUT");
            } else {
                HttpSession hses = hreq.getSession(false);
                log.debug((Object)("Session Id - " + hses.getId()));
                String userid = hreq.getParameter(PARAM_USERID);
                String redirect = LoginRequestDispatcher.getRequestURL((HttpServletRequest)hreq);
                if (userid != null && redirect != null && hses != null) {
                    log.info((Object)"LOGIN REQUEST DETECTED - LOGIN SUCCESSFUL");
                    log.info((Object)("character encoding of the request - " + request.getCharacterEncoding()));
                    log.info((Object)("Redirect URL - " + redirect));
                    Session session = request.getContext().getManager().findSession(hses.getId());
                    SavedRequest saved = new SavedRequest();
                    saved.setRequestURI(redirect);
                    session.setNote("org.apache.catalina.authenticator.REQUEST", (Object)saved);
                } else {
                    log.info((Object)"LOGIN REQUEST DETECTED - BUT MISSING REQUIRED PARAM");
                }
            }
        }
    }
}

