/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.export.web.action;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.lamsfoundation.lams.learning.export.web.action.Bundler;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.HttpUrlConnectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSBundler
extends Bundler {
    private static final String RTL_DIR = "rtl";
    Map<String, File> filesToCopy = new HashMap<String, File>();
    HttpServletRequest request = null;
    Cookie[] cookies = null;
    String outputDirectory = null;
    String centralPath = null;
    boolean rtl = false;
    Collection<Theme> themes = null;
    List<String> directoriesRequired = new ArrayList<String>();

    public CSSBundler(HttpServletRequest request, Cookie[] cookies, String outputDirectory, Collection<Theme> themes) {
        this.request = request;
        this.cookies = cookies;
        this.outputDirectory = outputDirectory;
        this.themes = themes != null ? themes : new ArrayList();
        this.centralPath = Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR);
        if (this.centralPath == null) {
            log.error((Object)"Unable to get path to the LAMS ear from the configuration file - the exported portfolios will be missing parts of their css (style and images).");
        } else {
            this.centralPath = this.centralPath + File.separator + "lams-central.war";
        }
        String pageDirection = (String)request.getSession().getAttribute("page_direction");
        if (pageDirection != null && pageDirection.toLowerCase().equals(RTL_DIR)) {
            this.rtl = true;
        }
    }

    public void bundleStylesheet() throws IOException {
        File central = new File(this.centralPath);
        if (this.centralPath == null || !central.canRead() || !central.isDirectory()) {
            log.error((Object)"Unable to get the path for lams-central or unable to read it as a directory. Bundling stylesheets via http but not including images");
            this.bundleViaHTTP(this.request, this.cookies);
        } else {
            log.debug((Object)("Copying stylesheets and images from path " + this.centralPath));
            this.bundleViaCopy();
        }
    }

    private void bundleViaHTTP(HttpServletRequest request, Cookie[] cookies) throws MalformedURLException, FileNotFoundException, IOException {
        String cssDirectory = this.outputDirectory + File.separator + "css";
        File cssDirectoryFile = new File(cssDirectory);
        cssDirectoryFile.mkdirs();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
        for (Theme theme : this.themes) {
            String themeName = theme.getName();
            String url = !this.rtl ? basePath + "/lams/css/" + themeName + ".css" : basePath + "/lams/css/" + themeName + "_" + RTL_DIR + ".css";
            HttpUrlConnectionUtil.writeResponseToFile((String)url, (String)cssDirectory, (String)(!this.rtl ? themeName + ".css" : themeName + "_" + RTL_DIR + ".css"), (Cookie[])cookies);
            url = !this.rtl ? basePath + "/lams/css/" + themeName + "_learner.css" : basePath + "/lams/css/" + themeName + "_" + RTL_DIR + "_learner.css";
            HttpUrlConnectionUtil.writeResponseToFile((String)url, (String)cssDirectory, (String)(!this.rtl ? themeName + "_learner.css" : themeName + "_" + RTL_DIR + "_learner.css"), (Cookie[])cookies);
        }
        String url = basePath + "/lams/css/ie-styles.css";
        HttpUrlConnectionUtil.writeResponseToFile((String)url, (String)cssDirectory, (String)"ie-styles.css", (Cookie[])cookies);
    }

    private void bundleViaCopy() throws IOException {
        this.setupThemeList();
        this.setupImageList();
        this.createDirectories(this.directoriesRequired);
        for (Map.Entry<String, File> fileEntry : this.filesToCopy.entrySet()) {
            this.copyFile(fileEntry.getKey(), fileEntry.getValue());
        }
    }

    private void setupThemeList() {
        String cssDirectory = this.outputDirectory + File.separatorChar + "css";
        this.directoriesRequired.add(cssDirectory);
        for (Theme theme : this.themes) {
            String themeName = theme.getName();
            String themeFilename = !this.rtl ? themeName + ".css" : themeName + "_" + RTL_DIR + ".css";
            this.addThemeFile(cssDirectory, themeFilename);
            themeFilename = !this.rtl ? themeName + "_learner.css" : themeName + "_" + RTL_DIR + "_learner.css";
            this.addThemeFile(cssDirectory, themeFilename);
        }
        this.addThemeFile(cssDirectory, "ie-styles.css");
    }

    private void addThemeFile(String cssDirectory, String themeFilename) {
        File themeFile = new File(this.centralPath + File.separatorChar + "css" + File.separatorChar + themeFilename);
        if (!themeFile.canRead()) {
            log.error((Object)("Unable to read theme file " + themeFile.getAbsolutePath()));
        } else {
            this.filesToCopy.put(cssDirectory + File.separatorChar + themeFilename, themeFile);
        }
    }

    private void setupImageList() {
        for (Theme theme : this.themes) {
            File[] files;
            String dirName = theme.getImageDirectory();
            if (dirName == null) continue;
            String imageDirectory = this.centralPath + File.separatorChar + "images" + File.separatorChar + dirName;
            String outputImageDirectory = this.outputDirectory + File.separatorChar + "images" + File.separatorChar + dirName;
            this.directoriesRequired.add(outputImageDirectory);
            File dir = new File(imageDirectory);
            if (!dir.canRead() || !dir.isDirectory()) {
                log.error((Object)("Unable to read css image directory " + dir.getAbsolutePath()));
                continue;
            }
            for (File imageFile : files = dir.listFiles()) {
                this.filesToCopy.put(outputImageDirectory + File.separatorChar + imageFile.getName(), imageFile);
            }
        }
    }
}

