/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.export.web.action;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learning.export.web.action.Bundler;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class ImageBundler
extends Bundler {
    private static Logger log = Logger.getLogger(ImageBundler.class);
    private static String[] miscImages = new String[]{"dash.gif", "cross.gif", "error.jpg", "spacer.gif", "tick.gif", "tree_closed.gif", "tree_open.gif", "help.jpg"};
    Map<String, File> filesToCopy = new HashMap<String, File>();
    List<String> directoriesRequired = new ArrayList<String>();
    String outputDirectory = null;
    String contentFolderId = null;
    String lamsWwwPath = null;
    String lamsCentralPath = null;

    public ImageBundler(String outputDirectory, String contentFolderId) {
        this.outputDirectory = outputDirectory;
        this.contentFolderId = contentFolderId;
        String lamsEarDir = Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR);
        if (lamsEarDir == null) {
            log.error((Object)"Unable to get path to the LAMS ear from the configuration file - the exported portfolios will be missing User generated content and FCKEditor smileys.");
        } else {
            this.lamsWwwPath = lamsEarDir + File.separator + "lams-www.war";
            this.lamsCentralPath = lamsEarDir + File.separator + "lams-central.war";
        }
    }

    public void bundleImages() throws IOException {
        if (this.lamsWwwPath != null) {
            log.debug((Object)("Copying user generated content from path " + this.lamsWwwPath));
            File contentFolderDir = new File(this.lamsWwwPath + File.separatorChar + "secure" + File.separatorChar + this.contentFolderId);
            if (contentFolderDir.exists() && contentFolderDir.isDirectory()) {
                File destDir = new File(this.outputDirectory + File.separatorChar + this.contentFolderId);
                FileUtils.copyDirectory((File)contentFolderDir, (File)destDir);
            } else {
                log.debug((Object)("Folder for contentFolderId:" + this.contentFolderId + "doesn't exist"));
            }
        }
        File central = new File(this.lamsCentralPath);
        if (this.lamsCentralPath != null && central.canRead() && central.isDirectory()) {
            log.debug((Object)("Copying FCKeditor smileys from path " + this.lamsCentralPath));
            this.setupFCKEditorSmileysList();
            this.setupMiscImages();
            this.setupVideoRecorderExport();
        }
        this.createDirectories(this.directoriesRequired);
        for (Map.Entry<String, File> fileEntry : this.filesToCopy.entrySet()) {
            this.copyFile(fileEntry.getKey(), fileEntry.getValue());
        }
    }

    private void setupFCKEditorSmileysList() {
        String imageDirectory = this.lamsCentralPath + File.separatorChar + "fckeditor" + File.separatorChar + "editor" + File.separatorChar + "images" + File.separatorChar + "smiley" + File.separatorChar + "msn";
        String outputImageDirectory = this.outputDirectory + File.separatorChar + "fckeditor" + File.separatorChar + "editor" + File.separatorChar + "images" + File.separatorChar + "smiley" + File.separatorChar + "msn";
        this.directoriesRequired.add(outputImageDirectory);
        File dir = new File(imageDirectory);
        if (!dir.canRead() || !dir.isDirectory()) {
            log.debug((Object)("Unable to read image directory " + dir.getAbsolutePath()));
        } else {
            File[] files;
            for (File imageFile : files = dir.listFiles()) {
                this.filesToCopy.put(outputImageDirectory + File.separatorChar + imageFile.getName(), imageFile);
            }
        }
    }

    private void setupMiscImages() {
        String imageDirectory = this.lamsCentralPath + File.separatorChar + "images";
        String outputImageDirectory = this.outputDirectory + File.separatorChar + "images";
        this.directoriesRequired.add(outputImageDirectory);
        for (String imageName : miscImages) {
            String inputFilename = imageDirectory + File.separatorChar + imageName;
            String outputFilename = outputImageDirectory + File.separatorChar + imageName;
            File image = new File(inputFilename);
            if (!image.canRead() || image.isDirectory()) {
                log.error((Object)("Unable to copy image " + inputFilename + " as file does not exist or cannot be read as a file."));
                continue;
            }
            this.filesToCopy.put(outputFilename, image);
        }
    }

    private void setupVideoRecorderExport() {
        String vrDirectory = this.lamsCentralPath + File.separatorChar + "fckeditor" + File.separatorChar + "editor" + File.separatorChar + "plugins" + File.separatorChar + "videorecorder";
        String outputVrDirectory = this.outputDirectory + File.separatorChar + "fckeditor" + File.separatorChar + "editor" + File.separatorChar + "plugins" + File.separatorChar + "videorecorder";
        this.directoriesRequired.add(outputVrDirectory);
        File dir = new File(vrDirectory);
        if (!dir.canRead() || !dir.isDirectory()) {
            log.debug((Object)("Unable to read vr directory " + dir.getAbsolutePath()));
        } else {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) continue;
                this.filesToCopy.put(outputVrDirectory + File.separatorChar + file.getName(), file);
            }
        }
    }
}

