/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.export.web.action;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learning.export.ExportPortfolioException;
import org.lamsfoundation.lams.learning.export.Portfolio;
import org.lamsfoundation.lams.learning.export.service.ExportPortfolioServiceProxy;
import org.lamsfoundation.lams.learning.export.service.IExportPortfolioService;
import org.lamsfoundation.lams.learning.export.web.action.CSSBundler;
import org.lamsfoundation.lams.learning.export.web.action.ImageBundler;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class MainExportServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(MainExportServlet.class);
    private static final long serialVersionUID = 7788509831929373666L;
    private String exportTmpDir;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected Integer getLearnerUserID(HttpServletRequest request) {
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID", (boolean)true);
        if (userId == null) {
            HttpSession session = SessionManager.getSession();
            UserDTO userDto = (UserDTO)session.getAttribute("user");
            userId = userDto.getUserID();
        }
        return userId;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ExportPortfolioException {
        log.debug((Object)"Doing export portfolio");
        Portfolio portfolios = null;
        Long lessonID = null;
        String role = null;
        ToolAccessMode accessMode = null;
        String exportFilename = "";
        Cookie[] cookies = request.getCookies();
        IExportPortfolioService exportService = ExportPortfolioServiceProxy.getExportPortfolioService(this.getServletContext());
        String mode = WebUtil.readStrParam((HttpServletRequest)request, (String)"mode");
        if (log.isDebugEnabled()) {
            int numCookies = cookies != null ? cookies.length : 0;
            log.debug((Object)("Export portfolio: mode " + mode + " # cookies " + new Integer(numCookies).toString()));
        }
        if (mode.equals(ToolAccessMode.LEARNER.toString())) {
            Integer userId = this.getLearnerUserID(request);
            lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            role = WebUtil.readStrParam((HttpServletRequest)request, (String)"role", (boolean)true);
            if (role != null) {
                accessMode = role.equals(ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : null;
            }
            portfolios = exportService.exportPortfolioForStudent(userId, lessonID, true, accessMode, cookies);
            String learnerName = portfolios.getLearnerName();
            String learnerLogin = learnerName.substring(learnerName.indexOf(40) + 1, learnerName.lastIndexOf(41));
            exportFilename = "Portfolio " + portfolios.getLessonName() + " " + learnerLogin + ".zip";
        } else if (mode.equals(ToolAccessMode.TEACHER.toString())) {
            lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            portfolios = exportService.exportPortfolioForTeacher(lessonID, cookies);
            exportFilename = "Class Portfolio " + portfolios.getLessonName() + ".zip";
        }
        if (portfolios != null) {
            exportFilename = FileUtil.stripInvalidChars((String)exportFilename);
            this.exportTmpDir = portfolios.getExportTmpDir();
            exportService.generateMainPage(request, portfolios, cookies);
            if (portfolios.getNotebookPortfolios() != null && portfolios.getNotebookPortfolios().length > 0) {
                exportService.generateNotebookPage(request, portfolios, cookies);
            }
            this.replaceImageFolderLinks(portfolios.getContentFolderID(), Configuration.get((String)ConfigurationKeys.SERVER_URL_CONTEXT_PATH));
            CSSBundler bundler = new CSSBundler(request, cookies, this.exportTmpDir, exportService.getUserThemes());
            bundler.bundleStylesheet();
            ImageBundler imageBundler = new ImageBundler(this.exportTmpDir, portfolios.getContentFolderID());
            imageBundler.bundleImages();
            String exportZipDir = exportService.zipPortfolio("export.zip", this.exportTmpDir);
            PrintWriter out = response.getWriter();
            out.print(URLEncoder.encode(exportZipDir + File.separator + exportFilename, "UTF-8"));
        }
    }

    private void replaceImageFolderLinks(String contentFolderID, String lamsOrRams) {
        File tempDir = new File(this.exportTmpDir);
        Collection jspFiles = FileUtils.listFiles((File)tempDir, (String[])new String[]{"html"}, (boolean)true);
        for (Object element : jspFiles) {
            log.debug((Object)("Correcting links in file " + element.toString()));
            this.replaceImageFolderLinks(element.toString(), contentFolderID, lamsOrRams);
        }
    }

    private void replaceImageFolderLinks(String filename, String contentFolderID, String lamsOrRams) {
        try {
            String fckeditorpath = "/" + lamsOrRams + "/www/secure/" + contentFolderID;
            String fckeditorrecpath = "../" + contentFolderID + "/Recordings";
            String fckeditorsmiley = "/" + lamsOrRams + "/fckeditor/editor/images/smiley";
            String fckeditorvr = "/" + lamsOrRams + "/fckeditor/editor/plugins/videorecorder";
            String newfckeditorpath = "../" + contentFolderID;
            String newfckeditorrecpath = "../../../../" + contentFolderID + "/Recordings";
            String newfckeditorsmiley = "../fckeditor/editor/images/smiley";
            String newfckeditorvr = "../fckeditor/editor/plugins/videorecorder";
            File fin = new File(filename);
            FileInputStream fis = new FileInputStream(fin);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            Pattern p = Pattern.compile(fckeditorpath);
            Matcher m = p.matcher("");
            Pattern p2 = Pattern.compile(fckeditorrecpath);
            Matcher m2 = p2.matcher("");
            Pattern p3 = Pattern.compile(fckeditorsmiley);
            Matcher m3 = p3.matcher("");
            Pattern p4 = Pattern.compile(fckeditorvr);
            Matcher m4 = p4.matcher("");
            String aLine = null;
            String output = "";
            while ((aLine = in.readLine()) != null) {
                m.reset(aLine);
                String firstpass = m.replaceAll(newfckeditorpath);
                m2.reset(firstpass);
                String secondpass = m2.replaceAll(newfckeditorrecpath);
                m3.reset(secondpass);
                String thirdpass = m3.replaceAll(newfckeditorsmiley);
                m4.reset(thirdpass);
                String result = m4.replaceAll(newfckeditorvr);
                output = output + result + "\n";
            }
            in.close();
            File fout = new File(filename);
            FileOutputStream fos = new FileOutputStream(fout);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            out.write(output);
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            log.error((Object)("Unable to correct imagefolder links in file " + filename), (Throwable)e);
        }
    }
}

