/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.web.action;

import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.service.LearnerServiceProxy;
import org.lamsfoundation.lams.learning.web.bean.ActivityURL;
import org.lamsfoundation.lams.learning.web.util.ActivityMapping;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class BranchingActivityAction
extends LamsDispatchAction {
    public static final String PARAM_FORCE_GROUPING = "force";
    private ICoreLearnerService learnerService = null;

    protected ICoreLearnerService getLearnerService() {
        if (this.learnerService == null) {
            this.learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        }
        return this.learnerService;
    }

    public ActionForward performBranching(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActivityMapping actionMappings = LearningWebUtil.getActivityMapping(this.getServlet().getServletContext());
        this.getLearnerService();
        LearnerProgress learnerProgress = LearningWebUtil.getLearnerProgress(request, this.learnerService);
        Activity activity = LearningWebUtil.getActivityFromRequest(request, this.learnerService);
        Integer learnerId = LearningWebUtil.getUserId();
        boolean forceGroup = WebUtil.readBooleanParam((HttpServletRequest)request, (String)PARAM_FORCE_GROUPING, (boolean)false);
        ActionForward forward = null;
        if (activity == null) {
            learnerProgress = this.learnerService.joinLesson(learnerId, learnerProgress.getLesson().getLessonId());
            forward = actionMappings.getActivityForward(activity, learnerProgress, true);
        } else if (!(activity instanceof BranchingActivity)) {
            log.error((Object)(className + ": activity not BranchingActivity " + activity.getActivityId()));
            forward = mapping.findForward("error");
        } else {
            BranchingActivity branchingActivity = (BranchingActivity)activity;
            SequenceActivity branch = this.learnerService.determineBranch(learnerProgress.getLesson(), branchingActivity, learnerId);
            DynaActionForm branchForm = (DynaActionForm)actionForm;
            branchForm.set("activityID", (Object)activity.getActivityId());
            branchForm.set("progressID", (Object)learnerProgress.getLearnerProgressId());
            branchForm.set("showFinishButton", (Object)Boolean.TRUE);
            branchForm.set("title", (Object)activity.getTitle());
            if (learnerProgress.getLesson().isPreviewLesson()) {
                branchForm.set("previewLesson", (Object)Boolean.TRUE);
                forward = mapping.findForward("displayBranchingPreview");
                ArrayList<ActivityURL> activityURLs = new ArrayList<ActivityURL>();
                Iterator i = branchingActivity.getActivities().iterator();
                int completedCount = 0;
                while (i.hasNext()) {
                    Activity nextBranch = (Activity)i.next();
                    ActivityURL activityURL = LearningWebUtil.getActivityURL(actionMappings, learnerProgress, nextBranch, branch != null && branch.equals((Object)nextBranch), false);
                    if (activityURL.isComplete()) {
                        ++completedCount;
                    }
                    activityURLs.add(activityURL);
                }
                branchForm.set("activityURLs", activityURLs);
                branchForm.set("showNextButton", (Object)(branchingActivity.getActivities().size() != completedCount ? 1 : 0));
                LearningWebUtil.setupProgressInRequest(branchForm, request, learnerProgress);
            } else if (branch == null) {
                branchForm.set("previewLesson", (Object)Boolean.FALSE);
                forward = mapping.findForward("displayBranchingWait");
                branchForm.set("showNextButton", (Object)Boolean.TRUE);
                if (branchingActivity.isChosenBranchingActivity()) {
                    branchForm.set("type", (Object)"chosen");
                } else if (branchingActivity.isGroupBranchingActivity()) {
                    branchForm.set("type", (Object)"group");
                } else if (branchingActivity.isToolBranchingActivity()) {
                    branchForm.set("type", (Object)"tool");
                }
                LearningWebUtil.setupProgressInRequest(branchForm, request, learnerProgress);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Branching: selecting the branch " + branch + " for user " + learnerId));
                }
                learnerProgress = this.learnerService.chooseActivity(learnerId, learnerProgress.getLesson().getLessonId(), (Activity)branch, true);
                forward = actionMappings.getActivityForward((Activity)branch, learnerProgress, true);
                LearningWebUtil.putLearnerProgressInRequest(request, learnerProgress);
            }
        }
        return forward;
    }

    public ActionForward forceBranching(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActivityMapping actionMappings = LearningWebUtil.getActivityMapping(this.getServlet().getServletContext());
        this.getLearnerService();
        LearnerProgress learnerProgress = LearningWebUtil.getLearnerProgress(request, this.learnerService);
        Activity activity = LearningWebUtil.getActivityFromRequest(request, this.learnerService);
        Integer learnerId = LearningWebUtil.getUserId();
        ActionForward forward = null;
        if (activity == null) {
            learnerProgress = this.learnerService.joinLesson(learnerId, learnerProgress.getLesson().getLessonId());
            forward = actionMappings.getActivityForward(activity, learnerProgress, true);
        } else if (!(activity instanceof BranchingActivity)) {
            log.error((Object)(className + ": activity not BranchingActivity " + activity.getActivityId()));
            forward = mapping.findForward("error");
        } else {
            BranchingActivity branchingActivity = (BranchingActivity)activity;
            Long branchId = WebUtil.readLongParam((HttpServletRequest)request, (String)"branchID", (boolean)false);
            SequenceActivity branch = this.learnerService.selectBranch(learnerProgress.getLesson(), branchingActivity, learnerId, branchId);
            if (branch == null) {
                log.error((Object)(className + ": branch id from request is not valid. Activity id " + activity.getActivityId() + " branch id " + branchId));
                forward = mapping.findForward("error");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Branching: selecting the branch " + branch + " for user " + learnerId));
            }
            learnerProgress = this.learnerService.chooseActivity(learnerId, learnerProgress.getLesson().getLessonId(), (Activity)branch, true);
            forward = actionMappings.getActivityForward((Activity)branch, learnerProgress, true);
            LearningWebUtil.putLearnerProgressInRequest(request, learnerProgress);
        }
        return forward;
    }
}

