/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.web.action;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.service.LearnerServiceProxy;
import org.lamsfoundation.lams.learning.web.action.ActivityAction;
import org.lamsfoundation.lams.learning.web.bean.ActivityURL;
import org.lamsfoundation.lams.learning.web.form.ActivityForm;
import org.lamsfoundation.lams.learning.web.util.ActivityMapping;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.learning.web.util.ParallelActivityMappingStrategy;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;

public class DisplayParallelActivityAction
extends ActivityAction {
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActivityForm form = (ActivityForm)actionForm;
        ICoreLearnerService learnerService = this.getLearnerService();
        ActivityMapping actionMappings = LearnerServiceProxy.getActivityMapping(this.getServlet().getServletContext());
        actionMappings.setActivityMappingStrategy(new ParallelActivityMappingStrategy());
        Activity activity = LearningWebUtil.getActivityFromRequest(request, learnerService);
        if (!(activity instanceof ParallelActivity)) {
            log.error((Object)(className + ": activity not ParallelActivity " + activity.getActivityId()));
            return mapping.findForward("error");
        }
        ParallelActivity parallelActivity = (ParallelActivity)activity;
        form.setActivityID(activity.getActivityId());
        ArrayList<ActivityURL> activityURLs = new ArrayList<ActivityURL>();
        for (Activity subActivity : parallelActivity.getActivities()) {
            ActivityURL activityURL = new ActivityURL();
            String url = actionMappings.getActivityURL(subActivity);
            activityURL.setUrl(url);
            activityURLs.add(activityURL);
        }
        if (activityURLs.size() == 0) {
            log.error((Object)(className + ": No sub-activity URLs for activity " + activity.getActivityId()));
            return mapping.findForward("error");
        }
        form.setActivityURLs(activityURLs);
        LearningWebUtil.setupProgressInRequest((ActivityForm)actionForm, request, LearningWebUtil.getLearnerProgress(request, learnerService));
        return mapping.findForward("displayParallel");
    }
}

