/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.web.action;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.service.LearnerServiceException;
import org.lamsfoundation.lams.learning.service.LearnerServiceProxy;
import org.lamsfoundation.lams.learning.web.bean.GateActivityDTO;
import org.lamsfoundation.lams.learning.web.util.ActivityMapping;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class GateAction
extends LamsDispatchAction {
    private static final String VIEW_PERMISSION_GATE = "permissionGate";
    private static final String VIEW_SCHEDULE_GATE = "scheduleGate";
    private static final String VIEW_SYNCH_GATE = "synchGate";
    private static final String VIEW_CONDITION_GATE = "conditionGate";
    public static final String PARAM_FORCE_GATE_OPEN = "force";

    public ActionForward knockGate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean forceGate = WebUtil.readBooleanParam((HttpServletRequest)request, (String)PARAM_FORCE_GATE_OPEN, (boolean)false);
        Long activityId = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        ICoreLearnerService learnerService = LearnerServiceProxy.getLearnerService(this.getServlet().getServletContext());
        Activity activity = learnerService.getActivity(activityId);
        ActivityMapping actionMappings = LearningWebUtil.getActivityMapping(this.getServlet().getServletContext());
        User learner = LearningWebUtil.getUser(learnerService);
        Lesson lesson = learnerService.getLesson(lessonId);
        LearnerProgress learnerProgress = (LearnerProgress)request.getAttribute("learnerprogress");
        if (learnerProgress == null) {
            learnerProgress = learnerService.getProgress(learner.getUserId(), lessonId);
        }
        if (activity != null) {
            GateActivityDTO gate = learnerService.knockGate(activityId, learner, forceGate);
            if (gate == null) {
                throw new LearnerServiceException("Gate missing. gate id [" + activityId + "]");
            }
            if (!gate.getAllowToPass()) {
                ActionForward forward = this.findViewByGateType(mapping, (DynaActionForm)form, gate, lesson);
                LearningWebUtil.setupProgressInRequest((DynaActionForm)form, request, learnerProgress);
                return forward;
            }
        }
        return LearningWebUtil.completeActivity(request, response, actionMappings, learnerProgress, activity, learner.getUserId(), learnerService, true);
    }

    private ActionForward findViewByGateType(ActionMapping mapping, DynaActionForm gateForm, GateActivityDTO gate, Lesson lesson) {
        gateForm.set("totalLearners", (Object)new Integer(gate.getExpectedLearners().size()));
        gateForm.set("waitingLearners", (Object)new Integer(gate.getWaitingLearners().size()));
        gateForm.set("previewLesson", (Object)lesson.isPreviewLesson());
        gateForm.set("monitorCanOpenGate", (Object)true);
        gateForm.set("activityID", (Object)gate.getActivityId());
        gateForm.set("lessonID", (Object)lesson.getLessonId());
        gateForm.set("gate", (Object)gate);
        if (gate.isSynchGate()) {
            return mapping.findForward(VIEW_SYNCH_GATE);
        }
        if (gate.isScheduleGate()) {
            ScheduleGateActivity scheduleGate = (ScheduleGateActivity)gate.getGateActivity();
            gateForm.set("startingTime", (Object)scheduleGate.getGateStartDateTime());
            gateForm.set("endingTime", (Object)scheduleGate.getGateEndDateTime());
            return mapping.findForward(VIEW_SCHEDULE_GATE);
        }
        if (gate.isConditionGate()) {
            gateForm.set("monitorCanOpenGate", (Object)false);
            return mapping.findForward(VIEW_CONDITION_GATE);
        }
        if (gate.isPermissionGate() || gate.isSystemGate()) {
            return mapping.findForward(VIEW_PERMISSION_GATE);
        }
        throw new LearnerServiceException("Invalid gate activity. gate id [" + gate.getActivityId() + "] - the type [" + gate.getActivityTypeId() + "] is not a gate type");
    }
}

