/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.web.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.service.LearnerServiceProxy;
import org.lamsfoundation.lams.learning.web.action.ActivityAction;
import org.lamsfoundation.lams.learning.web.bean.ActivityURL;
import org.lamsfoundation.lams.learning.web.form.ActivityForm;
import org.lamsfoundation.lams.learning.web.util.ActivityMapping;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.lesson.LearnerProgress;

public class LoadToolActivityAction
extends ActivityAction {
    public static final String DEFINE_LATER = "previewDefineLater";
    public static final String PARAM_ACTIVITY_URL = "activityURL";
    public static final String PARAM_IS_BRANCHING = "isBranching";

    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActivityForm form = (ActivityForm)actionForm;
        ActivityMapping actionMappings = LearnerServiceProxy.getActivityMapping(this.getServlet().getServletContext());
        ICoreLearnerService learnerService = this.getLearnerService();
        LearnerProgress learnerProgress = LearningWebUtil.getLearnerProgress(request, learnerService);
        Activity activity = LearningWebUtil.getActivityFromRequest(request, learnerService);
        learnerService.createToolSessionsIfNecessary(activity, learnerProgress);
        form.setActivityID(activity.getActivityId());
        String mappingName = "displayTool";
        if (activity.isToolActivity() || activity.isSystemToolActivity()) {
            String url = actionMappings.getLearnerToolURL(learnerProgress.getLesson(), activity, learnerProgress.getUser());
            if (activity.getDefineLater().booleanValue() && learnerProgress.getLesson().isPreviewLesson()) {
                request.setAttribute("title", (Object)activity.getTitle());
                request.setAttribute(PARAM_ACTIVITY_URL, (Object)url);
                request.setAttribute(PARAM_IS_BRANCHING, (Object)activity.isBranchingActivity());
                mappingName = DEFINE_LATER;
            } else {
                form.addActivityURL(new ActivityURL(activity.getActivityId(), url));
            }
        } else {
            log.error((Object)(className + ": activity not ToolActivity"));
            return mapping.findForward("error");
        }
        LearningWebUtil.setupProgressInRequest(form, request, learnerProgress);
        return mapping.findForward(mappingName);
    }
}

