/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.web.util;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;

public class ActivityMappingStrategy
implements Serializable {
    private static Logger log = Logger.getLogger(ActivityMappingStrategy.class);
    private static final String PROGRESS_BROKEN_ACTION = "/progressBroken.do";

    protected String getActivityAction(Activity activity) {
        String strutsAction = null;
        if (activity == null) {
            strutsAction = PROGRESS_BROKEN_ACTION;
        } else if (activity.isSystemToolActivity() || activity.isToolActivity()) {
            strutsAction = "/LoadToolActivity.do";
        } else if (activity.isParallelActivity()) {
            strutsAction = "/DisplayParallelActivity.do";
        } else if (activity.isOptionsActivity()) {
            strutsAction = "/DisplayOptionsActivity.do";
        } else {
            log.error((Object)("Unexpected activity type " + activity));
            strutsAction = PROGRESS_BROKEN_ACTION;
        }
        return strutsAction;
    }

    protected String getWaitingAction() {
        return "/parallelWait.do";
    }

    protected String getLessonCompleteAction() {
        return "/LessonComplete.do";
    }

    protected String getCloseWindowAction() {
        return "/close.do";
    }

    protected String getProgressBrokenAction() {
        return PROGRESS_BROKEN_ACTION;
    }

    protected String getCompleteActivityAction() {
        return "/CompleteActivity.do";
    }

    protected String getDisplayActivityAction() {
        return "/DisplayActivity.do";
    }
}

