/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learning.web.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learning.service.LearnerServiceException;
import org.lamsfoundation.lams.learning.web.bean.ActivityURL;
import org.lamsfoundation.lams.learning.web.form.ActivityForm;
import org.lamsfoundation.lams.learning.web.util.ActivityMapping;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LearningWebUtil {
    private static Logger log = Logger.getLogger(LearningWebUtil.class);
    public static final String PARAM_PROGRESS_ID = "progressID";

    public static Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO learner = (UserDTO)ss.getAttribute("user");
        return learner != null ? learner.getUserID() : null;
    }

    public static User getUser(ICoreLearnerService learnerService) {
        HttpSession ss = SessionManager.getSession();
        UserDTO learner = (UserDTO)ss.getAttribute("user");
        return learner != null ? (User)learnerService.getUserManagementService().findById(User.class, (Serializable)learner.getUserID()) : null;
    }

    public static void putLearnerProgressInRequest(HttpServletRequest request, LearnerProgress progress) {
        if (progress != null) {
            request.setAttribute("learnerprogress", (Object)progress);
        } else {
            request.removeAttribute("learnerprogress");
        }
    }

    public static LearnerProgress getLearnerProgress(HttpServletRequest request, ICoreLearnerService learnerService) {
        Activity act;
        Lesson lesson;
        Integer learnerId;
        LearnerProgress learnerProgress = (LearnerProgress)request.getAttribute("learnerprogress");
        if (learnerProgress != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getLearnerProgress: found progress in the request");
            }
            return learnerProgress;
        }
        if (learnerProgress == null) {
            Long learnerProgressId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_PROGRESS_ID, (boolean)true);
            if (learnerProgressId == null && (learnerProgressId = WebUtil.readLongParam((HttpServletRequest)request, (String)"progressId", (boolean)true)) != null) {
                log.warn((Object)"Flash client still using progressId, instead of progressID in a learner call");
            }
            if (learnerProgressId != null && (learnerProgress = learnerService.getProgressById(new Long(learnerProgressId))) != null && log.isDebugEnabled()) {
                log.debug((Object)"getLearnerProgress: found progress via progress id");
            }
        }
        if (learnerProgress == null && (learnerProgress = learnerService.getProgress(learnerId = LearningWebUtil.getUserId(), (lesson = learnerService.getLessonByActivity(act = LearningWebUtil.getActivityFromRequest(request, learnerService))).getLessonId())) != null && log.isDebugEnabled()) {
            log.debug((Object)"getLearnerProgress: found progress via learner id and activity");
        }
        LearningWebUtil.putLearnerProgressInRequest(request, learnerProgress);
        return learnerProgress;
    }

    public static Activity getActivityFromRequest(HttpServletRequest request, ICoreLearnerService learnerService) {
        long activityId;
        Activity activity = (Activity)request.getAttribute("activity");
        if (activity == null && (activity = learnerService.getActivity(new Long(activityId = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID")))) != null) {
            request.setAttribute("activity", (Object)activity);
        }
        return activity;
    }

    public static void putActivityInRequest(HttpServletRequest request, Activity activity, ICoreLearnerService learnerService) {
        if (activity != null) {
            Activity realActivity = learnerService.getActivity(activity.getActivityId());
            request.setAttribute("activity", (Object)realActivity);
        } else {
            request.setAttribute("activity", null);
        }
    }

    public static ActionForward completeActivity(HttpServletRequest request, HttpServletResponse response, ActivityMapping actionMappings, LearnerProgress currentProgress, Activity currentActivity, Integer learnerId, ICoreLearnerService learnerService, boolean redirect) throws LearnerServiceException, UnsupportedEncodingException {
        LearnerProgress progress = currentProgress;
        Lesson lesson = progress.getLesson();
        if (currentActivity == null) {
            progress = learnerService.joinLesson(learnerId, lesson.getLessonId());
        } else {
            if (progress.getCompletedActivities().containsKey(currentActivity)) {
                return actionMappings.getCloseForward(currentActivity, lesson.getLessonId());
            }
            progress = learnerService.completeActivity(learnerId, currentActivity, progress);
        }
        if (currentActivity != null && currentActivity.isFloating()) {
            return actionMappings.getCloseForward(currentActivity, lesson.getLessonId());
        }
        LearningWebUtil.putActivityInRequest(request, progress.getNextActivity(), learnerService);
        LearningWebUtil.putLearnerProgressInRequest(request, progress);
        return actionMappings.getProgressForward(progress, redirect, false, request, learnerService);
    }

    public static ActivityMapping getActivityMapping(ServletContext context) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
        return (ActivityMapping)wac.getBean("activityMapping");
    }

    public static void setupProgressInRequest(ActivityForm activityForm, HttpServletRequest request, LearnerProgress learnerProgress) {
        Lesson currentLesson;
        LearningWebUtil.putLearnerProgressInRequest(request, learnerProgress);
        String progressSummary = activityForm.getProgressSummary();
        if (progressSummary == null) {
            progressSummary = LearningWebUtil.getProgressSummary(learnerProgress);
            activityForm.setProgressSummary(progressSummary);
        }
        if ((currentLesson = learnerProgress.getLesson()) != null) {
            activityForm.setLessonID(currentLesson.getLessonId());
            LearningDesign currentDesign = currentLesson.getLearningDesign();
            if (currentDesign != null) {
                activityForm.setVersion(currentDesign.getDesignVersion());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering activity: progress summary is " + activityForm.getProgressSummary()));
        }
    }

    public static void setupProgressInRequest(DynaActionForm actionForm, HttpServletRequest request, LearnerProgress learnerProgress) {
        Lesson currentLesson;
        LearningWebUtil.putLearnerProgressInRequest(request, learnerProgress);
        String progressSummary = (String)actionForm.get("progressSummary");
        if (progressSummary == null) {
            progressSummary = LearningWebUtil.getProgressSummary(learnerProgress);
            actionForm.set("progressSummary", (Object)progressSummary);
        }
        if ((currentLesson = learnerProgress.getLesson()) != null) {
            actionForm.set("lessonID", (Object)currentLesson.getLessonId());
            LearningDesign currentDesign = currentLesson.getLearningDesign();
            if (currentDesign != null) {
                actionForm.set("version", (Object)currentDesign.getDesignVersion());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering activity: progress summary is " + actionForm.get("progressSummary")));
        }
    }

    private static String getProgressSummary(LearnerProgress learnerProgress) {
        StringBuffer progressSummary = new StringBuffer(100);
        if (learnerProgress == null) {
            progressSummary.append("attempted=&completed=&current=");
            progressSummary.append("&lessonID=");
            Lesson currentLesson = learnerProgress.getLesson();
            if (currentLesson != null) {
                progressSummary.append(currentLesson.getLessonId());
            }
        } else {
            Activity activity;
            Activity obj;
            progressSummary.append("attempted=");
            boolean first = true;
            Iterator i$ = learnerProgress.getAttemptedActivities().keySet().iterator();
            while (i$.hasNext()) {
                activity = obj = (Activity)i$.next();
                if (!first) {
                    progressSummary.append("_");
                } else {
                    first = false;
                }
                progressSummary.append(activity.getActivityId());
            }
            progressSummary.append("&completed=");
            first = true;
            i$ = learnerProgress.getCompletedActivities().keySet().iterator();
            while (i$.hasNext()) {
                activity = obj = (Activity)i$.next();
                if (!first) {
                    progressSummary.append("_");
                } else {
                    first = false;
                }
                progressSummary.append(activity.getActivityId());
            }
            progressSummary.append("&current=");
            Activity currentActivity = learnerProgress.getCurrentActivity();
            if (currentActivity != null) {
                progressSummary.append(currentActivity.getActivityId());
            }
        }
        return progressSummary.toString();
    }

    public static ActivityURL getActivityURL(ActivityMapping activityMapping, LearnerProgress learnerProgress, Activity activity, boolean defaultURL, boolean isFloating) {
        ActivityURL activityURL = new ActivityURL();
        String url = activityMapping.getActivityURL(activity);
        activityURL.setUrl(url);
        activityURL.setActivityId(activity.getActivityId());
        activityURL.setTitle(activity.getTitle());
        activityURL.setDescription(activity.getDescription());
        byte status = learnerProgress.getProgressState(activity);
        activityURL.setStatus(status);
        if (status == 1) {
            activityURL.setComplete(true);
        }
        activityURL.setFloating(isFloating);
        activityURL.setDefaultURL(defaultURL);
        return activityURL;
    }
}

