/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.exception.ActivityBehaviorException;
import org.lamsfoundation.lams.learningdesign.strategy.ScheduleGateActivityStrategy;

public class ScheduleGateActivity
extends GateActivity
implements Serializable {
    private Long gateStartTimeOffset;
    private Long gateEndTimeOffset;
    private Date gateStartDateTime;
    private Date gateEndDateTime;

    public ScheduleGateActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Boolean defineLater, Date createDateTime, String offlineInstructions, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Integer gateActivityLevelId, Long gateStartTimeOffset, Long gateEndTimeOffset, Set waitingLearners) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, defineLater, createDateTime, offlineInstructions, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, gateActivityLevelId, waitingLearners);
        if (gateStartTimeOffset.intValue() > gateEndTimeOffset.intValue()) {
            throw new IllegalStateException("End time offset must be larger than start time offset");
        }
        this.gateStartTimeOffset = gateStartTimeOffset;
        this.gateEndTimeOffset = gateEndTimeOffset;
        this.simpleActivityStrategy = new ScheduleGateActivityStrategy();
    }

    public ScheduleGateActivity() {
        this.simpleActivityStrategy = new ScheduleGateActivityStrategy();
    }

    public ScheduleGateActivity(Long activityId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Integer gateActivityLevelId, Long gateStartTimeOffset, Long gateEndTimeOffset, Set waitingLearners) {
        super(activityId, defineLater, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, gateActivityLevelId, waitingLearners);
        if (gateStartTimeOffset.intValue() > gateEndTimeOffset.intValue()) {
            throw new IllegalStateException("End time offset must be larger than start time offset");
        }
        this.gateStartTimeOffset = gateStartTimeOffset;
        this.gateEndTimeOffset = gateEndTimeOffset;
        this.simpleActivityStrategy = new ScheduleGateActivityStrategy();
    }

    public static ScheduleGateActivity createCopy(ScheduleGateActivity originalActivity) {
        ScheduleGateActivity newScheduleGateActivity = new ScheduleGateActivity();
        newScheduleGateActivity.setGateActivityLevelId(originalActivity.getGateActivityLevelId());
        newScheduleGateActivity.setGateOpen(new Boolean(false));
        newScheduleGateActivity.setGateEndTimeOffset(originalActivity.getGateEndTimeOffset());
        newScheduleGateActivity.setGateStartTimeOffset(originalActivity.getGateStartTimeOffset());
        newScheduleGateActivity.setGateEndDateTime(originalActivity.getGateEndDateTime());
        newScheduleGateActivity.setGateStartDateTime(originalActivity.getGateStartDateTime());
        newScheduleGateActivity.setActivityUIID(originalActivity.getActivityUIID());
        newScheduleGateActivity.setDescription(originalActivity.getDescription());
        newScheduleGateActivity.setTitle(originalActivity.getTitle());
        newScheduleGateActivity.setHelpText(originalActivity.getHelpText());
        newScheduleGateActivity.setXcoord(originalActivity.getXcoord());
        newScheduleGateActivity.setYcoord(originalActivity.getYcoord());
        newScheduleGateActivity.setActivityTypeId(originalActivity.getActivityTypeId());
        newScheduleGateActivity.setGroupingSupportType(originalActivity.getGroupingSupportType());
        newScheduleGateActivity.setApplyGrouping(originalActivity.getApplyGrouping());
        newScheduleGateActivity.setActivityCategoryID(originalActivity.getActivityCategoryID());
        newScheduleGateActivity.setGrouping(originalActivity.getGrouping());
        newScheduleGateActivity.setGroupingUIID(originalActivity.getGroupingUIID());
        newScheduleGateActivity.setLearningLibrary(originalActivity.getLearningLibrary());
        newScheduleGateActivity.setDefineLater(originalActivity.getDefineLater());
        newScheduleGateActivity.setCreateDateTime(new Date());
        newScheduleGateActivity.setRunOffline(originalActivity.getRunOffline());
        newScheduleGateActivity.setOfflineInstructions(originalActivity.getOfflineInstructions());
        newScheduleGateActivity.setOnlineInstructions(originalActivity.getOnlineInstructions());
        newScheduleGateActivity.setLibraryActivity(originalActivity.getLibraryActivity());
        newScheduleGateActivity.setLibraryActivityUiImage(originalActivity.getLibraryActivityUiImage());
        return newScheduleGateActivity;
    }

    public Date getGateEndDateTime() {
        return this.gateEndDateTime;
    }

    public void setGateEndDateTime(Date gateEndDateTime) {
        this.gateEndDateTime = gateEndDateTime;
    }

    public Date getGateStartDateTime() {
        return this.gateStartDateTime;
    }

    public void setGateStartDateTime(Date gateStartDateTime) {
        this.gateStartDateTime = gateStartDateTime;
    }

    public Long getGateStartTimeOffset() {
        return this.gateStartTimeOffset;
    }

    public void setGateStartTimeOffset(Long gateStartTimeOffset) {
        this.gateStartTimeOffset = gateStartTimeOffset;
    }

    public Long getGateEndTimeOffset() {
        return this.gateEndTimeOffset;
    }

    public void setGateEndTimeOffset(Long gateEndTimeOffset) {
        this.gateEndTimeOffset = gateEndTimeOffset;
    }

    public Date getLessonGateOpenTime(Date lessonStartTime) {
        GregorianCalendar openTime = new GregorianCalendar(TimeZone.getDefault());
        openTime.setTime(lessonStartTime);
        if (this.isScheduledByTimeOffset()) {
            ((Calendar)openTime).add(12, this.getGateStartTimeOffset().intValue());
            this.setGateStartDateTime(openTime.getTime());
        } else if (this.isScheduledByDateTime()) {
            openTime.setTime(this.getGateStartDateTime());
        } else {
            throw new ActivityBehaviorException("No way of scheduling has been setup - this usually should be done at authoring interface. Fail to calculate gate open time for lesson.");
        }
        return openTime.getTime();
    }

    public Date getLessonGateCloseTime(Date lessonStartTime) {
        GregorianCalendar closeTime = new GregorianCalendar(TimeZone.getDefault());
        closeTime.setTime(lessonStartTime);
        if (this.isScheduledByTimeOffset()) {
            ((Calendar)closeTime).add(12, this.getGateEndTimeOffset().intValue());
            this.setGateEndDateTime(closeTime.getTime());
        } else if (this.isScheduledByDateTime()) {
            closeTime.setTime(this.getGateEndDateTime());
        } else {
            throw new ActivityBehaviorException("No way of scheduling has been setup - this usually should be done at authoring interface. Fail to calculate gate close time.");
        }
        return closeTime.getTime();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    public boolean isNull() {
        return false;
    }

    private boolean isScheduledByTimeOffset() {
        return this.getGateStartTimeOffset() != null && this.getGateEndTimeOffset() != null;
    }

    private boolean isScheduledByDateTime() {
        return this.getGateStartDateTime() != null && this.getGateEndDateTime() != null;
    }
}

