/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.usermanagement.User;

public class TestGateActivityStrategy
extends TestCase {
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$learningdesign$TestGateActivityStrategy == null ? (class$org$lamsfoundation$lams$learningdesign$TestGateActivityStrategy = TestGateActivityStrategy.class$("org.lamsfoundation.lams.learningdesign.TestGateActivityStrategy")) : class$org$lamsfoundation$lams$learningdesign$TestGateActivityStrategy));
    private GateActivity scheduleGate = new ScheduleGateActivity();
    private GateActivity permissionGate = new PermissionGateActivity();
    private GateActivity synchGate = new SynchGateActivity();
    private static List testLessonUsers = new ArrayList();
    private static final int NUM_OF_TEST_USERS = 5;
    private static final int TEST_USER_ID = 1;
    static /* synthetic */ Class class$org$lamsfoundation$lams$learningdesign$TestGateActivityStrategy;

    protected void setUp() throws Exception {
        for (int i = 0; i < 5; ++i) {
            testLessonUsers.add(this.createUser(new Integer(i + 1), "tester" + i));
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testShouldCloseSynchGate() {
        User user = this.createUser(new Integer(1), "tester1");
        boolean bl = this.synchGate.shouldOpenGateFor(user, testLessonUsers);
        TestGateActivityStrategy.assertTrue((String)"gate should be closed", (!bl ? 1 : 0) != 0);
        TestGateActivityStrategy.assertEquals((String)"there should be one learner", (int)1, (int)this.synchGate.getWaitingLearners().size());
    }

    public void testShouldOpenSynchGate() {
        int n;
        ArrayList<User> arrayList = new ArrayList<User>();
        for (n = 0; n < 5; ++n) {
            arrayList.add(this.createUser(new Integer(n + 1), "tester" + n));
        }
        n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            User user = (User)arrayList.get(i);
            log.info((Object)("learner " + user.getUserId() + " arrived"));
            n = this.synchGate.shouldOpenGateFor(user, testLessonUsers) ? 1 : 0;
            log.info((Object)("gate status: " + (n != 0 ? "opened" : "closed")));
            if (i + 1 == arrayList.size()) continue;
            TestGateActivityStrategy.assertEquals((String)"verify the number of learners", (int)(i + 1), (int)this.synchGate.getWaitingLearners().size());
        }
        TestGateActivityStrategy.assertTrue((String)"gate should be closed", n != 0);
        TestGateActivityStrategy.assertEquals((String)"there should be no learner waiting for an opened gate", (int)0, (int)this.synchGate.getWaitingLearners().size());
    }

    public void testShouldCloseScheduleGate() {
        User user = this.createUser(new Integer(1), "tester1");
        boolean bl = this.scheduleGate.shouldOpenGateFor(user, testLessonUsers);
        TestGateActivityStrategy.assertTrue((String)"gate should be closed", (!bl ? 1 : 0) != 0);
        TestGateActivityStrategy.assertEquals((String)"there should be one learner", (int)1, (int)this.scheduleGate.getWaitingLearners().size());
    }

    public void testShouldOpenScheduleGate() {
        User user = this.createUser(new Integer(1), "tester1");
        this.scheduleGate.setGateOpen(new Boolean(true));
        boolean bl = this.scheduleGate.shouldOpenGateFor(user, testLessonUsers);
        TestGateActivityStrategy.assertTrue((String)"gate should be closed", (boolean)bl);
        TestGateActivityStrategy.assertEquals((String)"there should be no learner waiting for an opened gate", (int)0, (int)this.scheduleGate.getWaitingLearners().size());
    }

    public void testShouldClosePermissionGate() {
        User user = this.createUser(new Integer(1), "tester1");
        boolean bl = this.permissionGate.shouldOpenGateFor(user, testLessonUsers);
        TestGateActivityStrategy.assertTrue((String)"gate should be closed", (!bl ? 1 : 0) != 0);
        TestGateActivityStrategy.assertEquals((String)"there should be one learner", (int)1, (int)this.permissionGate.getWaitingLearners().size());
    }

    public void testShouldOpenPermissionGate() {
        User user = this.createUser(new Integer(1), "tester1");
        this.permissionGate.setGateOpen(new Boolean(true));
        boolean bl = this.permissionGate.shouldOpenGateFor(user, testLessonUsers);
        TestGateActivityStrategy.assertTrue((String)"gate should be closed", (boolean)bl);
        TestGateActivityStrategy.assertEquals((String)"there should be no learner waiting for an opened gate", (int)0, (int)this.permissionGate.getWaitingLearners().size());
    }

    private User createUser(Integer n, String string) {
        User user = new User();
        user.setUserId(n);
        user.setLogin(string);
        return user;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

