/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;

public class TestScheduleGateActivity
extends TestCase {
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$learningdesign$TestScheduleGateActivity == null ? (class$org$lamsfoundation$lams$learningdesign$TestScheduleGateActivity = TestScheduleGateActivity.class$("org.lamsfoundation.lams.learningdesign.TestScheduleGateActivity")) : class$org$lamsfoundation$lams$learningdesign$TestScheduleGateActivity));
    private ScheduleGateActivity gateByTimeOffset;
    private ScheduleGateActivity gateByDateTime;
    private static final Long START_TIME_OFFSET = new Long(30L);
    private static final Long END_TIME_OFFSET = new Long(60L);
    private Date lessonStartTime;
    static /* synthetic */ Class class$org$lamsfoundation$lams$learningdesign$TestScheduleGateActivity;

    protected void setUp() throws Exception {
        super.setUp();
        this.gateByTimeOffset = new ScheduleGateActivity();
        this.gateByTimeOffset.setGateStartTimeOffset(START_TIME_OFFSET);
        this.gateByTimeOffset.setGateEndTimeOffset(END_TIME_OFFSET);
        this.gateByDateTime = new ScheduleGateActivity();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(gregorianCalendar.getTime());
        this.gateByDateTime.setGateStartDateTime(gregorianCalendar.getTime());
        ((Calendar)gregorianCalendar).add(12, END_TIME_OFFSET.intValue());
        this.gateByDateTime.setGateEndDateTime(gregorianCalendar.getTime());
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2005, 3, 20, 9, 50);
        this.lessonStartTime = gregorianCalendar2.getTime();
        log.info((Object)("new lessonStartTime--" + this.lessonStartTime));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public TestScheduleGateActivity(String string) {
        super(string);
    }

    public void testGetLessonGateOpenTime() {
        TestScheduleGateActivity.assertNotNull((String)"verify real open time by offset", (Object)this.gateByTimeOffset.getLessonGateOpenTime(this.lessonStartTime));
        log.info((Object)("gate open time offset -- " + this.gateByTimeOffset.getGateStartTimeOffset()));
        log.info((Object)("Real gate open time by offset --" + this.gateByTimeOffset.getLessonGateOpenTime(this.lessonStartTime)));
        log.info((Object)("gate open time by offset, calculated open time --" + this.gateByTimeOffset.getGateStartDateTime()));
        TestScheduleGateActivity.assertNotNull((String)"verify real open time by date time", (Object)this.gateByDateTime.getLessonGateOpenTime(this.lessonStartTime));
        log.info((Object)("Real gate open time by date time -- " + this.gateByDateTime.getLessonGateOpenTime(this.lessonStartTime)));
    }

    public void testGetLessonGateCloseTime() {
        TestScheduleGateActivity.assertNotNull((String)"verify real open time", (Object)this.gateByTimeOffset.getLessonGateCloseTime(this.lessonStartTime));
        log.info((Object)("gate close time offset -- " + this.gateByTimeOffset.getGateEndTimeOffset()));
        log.info((Object)("gate close time by offset --" + this.gateByTimeOffset.getLessonGateCloseTime(this.lessonStartTime)));
        log.info((Object)("gate close time by offset, calculated close time --" + this.gateByTimeOffset.getGateEndDateTime()));
        TestScheduleGateActivity.assertNotNull((String)"verify real close time by date time", (Object)this.gateByDateTime.getLessonGateCloseTime(this.lessonStartTime));
        log.info((Object)("Real gate close time by date time -- " + this.gateByDateTime.getLessonGateCloseTime(this.lessonStartTime)));
    }

    public void testGetLessonCloseTimeWithLongOffset() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.gateByDateTime.getGateEndDateTime());
        ((Calendar)gregorianCalendar).add(12, END_TIME_OFFSET.intValue() * 24);
        this.gateByDateTime.setGateEndDateTime(gregorianCalendar.getTime());
        TestScheduleGateActivity.assertNotNull((String)"verify real close time by date time", (Object)this.gateByDateTime.getLessonGateCloseTime(this.lessonStartTime));
        log.info((Object)("gate close date time(UTC) -- " + this.gateByDateTime.getGateEndDateTime()));
        log.info((Object)("Real gate close time by date time -- " + this.gateByDateTime.getLessonGateCloseTime(this.lessonStartTime)));
    }

    private String formatUTCTime(Date date) {
        TimeZone timeZone = TimeZone.getTimeZone("Etc/GMT");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss z");
        simpleDateFormat.setTimeZone(timeZone);
        String string = simpleDateFormat.format(date);
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

