/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dto.TransitionDTO;

public class Transition
implements Serializable {
    private Long transitionId;
    private Integer transitionUIID;
    private Integer toUIID;
    private Integer fromUIID;
    private String description;
    private String title;
    private Date createDateTime;
    Activity toActivity;
    Activity fromActivity;
    LearningDesign learningDesign;

    public Transition(Long transitionId, Integer id, String description, String title, Date createDateTime, Activity toActivity, Activity fromActivity, LearningDesign learningDesign, Integer toUIID, Integer fromUIID) {
        this.transitionId = transitionId;
        this.transitionUIID = id;
        this.description = description;
        this.title = title;
        this.createDateTime = createDateTime;
        this.toActivity = toActivity;
        this.fromActivity = fromActivity;
        this.learningDesign = learningDesign;
        this.toUIID = toUIID;
        this.fromUIID = fromUIID;
    }

    public Transition() {
    }

    public Transition(Long transitionId, Date createDateTime, Activity toActivity, Activity fromActivity, LearningDesign learningDesign) {
        this.transitionId = transitionId;
        this.createDateTime = createDateTime;
        this.toActivity = toActivity;
        this.fromActivity = fromActivity;
        this.learningDesign = learningDesign;
    }

    public static Transition createCopy(Transition originalTransition) {
        Transition newTransition = new Transition();
        newTransition.setTransitionUIID(originalTransition.getTransitionUIID());
        newTransition.setDescription(originalTransition.getDescription());
        newTransition.setTitle(originalTransition.getTitle());
        newTransition.setCreateDateTime(new Date());
        newTransition.setToUIID(originalTransition.getToUIID());
        newTransition.setFromUIID(originalTransition.getFromUIID());
        return newTransition;
    }

    public Long getTransitionId() {
        return this.transitionId;
    }

    public void setTransitionId(Long transitionId) {
        this.transitionId = transitionId;
    }

    public Integer getTransitionUIID() {
        return this.transitionUIID;
    }

    public void setTransitionUIID(Integer id) {
        this.transitionUIID = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    public Activity getToActivity() {
        return this.toActivity;
    }

    public void setToActivity(Activity toActivity) {
        this.toActivity = toActivity;
    }

    public Activity getFromActivity() {
        return this.fromActivity;
    }

    public void setFromActivity(Activity fromActivity) {
        this.fromActivity = fromActivity;
    }

    public LearningDesign getLearningDesign() {
        return this.learningDesign;
    }

    public void setLearningDesign(LearningDesign learningDesign) {
        this.learningDesign = learningDesign;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("transitionId", (Object)this.getTransitionId()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Transition)) {
            return false;
        }
        Transition castOther = (Transition)other;
        return new EqualsBuilder().append((Object)this.getTransitionId(), (Object)castOther.getTransitionId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getTransitionId()).toHashCode();
    }

    public Integer getFromUIID() {
        return this.fromUIID;
    }

    public void setFromUIID(Integer fromUIID) {
        this.fromUIID = fromUIID;
    }

    public Integer getToUIID() {
        return this.toUIID;
    }

    public void setToUIID(Integer toUIID) {
        this.toUIID = toUIID;
    }

    public TransitionDTO getTransitionDTO() {
        return new TransitionDTO(this);
    }
}

