/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao;

import java.util.List;
import org.lamsfoundation.lams.AbstractLamsTestCase;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.TransitionDAO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.WorkspaceFolderDAO;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;

public class TestLearningDesignDAO
extends AbstractLamsTestCase {
    protected ActivityDAO activityDAO;
    private LearningDesignDAO learningDesignDAO;
    protected TransitionDAO transitionDAO;
    protected WorkspaceFolderDAO workspaceFolderDAO;
    private UserDAO userDAO;
    private User user;
    private LearningDesign learningDesign;

    public TestLearningDesignDAO(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.learningDesignDAO = (LearningDesignDAO)this.context.getBean("learningDesignDAO");
        this.transitionDAO = (TransitionDAO)this.context.getBean("transitionDAO");
        this.activityDAO = (ActivityDAO)this.context.getBean("activityDAO");
        this.userDAO = (UserDAO)this.context.getBean("userDAO");
    }

    public void testCalculateFirstActivity() {
        this.learningDesign = this.learningDesignDAO.getLearningDesignById(new Long(2L));
        Activity activity = this.learningDesign.calculateFirstActivity();
        TestLearningDesignDAO.assertNotNull((Object)activity.getActivityId());
        long l = 27L;
        TestLearningDesignDAO.assertEquals((long)activity.getActivityId(), (long)l);
    }

    protected String[] getContextConfigLocation() {
        return new String[]{"WEB-INF/spring/learningDesignApplicationContext.xml", "WEB-INF/spring/applicationContext.xml"};
    }

    public void testGetAllValidLearningDesignsInFolder() {
        List list = this.learningDesignDAO.getAllValidLearningDesignsInFolder(new Integer(1));
        System.out.println("SIZE:" + list.size());
    }

    public void testGetLearningDesignDTO() throws Exception {
        this.learningDesign = this.learningDesignDAO.getLearningDesignById(new Long(2L));
        LearningDesignDTO learningDesignDTO = this.learningDesign.getLearningDesignDTO();
        String string = WDDXProcessor.serialize(learningDesignDTO);
        System.out.println(string);
    }

    protected String getHibernateSessionFactoryName() {
        return "coreSessionFactory";
    }
}

