/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.Date;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class DesignDetailDTO
extends BaseDTO {
    private Long learningDesignId;
    private Integer learningDesignUIID;
    private String description;
    private String title;
    private Long firstActivityID;
    private Boolean validDesign;
    private Boolean readOnly;
    private Date dateReadOnly;
    private Integer userID;
    private String helpText;
    private Integer copyTypeID;
    private String version;
    private Long parentLearningDesignID;
    private Integer workspaceFolderID;

    public DesignDetailDTO() {
    }

    public DesignDetailDTO(Long learningDesignId, Integer learningDesignUIID, String description, String title, Long firstActivityID, Boolean validDesign, Boolean readOnly, Date dateReadOnly, Integer userID, String helpText, Integer copyTypeID, String version, Long parentLearningDesignID, Integer workspaceFolderID) {
        this.learningDesignId = learningDesignId;
        this.learningDesignUIID = learningDesignUIID;
        this.description = description;
        this.title = title;
        this.firstActivityID = firstActivityID;
        this.validDesign = validDesign;
        this.readOnly = readOnly;
        this.dateReadOnly = dateReadOnly;
        this.userID = userID;
        this.helpText = helpText;
        this.copyTypeID = copyTypeID;
        this.version = version;
        this.parentLearningDesignID = parentLearningDesignID;
        this.workspaceFolderID = workspaceFolderID;
    }

    public DesignDetailDTO(LearningDesign learningDesign) {
        this.learningDesignId = learningDesign.getLearningDesignId();
        this.learningDesignUIID = learningDesign.getLearningDesignUIID();
        this.description = learningDesign.getDescription();
        this.title = learningDesign.getTitle();
        this.firstActivityID = learningDesign.getFirstActivity() != null ? learningDesign.getFirstActivity().getActivityId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
        this.validDesign = learningDesign.getValidDesign();
        this.readOnly = learningDesign.getReadOnly();
        this.dateReadOnly = learningDesign.getDateReadOnly();
        this.userID = learningDesign.getUser().getUserId();
        this.helpText = learningDesign.getHelpText();
        this.copyTypeID = learningDesign.getCopyTypeID();
        this.version = learningDesign.getVersion();
        this.parentLearningDesignID = learningDesign.getParentLearningDesign() != null ? learningDesign.getParentLearningDesign().getLearningDesignId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
        this.workspaceFolderID = learningDesign.getWorkspaceFolder().getWorkspaceFolderId();
    }

    public Integer getCopyTypeID() {
        return this.copyTypeID != null ? this.copyTypeID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Date getDateReadOnly() {
        return this.dateReadOnly != null ? this.dateReadOnly : WDDXTAGS.DATE_NULL_VALUE;
    }

    public String getDescription() {
        return this.description != null ? this.description : "string_null_value";
    }

    public Long getFirstActivityID() {
        return this.firstActivityID != null ? this.firstActivityID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public String getHelpText() {
        return this.helpText != null ? this.helpText : "string_null_value";
    }

    public Long getLearningDesignId() {
        return this.learningDesignId != null ? this.learningDesignId : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getLearningDesignUIID() {
        return this.learningDesignUIID != null ? this.learningDesignUIID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Long getParentLearningDesignID() {
        return this.parentLearningDesignID != null ? this.parentLearningDesignID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Boolean getReadOnly() {
        return this.readOnly != null ? this.readOnly : WDDXTAGS.BOOLEAN_NULL_VALUE;
    }

    public String getTitle() {
        return this.title != null ? this.title : "string_null_value";
    }

    public Integer getUserID() {
        return this.userID != null ? this.userID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Boolean getValidDesign() {
        return this.validDesign != null ? this.validDesign : WDDXTAGS.BOOLEAN_NULL_VALUE;
    }

    public String getVersion() {
        return this.version != null ? this.version : "string_null_value";
    }

    public Integer getWorkspaceFolderID() {
        return this.workspaceFolderID != null ? this.workspaceFolderID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }
}

