/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.TransitionDTO;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class LearningDesignDTO {
    private Long learningDesignId;
    private Integer learningDesignUIID;
    private String description;
    private String title;
    private Long firstActivityID;
    private Integer firstActivityUIID;
    private Integer maxID;
    private Boolean validDesign;
    private Boolean readOnly;
    private Date dateReadOnly;
    private Integer userID;
    private String helpText;
    private Integer copyTypeID;
    private Date createDateTime;
    private String version;
    private Long parentLearningDesignID;
    private Integer workspaceFolderID;
    private Long duration;
    private String licenseText;
    private Long licenseID;
    private Long lessonOrgID;
    private String lessonOrgName;
    private Long lessonID;
    private String lessonName;
    private Date lessonStartDateTime;
    private Date lastModifiedDateTime;
    private Hashtable activities;
    private Hashtable transitions;

    public LearningDesignDTO() {
    }

    public LearningDesignDTO(Long learningDesignId, Integer learningDesignUIID, String description, String title, Long firstActivityID, Integer firstActivityUIID, Integer maxId, Boolean validDesign, Boolean readOnly, Date dateReadOnly, Integer userID, String helpText, Integer copyTypeID, Date createDateTime, String version, Long parentLearningDesignID, Integer workspaceFolderID, Long duration, String licenseText, Long licenseID, Long lessonOrgID, String lessonOrgName, Long lessonID, String lessonName, Date lessonStartDateTime, Date lastModifiedDateTime) {
        this.learningDesignId = learningDesignId;
        this.learningDesignUIID = learningDesignUIID;
        this.description = description;
        this.title = title;
        this.firstActivityID = firstActivityID;
        this.firstActivityUIID = firstActivityUIID;
        this.maxID = maxId;
        this.validDesign = validDesign;
        this.readOnly = readOnly;
        this.dateReadOnly = dateReadOnly;
        this.userID = userID;
        this.helpText = helpText;
        this.copyTypeID = copyTypeID;
        this.createDateTime = createDateTime;
        this.version = version;
        this.parentLearningDesignID = parentLearningDesignID;
        this.workspaceFolderID = workspaceFolderID;
        this.duration = duration;
        this.licenseText = licenseText;
        this.licenseID = licenseID;
        this.lessonOrgID = lessonOrgID;
        this.lessonOrgName = lessonOrgName;
        this.lessonID = lessonID;
        this.lessonName = lessonName;
        this.lessonStartDateTime = lessonStartDateTime;
        this.lastModifiedDateTime = lastModifiedDateTime;
        this.activities = new Hashtable();
        this.transitions = new Hashtable();
    }

    public LearningDesignDTO(LearningDesign learningDesign) {
        this.learningDesignId = learningDesign.getLearningDesignId();
        this.learningDesignUIID = learningDesign.getLearningDesignUIID();
        this.description = learningDesign.getDescription();
        this.title = learningDesign.getTitle();
        this.firstActivityID = learningDesign.getFirstActivity() != null ? learningDesign.getFirstActivity().getActivityId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
        this.firstActivityUIID = learningDesign.getFirstActivity() != null ? learningDesign.getFirstActivity().getActivityUIID() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
        this.maxID = learningDesign.getMaxId();
        this.validDesign = learningDesign.getValidDesign();
        this.readOnly = learningDesign.getReadOnly();
        this.dateReadOnly = learningDesign.getDateReadOnly();
        this.userID = learningDesign.getUser() != null ? learningDesign.getUser().getUserId() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
        this.helpText = learningDesign.getHelpText();
        this.copyTypeID = learningDesign.getCopyTypeID();
        this.createDateTime = learningDesign.getCreateDateTime();
        this.version = learningDesign.getVersion();
        this.parentLearningDesignID = learningDesign.getParentLearningDesign() != null ? learningDesign.getParentLearningDesign().getLearningDesignId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
        this.workspaceFolderID = learningDesign.getWorkspaceFolder() != null ? learningDesign.getWorkspaceFolder().getWorkspaceFolderId() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
        this.duration = learningDesign.getDuration();
        this.licenseText = learningDesign.getLicenseText();
        this.licenseID = learningDesign.getLicense() != null ? learningDesign.getLicense().getLicenseID() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
        this.lessonOrgID = learningDesign.getLessonOrgID();
        this.lessonOrgName = learningDesign.getLessonOrgName();
        this.lessonID = learningDesign.getLessonID();
        this.lessonName = learningDesign.getLessonName();
        this.lessonStartDateTime = learningDesign.getLessonStartDateTime();
        this.lastModifiedDateTime = learningDesign.getLastModifiedDateTime();
        this.activities = this.populateActivities(learningDesign);
        this.transitions = this.populateTransitions(learningDesign);
    }

    public Integer getCopyTypeID() {
        return this.copyTypeID != null ? this.copyTypeID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Date getCreateDateTime() {
        return this.createDateTime != null ? this.createDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public Date getDateReadOnly() {
        return this.dateReadOnly != null ? this.dateReadOnly : WDDXTAGS.DATE_NULL_VALUE;
    }

    public String getDescription() {
        return this.description != null ? this.description : "string_null_value";
    }

    public Long getDuration() {
        return this.duration != null ? this.duration : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Long getFirstActivityID() {
        return this.firstActivityID != null ? this.firstActivityID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public String getHelpText() {
        return this.helpText != null ? this.helpText : "string_null_value";
    }

    public Date getLastModifiedDateTime() {
        return this.lastModifiedDateTime != null ? this.lastModifiedDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public Long getLearningDesignId() {
        return this.learningDesignId != null ? this.learningDesignId : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getLearningDesignUIID() {
        return this.learningDesignUIID != null ? this.learningDesignUIID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Long getLessonID() {
        return this.lessonID != null ? this.lessonID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public String getLessonName() {
        return this.lessonName != null ? this.lessonName : "string_null_value";
    }

    public Long getLessonOrgID() {
        return this.lessonOrgID != null ? this.lessonOrgID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public String getLessonOrgName() {
        return this.lessonOrgName != null ? this.lessonOrgName : "string_null_value";
    }

    public Date getLessonStartDateTime() {
        return this.lessonStartDateTime != null ? this.lessonStartDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public Long getLicenseID() {
        return this.licenseID != null ? this.licenseID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public String getLicenseText() {
        return this.licenseText != null ? this.licenseText : "string_null_value";
    }

    public Integer getMaxID() {
        return this.maxID != null ? this.maxID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Long getParentLearningDesignID() {
        return this.parentLearningDesignID != null ? this.parentLearningDesignID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Boolean getReadOnly() {
        return this.readOnly != null ? this.readOnly : WDDXTAGS.BOOLEAN_NULL_VALUE;
    }

    public String getTitle() {
        return this.title != null ? this.title : "string_null_value";
    }

    public Integer getUserID() {
        return this.userID != null ? this.userID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Boolean getValidDesign() {
        return this.validDesign != null ? this.validDesign : WDDXTAGS.BOOLEAN_NULL_VALUE;
    }

    public String getVersion() {
        return this.version != null ? this.version : "string_null_value";
    }

    public Integer getWorkspaceFolderID() {
        return this.workspaceFolderID != null ? this.workspaceFolderID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Hashtable getActivities() {
        return this.activities;
    }

    public Hashtable populateActivities(LearningDesign design) {
        Hashtable<Long, AuthoringActivityDTO> activities = new Hashtable<Long, AuthoringActivityDTO>();
        Hashtable<Long, AuthoringActivityDTO> childActivities = null;
        Iterator parentIterator = design.getParentActivities().iterator();
        while (parentIterator.hasNext()) {
            Object object = parentIterator.next();
            if (object instanceof ComplexActivity) {
                ComplexActivity complexActivity = (ComplexActivity)object;
                Iterator childIterator = complexActivity.getActivities().iterator();
                childActivities = new Hashtable<Long, AuthoringActivityDTO>();
                while (childIterator.hasNext()) {
                    Activity activity = (Activity)childIterator.next();
                    childActivities.put(activity.getActivityId(), activity.getAuthoringActivityDTO());
                }
                activities.put(complexActivity.getActivityId(), complexActivity.getAuthoringActivityDTO());
                activities.putAll(childActivities);
                continue;
            }
            Activity activity = (Activity)object;
            activities.put(activity.getActivityId(), activity.getAuthoringActivityDTO());
        }
        return activities;
    }

    public Hashtable populateTransitions(LearningDesign design) {
        Hashtable<Long, TransitionDTO> transitions = new Hashtable<Long, TransitionDTO>();
        if (design.getTransitions() != null) {
            Iterator iterator = design.getTransitions().iterator();
            while (iterator.hasNext()) {
                Transition trans = (Transition)iterator.next();
                transitions.put(trans.getTransitionId(), trans.getTransitionDTO());
            }
        }
        return transitions;
    }

    public Hashtable getTransitions() {
        return this.transitions;
    }

    public void setActivities(Hashtable activities) {
        this.activities = activities;
    }

    public void setCopyTypeID(Integer copyTypeID) {
        this.copyTypeID = copyTypeID;
    }

    public void setCreateDateTime(Date createDateTime) {
        if (!createDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.createDateTime = createDateTime;
        }
    }

    public void setDateReadOnly(Date dateReadOnly) {
        if (!dateReadOnly.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.dateReadOnly = dateReadOnly;
        }
    }

    public void setDescription(String description) {
        if (!description.equals("string_null_value")) {
            this.description = description;
        }
    }

    public void setDuration(Long duration) {
        if (!duration.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.duration = duration;
        }
    }

    public void setFirstActivityID(Long firstActivityID) {
        if (!firstActivityID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.firstActivityID = firstActivityID;
        }
    }

    public void setHelpText(String helpText) {
        if (!helpText.equals("string_null_value")) {
            this.helpText = helpText;
        }
    }

    public void setLastModifiedDateTime(Date lastModifiedDateTime) {
        if (!lastModifiedDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.lastModifiedDateTime = lastModifiedDateTime;
        }
    }

    public void setLearningDesignId(Long learningDesignId) {
        if (!learningDesignId.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.learningDesignId = learningDesignId;
        }
    }

    public void setLearningDesignUIID(Integer learningDesignUIID) {
        if (!learningDesignUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.learningDesignUIID = learningDesignUIID;
        }
    }

    public void setLessonID(Long lessonID) {
        if (!lessonID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.lessonID = lessonID;
        }
    }

    public void setLessonName(String lessonName) {
        if (!lessonName.equals("string_null_value")) {
            this.lessonName = lessonName;
        }
    }

    public void setLessonOrgID(Long lessonOrgID) {
        if (!lessonOrgID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.lessonOrgID = lessonOrgID;
        }
    }

    public void setLessonOrgName(String lessonOrgName) {
        if (!lessonOrgName.equals("string_null_value")) {
            this.lessonOrgName = lessonOrgName;
        }
    }

    public void setLessonStartDateTime(Date lessonStartDateTime) {
        if (!lessonStartDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.lessonStartDateTime = lessonStartDateTime;
        }
    }

    public void setLicenseID(Long licenseID) {
        if (!licenseID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.licenseID = licenseID;
        }
    }

    public void setLicenseText(String licenseText) {
        if (!licenseText.equals("string_null_value")) {
            this.licenseText = licenseText;
        }
    }

    public void setMaxID(Integer maxID) {
        if (!maxID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.maxID = maxID;
        }
    }

    public void setParentLearningDesignID(Long parentLearningDesignID) {
        if (!parentLearningDesignID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.parentLearningDesignID = parentLearningDesignID;
        }
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setTitle(String title) {
        if (!title.equals("string_null_value")) {
            this.title = title;
        }
    }

    public void setTransitions(Hashtable transitions) {
        this.transitions = transitions;
    }

    public void setUserID(Integer userID) {
        if (!userID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.userID = userID;
        }
    }

    public void setValidDesign(Boolean validDesign) {
        this.validDesign = validDesign;
    }

    public void setVersion(String version) {
        if (!version.equals("string_null_value")) {
            this.version = version;
        }
    }

    public void setWorkspaceFolderID(Integer workspaceFolderID) {
        if (!workspaceFolderID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.workspaceFolderID = workspaceFolderID;
        }
    }

    public Integer getFirstActivityUIID() {
        return this.firstActivityUIID != null ? this.firstActivityUIID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public void setFirstActivityUIID(Integer firstActivityUIID) {
        if (!firstActivityUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.firstActivityUIID = firstActivityUIID;
        }
    }

    public static LearningDesign extractLearningDesign(LearningDesignDTO learningDesignDTO) {
        LearningDesign learningDesign = new LearningDesign();
        if (!learningDesignDTO.getLearningDesignUIID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            learningDesign.setLearningDesignUIID(learningDesignDTO.getLearningDesignUIID());
        }
        if (!learningDesignDTO.getDescription().equals("string_null_value")) {
            learningDesign.setDescription(learningDesignDTO.getDescription());
        }
        if (!learningDesignDTO.getTitle().equals("string_null_value")) {
            learningDesign.setTitle(learningDesignDTO.getTitle());
        }
        if (!learningDesignDTO.getMaxID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            learningDesign.setMaxId(learningDesignDTO.getMaxID());
        }
        learningDesign.setValidDesign(learningDesignDTO.getValidDesign());
        learningDesign.setReadOnly(learningDesignDTO.getReadOnly());
        if (!learningDesignDTO.getCopyTypeID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            learningDesign.setCopyTypeID(learningDesignDTO.getCopyTypeID());
        }
        if (!learningDesignDTO.getHelpText().equals("string_null_value")) {
            learningDesign.setHelpText(learningDesignDTO.getHelpText());
        }
        if (!learningDesignDTO.getVersion().equals("string_null_value")) {
            learningDesign.setVersion(learningDesignDTO.getVersion());
        }
        if (!learningDesignDTO.getLicenseText().equals("string_null_value")) {
            learningDesign.setLicenseText(learningDesignDTO.getLicenseText());
        }
        if (!learningDesignDTO.getLessonOrgName().equals("string_null_value")) {
            learningDesign.setLessonOrgName(learningDesignDTO.getLessonOrgName());
        }
        if (!learningDesignDTO.getLessonName().equals("string_null_value")) {
            learningDesign.setLessonName(learningDesignDTO.getLessonName());
        }
        if (!learningDesignDTO.getDateReadOnly().equals(WDDXTAGS.DATE_NULL_VALUE)) {
            learningDesign.setDateReadOnly(learningDesignDTO.getDateReadOnly());
        }
        if (!learningDesignDTO.getCreateDateTime().equals(WDDXTAGS.DATE_NULL_VALUE)) {
            learningDesign.setCreateDateTime(learningDesignDTO.getCreateDateTime());
        }
        if (!learningDesignDTO.getLessonStartDateTime().equals(WDDXTAGS.DATE_NULL_VALUE)) {
            learningDesign.setLessonStartDateTime(learningDesignDTO.getLessonStartDateTime());
        }
        if (!learningDesignDTO.getLastModifiedDateTime().equals(WDDXTAGS.DATE_NULL_VALUE)) {
            learningDesign.setLastModifiedDateTime(learningDesignDTO.getLastModifiedDateTime());
        }
        if (!learningDesignDTO.getLessonID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            learningDesign.setLessonID(learningDesignDTO.getLessonID());
        }
        if (!learningDesignDTO.getLessonOrgID().equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            learningDesign.setLessonOrgID(learningDesignDTO.getLessonOrgID());
        }
        if (!learningDesignDTO.getDuration().equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            learningDesign.setDuration(learningDesignDTO.getDuration());
        }
        return learningDesign;
    }
}

