/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.strategy.SimpleActivityStrategy;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class MonitoringActivityDTO {
    private String title;
    private String description;
    private Long activityID;
    private Integer activityTypeID;
    private Integer orderID;
    private Integer contributionType;
    private Boolean isRequired;

    public MonitoringActivityDTO() {
    }

    public MonitoringActivityDTO(Activity activity, Integer contributionType) {
        this.title = activity.getTitle();
        this.description = activity.getDescription();
        this.activityID = activity.getActivityId();
        this.activityTypeID = activity.getActivityTypeId();
        this.contributionType = contributionType;
        this.orderID = activity.getOrderId();
        this.isRequired = new Boolean(this.calculateIsRequired(contributionType));
    }

    private boolean calculateIsRequired(Integer contributionType) {
        return contributionType.equals(SimpleActivityStrategy.DEFINE_LATER) || contributionType.equals(SimpleActivityStrategy.PERMISSION_GATE) || contributionType.equals(SimpleActivityStrategy.CHOSEN_GROUPING);
    }

    public Long getActivityID() {
        return this.activityID != null ? this.activityID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getActivityTypeID() {
        return this.activityTypeID != null ? this.activityTypeID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public String getDescription() {
        return this.description != null ? this.description : "string_null_value";
    }

    public Integer getOrderID() {
        return this.orderID != null ? this.orderID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public String getTitle() {
        return this.title != null ? this.title : "string_null_value";
    }

    public Integer getContributionType() {
        return this.contributionType != null ? this.contributionType : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Boolean getIsRequired() {
        return this.isRequired != null ? this.isRequired : new Boolean(false);
    }
}

