/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dao;

import java.util.Date;
import java.util.List;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.LessonDataAccessTestCase;
import org.springframework.orm.hibernate.HibernateSystemException;

public class TestLessonDAO
extends LessonDataAccessTestCase {
    private static final Long TEST_EXT_LESSON_ID = new Long(1L);

    public TestLessonDAO(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        super.initializeTestLesson();
    }

    protected void tearDown() throws Exception {
        super.cleanUpTestLesson();
        super.tearDown();
    }

    public void testGetLessonWithEagerlyFetchedProgress() {
        Lesson lesson = this.lessonDao.getLessonWithEagerlyFetchedProgress(this.testLesson.getLessonId());
        super.assertLesson(lesson);
    }

    public void testGetExistingLesson() {
        Lesson lesson = this.lessonDao.getLesson(TEST_EXT_LESSON_ID);
        TestLessonDAO.assertNotNull((Object)lesson);
    }

    public void testGetActiveLessonsForLearner() {
        List list = this.lessonDao.getActiveLessonsForLearner(this.testUser);
        TestLessonDAO.assertEquals((String)"verify the number of lesson we get", (int)0, (int)list.size());
    }

    public void testGetActiveLearnersByLesson() {
        List list = this.lessonDao.getActiveLearnerByLesson(2L);
        TestLessonDAO.assertNotNull((Object)list);
    }

    public void testUpdateLesson() {
        Lesson lesson = this.lessonDao.getLesson(this.testLesson.getLessonId());
        TestLessonDAO.assertEquals((String)"should be created state now", (Object)Lesson.CREATED, (Object)lesson.getLessonStateId());
        TestLessonDAO.assertNull((String)"ensure we are testing right lesson", (Object)lesson.getScheduleEndDate());
        lesson.setLessonStateId(Lesson.STARTED_STATE);
        lesson.setScheduleEndDate(new Date(System.currentTimeMillis() + 60L));
        this.lessonDao.updateLesson(lesson);
        Lesson lesson2 = this.lessonDao.getLesson(this.testLesson.getLessonId());
        TestLessonDAO.assertEquals((String)"verify the updated lesson state", (Object)Lesson.STARTED_STATE, (Object)lesson2.getLessonStateId());
        TestLessonDAO.assertNotNull((String)"verify the sechdule end date", (Object)lesson2.getScheduleEndDate());
        List list = this.lessonDao.getActiveLessonsForLearner(this.testUser);
        TestLessonDAO.assertEquals((String)"verify the number of lesson we get", (int)1, (int)list.size());
    }

    public void testCreateLessonWithoutName() {
        Lesson lesson = Lesson.createNewLessonWithoutClass(null, null, this.testUser, this.testLearningDesign);
        try {
            this.lessonDao.saveLesson(lesson);
            TestLessonDAO.fail((String)"we are meant to get failure of inserting a lesson without name");
        }
        catch (HibernateSystemException hibernateSystemException) {
            TestLessonDAO.assertTrue((String)"excpetion expected.", (boolean)true);
            this.setShouldFlush(false);
        }
    }
}

