/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.service;

import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolDataAccessTestCase;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolSessionDAO;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.tool.service.LamsToolServiceException;

public class TestLamsCoreToolService
extends ToolDataAccessTestCase {
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$tool$service$TestLamsCoreToolService == null ? (class$org$lamsfoundation$lams$tool$service$TestLamsCoreToolService = TestLamsCoreToolService.class$("org.lamsfoundation.lams.tool.service.TestLamsCoreToolService")) : class$org$lamsfoundation$lams$tool$service$TestLamsCoreToolService));
    private ILamsCoreToolService toolService;
    static /* synthetic */ Class class$org$lamsfoundation$lams$tool$service$TestLamsCoreToolService;

    protected void setUp() throws Exception {
        super.setUp();
        this.toolService = (ILamsCoreToolService)this.context.getBean("lamsCoreToolService");
        this.toolSessionDao = (ToolSessionDAO)this.context.getBean("toolSessionDAO");
        super.initTestToolSession();
        this.toolSessionDao.saveToolSession(this.ngToolSession);
        this.toolSessionDao.saveToolSession(this.gToolSession);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.toolSessionDao.removeToolSession(this.ngToolSession);
        this.toolSessionDao.removeToolSession(this.gToolSession);
    }

    public TestLamsCoreToolService(String string) {
        super(string);
    }

    public void testGetNGToolSessionByActivityId() throws LamsToolServiceException {
        ToolSession toolSession = this.toolService.getToolSessionByActivity(this.testUser, this.testNonGroupedActivity);
        TestLamsCoreToolService.assertNotNull((Object)toolSession);
    }

    public void testGetGroupedToolSessionByActivityId() throws LamsToolServiceException {
        ToolSession toolSession = this.toolService.getToolSessionByActivity(this.testUser, this.testGroupedActivity);
        TestLamsCoreToolService.assertNotNull((Object)toolSession);
    }

    public void testGetToolURLByLearnerMode() throws LamsToolServiceException {
        String string = this.toolService.getLearnerToolURLByMode(this.testNonGroupedActivity, this.testUser, ToolAccessMode.LEARNER);
        TestLamsCoreToolService.assertNotNull((Object)string);
        TestLamsCoreToolService.assertTrue((string.indexOf("?") > 0 ? 1 : 0) != 0);
        TestLamsCoreToolService.assertTrue((string.indexOf(ToolAccessMode.LEARNER.toString()) > 0 ? 1 : 0) != 0);
        TestLamsCoreToolService.assertTrue((string.indexOf("mode") > 0 ? 1 : 0) != 0);
        log.info((Object)("learner url:" + string));
    }

    public void testGetToolURLByTeacherMode() throws LamsToolServiceException {
        String string = this.toolService.getLearnerToolURLByMode(this.testNonGroupedActivity, this.testUser, ToolAccessMode.TEACHER);
        TestLamsCoreToolService.assertNotNull((Object)string);
        log.info((Object)("monitor url:" + string));
        TestLamsCoreToolService.assertTrue((string.indexOf("?") > 0 ? 1 : 0) != 0);
        TestLamsCoreToolService.assertTrue((string.indexOf(ToolAccessMode.TEACHER.toString()) > 0 ? 1 : 0) != 0);
        TestLamsCoreToolService.assertTrue((string.indexOf("mode") > 0 ? 1 : 0) != 0);
    }

    public void testGetToolURLByAuthorMode() throws LamsToolServiceException {
        String string = this.toolService.getLearnerToolURLByMode(this.testNonGroupedActivity, this.testUser, ToolAccessMode.AUTHOR);
        TestLamsCoreToolService.assertNotNull((Object)string);
        log.info((Object)("author url:" + string));
        TestLamsCoreToolService.assertTrue((string.indexOf("?") > 0 ? 1 : 0) != 0);
        TestLamsCoreToolService.assertTrue((string.indexOf(ToolAccessMode.AUTHOR.toString()) > 0 ? 1 : 0) != 0);
        TestLamsCoreToolService.assertTrue((string.indexOf("mode") > 0 ? 1 : 0) != 0);
    }

    public void testGetToolURLByLearnerModeForGroupedTool() throws LamsToolServiceException {
        String string = this.toolService.getLearnerToolURLByMode(this.testGroupedActivity, this.testUser, ToolAccessMode.LEARNER);
        TestLamsCoreToolService.assertNotNull((Object)string);
        log.info((Object)("Non grouped activity learner url:" + string));
        TestLamsCoreToolService.assertTrue((string.indexOf("?") > 0 ? 1 : 0) != 0);
        TestLamsCoreToolService.assertTrue((string.indexOf(ToolAccessMode.LEARNER.toString()) != -1 ? 1 : 0) != 0);
        TestLamsCoreToolService.assertTrue((string.indexOf("mode") > 0 ? 1 : 0) != 0);
    }

    public void testSetupToolURLWithToolContent() {
        String string = "http://localhost:8080/lams/test.do?method=test";
        String string2 = this.toolService.setupToolURLWithToolContent(this.testNonGroupedActivity, string);
        log.info((Object)("test url with content id:" + string2));
        TestLamsCoreToolService.assertTrue((string2.indexOf("content_id") > 0 ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

