/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement;

import java.io.IOException;
import java.util.Date;
import org.lamsfoundation.lams.AbstractLamsTestCase;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.AuthenticationMethodDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.OrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.OrganisationTypeDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.RoleDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserDAO;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;

public class TestUserManagementService
extends AbstractLamsTestCase {
    protected UserDAO userDAO;
    protected RoleDAO roleDAO;
    protected OrganisationDAO organisationDAO;
    protected OrganisationTypeDAO organisationTypeDAO;
    protected UserManagementService userManagementService;
    protected AuthenticationMethodDAO authenticationMethodDAO;

    public TestUserManagementService(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.userDAO = (UserDAO)this.context.getBean("userDAO");
        this.organisationDAO = (OrganisationDAO)this.context.getBean("organisationDAO");
        this.organisationTypeDAO = (OrganisationTypeDAO)this.context.getBean("organisationTypeDAO");
        this.userManagementService = (UserManagementService)this.context.getBean("userManagementService");
        this.authenticationMethodDAO = (AuthenticationMethodDAO)this.context.getBean("authenticationMethodDAO");
        this.roleDAO = (RoleDAO)this.context.getBean("roleDAO");
    }

    protected String[] getContextConfigLocation() {
        return new String[]{"WEB-INF/spring/applicationContext.xml", "WEB-INF/spring/learningDesignApplicationContext.xml"};
    }

    public void testSaveOrganisation() {
        Organisation organisation = new Organisation("Test Organisation", "Test Organisation Description", new Date(), this.organisationTypeDAO.getOrganisationTypeById(new Integer(1)));
        Integer n = this.userManagementService.saveOrganisation(organisation, new Integer(1));
        TestUserManagementService.assertNotNull((Object)n);
    }

    public void saveUser() {
        User user = new User();
        user.setLogin("Monu");
        user.setPassword("Monu");
        user.setDisabledFlag(new Boolean(false));
        user.setCreateDate(new Date());
        user.setAuthenticationMethod(this.authenticationMethodDAO.getAuthenticationMethodById(new Integer(2)));
        user.setBaseOrganisation(this.organisationDAO.getOrganisationById(new Integer(1)));
        TestUserManagementService.assertNotNull((Object)this.userManagementService.saveUser(user, new Integer(4)));
    }

    public void testMoveLearningDesign() throws IOException {
        String string = this.userManagementService.moveLearningDesign(new Long(1L), new Integer(4), new Integer(1));
        System.out.println(string);
    }

    public void testGetOrganisationsForUserByRole() throws IOException {
        String string = this.userManagementService.getWDDXForOrganisationsForUserByRole(new Integer(4), "AUTHOR");
        System.out.println(string);
    }

    public void testGetUsersFromOrganisationByRole() throws IOException {
        String string = this.userManagementService.getUsersFromOrganisationByRole(new Integer(4), "AUTHOR");
        System.out.println(string);
    }

    protected String getHibernateSessionFactoryName() {
        return "coreSessionFactory";
    }
}

