/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace;

import java.io.IOException;
import org.lamsfoundation.lams.AbstractLamsTestCase;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceFolderDAO;
import org.lamsfoundation.lams.workspace.service.WorkspaceManagementService;

public class TestWorkspaceManagement
extends AbstractLamsTestCase {
    protected WorkspaceManagementService workspaceManagementService;
    protected IWorkspaceFolderDAO workspaceFolderDAO;

    public TestWorkspaceManagement(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.workspaceManagementService = (WorkspaceManagementService)this.context.getBean("workspaceManagementService");
        this.workspaceFolderDAO = (IWorkspaceFolderDAO)this.context.getBean("workspaceFolderDAO");
    }

    protected String[] getContextConfigLocation() {
        return new String[]{"WEB-INF/spring/authoringApplicationContext.xml", "WEB-INF/spring/workspaceApplicationContext.xml", "WEB-INF/spring/learningDesignApplicationContext.xml", "WEB-INF/spring/applicationContext.xml"};
    }

    protected String getHibernateSessionFactoryName() {
        return "coreSessionFactory";
    }

    public void testGetFolderContents() throws IOException {
        String string = this.workspaceManagementService.getFolderContents(new Integer(4), new Integer(2), WorkspaceManagementService.AUTHORING);
        System.out.println(string);
    }

    public void testCopyFolder() throws IOException {
        String string = this.workspaceManagementService.copyFolder(new Integer(2), new Integer(8), new Integer(4));
        System.out.println(string);
    }

    public void testDeleteFolder() throws IOException {
        String string = this.workspaceManagementService.deleteFolder(new Integer(7), new Integer(4));
        System.out.println(string);
    }

    public void testDeleteLearningDesign() throws Exception {
        String string = this.workspaceManagementService.deleteLearningDesign(new Long(1L), new Integer(4));
        System.out.println(string);
    }

    public void testMoveFolder() throws Exception {
        String string = this.workspaceManagementService.moveFolder(new Integer(6), new Integer(2), new Integer(4));
        System.out.println(string);
        WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(new Integer(6));
        TestWorkspaceManagement.assertTrue((boolean)workspaceFolder.getParentWorkspaceFolder().getWorkspaceFolderId().equals(new Integer(2)));
    }
}

