/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.Workspace;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserDAO;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceDAO;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceFolderDAO;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;
import org.lamsfoundation.lams.workspace.dto.FolderContentDTO;
import org.lamsfoundation.lams.workspace.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;

public class WorkspaceManagementService
implements IWorkspaceManagementService {
    private FlashMessage flashMessage;
    public static final Integer AUTHORING = new Integer(1);
    public static final Integer MONITORING = new Integer(2);
    protected IUserDAO userDAO;
    protected ILearningDesignDAO learningDesignDAO;
    protected IWorkspaceFolderDAO workspaceFolderDAO;
    protected IWorkspaceDAO workspaceDAO;
    protected IOrganisationDAO organisationDAO;
    protected IAuthoringService authoringService;

    public void setAuthoringService(IAuthoringService authoringService) {
        this.authoringService = authoringService;
    }

    public void setOrganisationDAO(IOrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setWorkspaceDAO(IWorkspaceDAO workspaceDAO) {
        this.workspaceDAO = workspaceDAO;
    }

    public void setWorkspaceFolderDAO(IWorkspaceFolderDAO workspaceFolderDAO) {
        this.workspaceFolderDAO = workspaceFolderDAO;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setUserDAO(IUserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public String deleteFolder(Integer folderID, Integer userID) throws IOException {
        WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(folderID);
        User user = this.userDAO.getUserById(userID);
        if (user != null) {
            if (!this.getPermissions(workspaceFolder, user).equals(WorkspaceFolder.OWNER_ACCESS)) {
                this.flashMessage = FlashMessage.getUserNotAuthorized("deleteFolder", userID);
            } else if (workspaceFolder != null) {
                if (this.isRootFolder(workspaceFolder)) {
                    this.flashMessage = new FlashMessage("deleteFolder", "Cannot delete this folder as it is the Root folder.", 1);
                } else if (!workspaceFolder.isEmpty()) {
                    this.flashMessage = new FlashMessage("deleteFolder", "Cannot delete folder with folder_id of: " + folderID + " as it is not empty. Please delete its contents first.", 1);
                } else {
                    this.workspaceFolderDAO.delete(workspaceFolder);
                    this.flashMessage = new FlashMessage("deleteFolder", "Folder deleted:" + folderID);
                }
            } else {
                this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists("deleteFolder", folderID);
            }
        } else {
            this.flashMessage = FlashMessage.getNoSuchUserExists("deleteFolder", userID);
        }
        return this.flashMessage.serializeMessage();
    }

    private boolean isRootFolder(WorkspaceFolder workspaceFolder) {
        try {
            Workspace workspace = this.workspaceDAO.getWorkspaceByRootFolderID(workspaceFolder.getWorkspaceFolderId());
            return workspace != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getFolderContents(Integer userID, Integer workspaceFolderID, Integer mode) throws IOException {
        User user = this.userDAO.getUserById(userID);
        WorkspaceFolder workspaceFolder = null;
        Integer permissions = null;
        if (user != null) {
            workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(workspaceFolderID);
            if (workspaceFolder != null) {
                permissions = this.getPermissions(workspaceFolder, user);
                if (permissions != WorkspaceFolder.NO_ACCESS) {
                    Vector contentDTO = new Vector();
                    this.getFolderContent(workspaceFolder, permissions, mode, contentDTO);
                    if (workspaceFolder.hasSubFolders()) {
                        this.getSubFolderDetails(workspaceFolder, permissions, contentDTO);
                    }
                    this.flashMessage = new FlashMessage("getFolderContents", this.createFolderContentPacket(workspaceFolder, contentDTO));
                } else {
                    this.flashMessage = new FlashMessage("getFolderContents", "Access Denied for user with user_id:" + userID, 1);
                }
            } else {
                this.flashMessage = new FlashMessage("getFolderContents", "No such workspaceFolder with workspace_folder_id of:" + workspaceFolderID + " exists", 1);
            }
        } else {
            this.flashMessage = FlashMessage.getNoSuchUserExists("getFolderContents", userID);
        }
        return this.flashMessage.serializeMessage();
    }

    private void getFolderContent(WorkspaceFolder workspaceFolder, Integer permissions, Integer mode, Vector contentDTO) {
        Integer parentFolderId = workspaceFolder.getParentWorkspaceFolder() != null ? workspaceFolder.getParentWorkspaceFolder().getWorkspaceFolderId() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
        List designs = null;
        designs = mode == AUTHORING ? this.learningDesignDAO.getAllLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId()) : this.learningDesignDAO.getAllValidLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId());
        this.getFolderContentDTO(designs, permissions, contentDTO);
    }

    private void getSubFolderDetails(WorkspaceFolder workspaceFolder, Integer permissions, Vector subFolderContent) {
        Iterator iterator = workspaceFolder.getChildWorkspaceFolders().iterator();
        while (iterator.hasNext()) {
            WorkspaceFolder subFolder = (WorkspaceFolder)iterator.next();
            subFolderContent.add(new FolderContentDTO(subFolder, permissions));
        }
    }

    public Integer getPermissions(WorkspaceFolder workspaceFolder, User user) {
        Integer permission = null;
        WorkspaceFolder userRootFolder = user.getWorkspace().getRootFolder();
        permission = this.isUserOwner(workspaceFolder, user) ? WorkspaceFolder.OWNER_ACCESS : (this.isSubFolder(workspaceFolder, userRootFolder) ? (this.isRunSequencesFolder(workspaceFolder, user) ? WorkspaceFolder.READ_ACCESS : WorkspaceFolder.OWNER_ACCESS) : (this.isParentOrganisationFolder(workspaceFolder, user) ? WorkspaceFolder.MEMBERSHIP_ACCESS : (user.hasMemberAccess(workspaceFolder) ? WorkspaceFolder.MEMBERSHIP_ACCESS : WorkspaceFolder.NO_ACCESS)));
        return permission;
    }

    private boolean isSubFolder(WorkspaceFolder workspaceFolder, WorkspaceFolder rootFolder) {
        List subFolders = this.workspaceFolderDAO.getWorkspaceFolderByParentFolder(rootFolder.getWorkspaceFolderId());
        Iterator iterator = subFolders.iterator();
        while (iterator.hasNext()) {
            WorkspaceFolder subFolder = (WorkspaceFolder)iterator.next();
            if (subFolder.getWorkspaceFolderId() != workspaceFolder.getWorkspaceFolderId()) continue;
            return true;
        }
        return false;
    }

    public boolean isRunSequencesFolder(WorkspaceFolder workspaceFolder, User user) {
        WorkspaceFolder runSequencesFolder = this.workspaceFolderDAO.getRunSequencesFolderForUser(user.getUserId());
        return workspaceFolder.getWorkspaceFolderId() == runSequencesFolder.getWorkspaceFolderId();
    }

    public boolean isParentOrganisationFolder(WorkspaceFolder workspaceFolder, User user) {
        WorkspaceFolder parentOrganisationFolder = user.getBaseOrganisation().getWorkspace().getRootFolder();
        return parentOrganisationFolder.getWorkspaceFolderId() == workspaceFolder.getWorkspaceFolderId();
    }

    private Vector getFolderContentDTO(List designs, Integer permissions, Vector folderContent) {
        Iterator iterator = designs.iterator();
        while (iterator.hasNext()) {
            LearningDesign design = (LearningDesign)iterator.next();
            folderContent.add(new FolderContentDTO(design, permissions));
        }
        return folderContent;
    }

    private Hashtable createFolderContentPacket(WorkspaceFolder workspaceFolder, Vector contents) {
        Hashtable<String, Serializable> packet = new Hashtable<String, Serializable>();
        packet.put("parentWorkspaceFolderID", workspaceFolder.getParentWorkspaceFolder().getWorkspaceFolderId());
        packet.put("workspaceFolderID", workspaceFolder.getWorkspaceFolderId());
        packet.put("contents", contents);
        return packet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String copyFolder(Integer folderID, Integer newFolderID, Integer userID) throws IOException {
        try {
            if (this.isUserAuthorized(newFolderID, userID)) {
                WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(folderID);
                if (workspaceFolder == null) throw new WorkspaceFolderException();
                WorkspaceFolder newFolder = this.createFolder(newFolderID, workspaceFolder.getName(), userID);
                this.copyRootContent(workspaceFolder, newFolder, userID);
                if (workspaceFolder.hasSubFolders()) {
                    this.createSubFolders(workspaceFolder, newFolder, userID);
                }
                this.flashMessage = new FlashMessage("copyFolder", this.createCopyFolderPacket(newFolder));
                return this.flashMessage.serializeMessage();
            } else {
                this.flashMessage = FlashMessage.getUserNotAuthorized("copyFolder", userID);
            }
            return this.flashMessage.serializeMessage();
        }
        catch (UserException ue) {
            this.flashMessage = FlashMessage.getNoSuchUserExists("copyFolder", userID);
            return this.flashMessage.serializeMessage();
        }
        catch (WorkspaceFolderException we) {
            this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists("copyFolder", folderID);
        }
        return this.flashMessage.serializeMessage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isUserAuthorized(Integer folderID, Integer userID) throws UserException, WorkspaceFolderException {
        boolean authorized = false;
        User user = this.userDAO.getUserById(userID);
        if (user == null) throw new UserException();
        WorkspaceFolder targetParent = this.workspaceFolderDAO.getWorkspaceFolderByID(folderID);
        if (targetParent == null) throw new WorkspaceFolderException();
        Integer permissions = this.getPermissions(targetParent, user);
        if (permissions.equals(WorkspaceFolder.NO_ACCESS)) return authorized;
        if (permissions.equals(WorkspaceFolder.READ_ACCESS)) return authorized;
        return true;
    }

    private Hashtable createCopyFolderPacket(WorkspaceFolder workspaceFolder) {
        Hashtable<String, Integer> packet = new Hashtable<String, Integer>();
        packet.put("workspaceFolderID", workspaceFolder.getWorkspaceFolderId());
        packet.put("workspaceID", workspaceFolder.getWorkspaceID());
        return packet;
    }

    public boolean isUserOwner(WorkspaceFolder workspaceFolder, User user) {
        List folders = this.workspaceFolderDAO.getWorkspaceFolderByUser(user.getUserId());
        if (folders != null && folders.size() != 0) {
            Iterator iterator = folders.iterator();
            while (iterator.hasNext()) {
                WorkspaceFolder folder = (WorkspaceFolder)iterator.next();
                if (folder.getWorkspaceFolderId() != workspaceFolder.getWorkspaceFolderId()) continue;
                return true;
            }
        }
        return false;
    }

    public void copyRootContent(WorkspaceFolder workspaceFolder, WorkspaceFolder targetWorkspaceFolder, Integer userID) throws UserException {
        User user = this.userDAO.getUserById(userID);
        if (user == null) {
            throw new UserException("No such user with a userID of " + userID + "exists");
        }
        List designs = this.learningDesignDAO.getAllLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId());
        if (designs != null && designs.size() != 0) {
            Iterator iterator = designs.iterator();
            while (iterator.hasNext()) {
                LearningDesign design = (LearningDesign)iterator.next();
                this.authoringService.copyLearningDesign(design, new Integer(1), user, targetWorkspaceFolder);
            }
        }
    }

    public WorkspaceFolder createFolder(Integer parentFolderID, String name, Integer userID) throws UserException, WorkspaceFolderException {
        WorkspaceFolder parentFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(parentFolderID);
        User user = null;
        Workspace workspace = null;
        if (parentFolder != null) {
            boolean nameExists = true;
            while (nameExists && (nameExists = this.ifNameExists(parentFolder, name))) {
                name = name + "C";
            }
            user = this.userDAO.getUserById(userID);
            if (user != null) {
                workspace = user.getWorkspace();
                WorkspaceFolder workspaceFolder = new WorkspaceFolder(name, workspace.getWorkspaceId(), parentFolder, userID, new Date(), new Date(), WorkspaceFolder.NORMAL);
                this.workspaceFolderDAO.insert(workspaceFolder);
                return workspaceFolder;
            }
            throw new UserException("No such user with userID of " + userID + "exists");
        }
        throw new WorkspaceFolderException("No such workspaceFolder with a workspace_folder_id of " + parentFolderID + " exists");
    }

    public String createFolderForFlash(Integer parentFolderID, String name, Integer userID) throws IOException {
        try {
            WorkspaceFolder newFolder = this.createFolder(parentFolderID, name, userID);
            Hashtable<String, Object> table = new Hashtable<String, Object>();
            table.put("folderID", newFolder.getWorkspaceFolderId());
            table.put("name", newFolder.getName());
            this.flashMessage = new FlashMessage("createFolderForFlash", table);
        }
        catch (WorkspaceFolderException we) {
            this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists("createFolderForFlash", parentFolderID);
        }
        catch (UserException ue) {
            this.flashMessage = FlashMessage.getNoSuchUserExists("createFolderForFlash", userID);
        }
        return this.flashMessage.serializeMessage();
    }

    private boolean ifNameExists(WorkspaceFolder targetFolder, String folderName) {
        List folders = this.workspaceFolderDAO.getWorkspaceFolderByParentFolder(targetFolder.getWorkspaceFolderId());
        if (folders != null && folders.size() != 0) {
            Iterator iterator = folders.iterator();
            while (iterator.hasNext()) {
                WorkspaceFolder folder = (WorkspaceFolder)iterator.next();
                if (!folder.getName().equalsIgnoreCase(folderName)) continue;
                return true;
            }
        }
        return false;
    }

    public void createSubFolders(WorkspaceFolder workspaceFolder, WorkspaceFolder newFolder, Integer userID) throws UserException, WorkspaceFolderException {
        Iterator subFoldersIterator = workspaceFolder.getChildWorkspaceFolders().iterator();
        while (subFoldersIterator.hasNext()) {
            WorkspaceFolder subFolder = (WorkspaceFolder)subFoldersIterator.next();
            WorkspaceFolder newSubFolder = this.createFolder(newFolder.getWorkspaceFolderId(), subFolder.getName(), userID);
            this.copyRootContent(subFolder, newSubFolder, userID);
            if (!subFolder.hasSubFolders()) continue;
            this.createSubFolders(subFolder, newSubFolder, userID);
        }
    }

    public String deleteLearningDesign(Long learningDesignID, Integer userID) throws IOException {
        User user = this.userDAO.getUserById(userID);
        if (user != null) {
            LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignID);
            if (learningDesign != null) {
                if (learningDesign.getUser().getUserId().equals(user.getUserId())) {
                    if (learningDesign.getReadOnly().booleanValue()) {
                        this.flashMessage = new FlashMessage("deleteLearningDesign", "Cannot delete design with learning_design_id of:" + learningDesignID + " as it is READ ONLY.", 1);
                    } else {
                        List list = this.learningDesignDAO.getLearningDesignsByParent(learningDesignID);
                        if (list == null || list.size() == 0) {
                            this.learningDesignDAO.delete(learningDesign);
                        } else {
                            this.flashMessage = new FlashMessage("deleteLearningDesign", "Cannot delete design with learning_design_id of:" + learningDesignID + " as it is a PARENT.", 1);
                        }
                    }
                } else {
                    this.flashMessage = FlashMessage.getUserNotAuthorized("deleteLearningDesign", userID);
                }
            } else {
                this.flashMessage = FlashMessage.getNoSuchLearningDesignExists("deleteLearningDesign", learningDesignID);
            }
        } else {
            this.flashMessage = FlashMessage.getNoSuchUserExists("deleteLearningDesign", userID);
        }
        return this.flashMessage.serializeMessage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String moveFolder(Integer currentFolderID, Integer targetFolderID, Integer userID) throws IOException {
        try {
            if (this.isUserAuthorized(targetFolderID, userID)) {
                WorkspaceFolder currentFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(currentFolderID);
                if (currentFolder == null) throw new WorkspaceFolderException();
                WorkspaceFolder targetFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(targetFolderID);
                currentFolder.setParentWorkspaceFolder(targetFolder);
                this.workspaceFolderDAO.update(currentFolder);
                this.flashMessage = new FlashMessage("moveFolder", currentFolderID);
                return this.flashMessage.serializeMessage();
            } else {
                this.flashMessage = FlashMessage.getUserNotAuthorized("moveFolder", userID);
            }
            return this.flashMessage.serializeMessage();
        }
        catch (UserException ue) {
            this.flashMessage = FlashMessage.getNoSuchUserExists("moveFolder", userID);
            return this.flashMessage.serializeMessage();
        }
        catch (WorkspaceFolderException we) {
            this.flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists("moveFolder", targetFolderID);
        }
        return this.flashMessage.serializeMessage();
    }
}

