/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.web;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WorkspaceAction
extends DispatchAction {
    public IWorkspaceManagementService getWorkspaceManagementService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IWorkspaceManagementService)webContext.getBean("workspaceManagementService");
    }

    public ActionForward createWorkspaceFolder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer parentFolderID = new Integer(WebUtil.readIntParam(request, "parentFolderID"));
        String folderName = WebUtil.readStrParam(request, "name");
        Integer userID = new Integer(WebUtil.readIntParam(request, "userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.createFolderForFlash(parentFolderID, folderName, userID);
        request.getSession().setAttribute("details", (Object)wddxPacket);
        return mapping.findForward("success");
    }

    public ActionForward getFolderContents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer folderID = new Integer(WebUtil.readIntParam(request, "folderID"));
        Integer mode = new Integer(WebUtil.readIntParam(request, "mode"));
        Integer userID = new Integer(WebUtil.readIntParam(request, "userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.getFolderContents(userID, folderID, mode);
        request.getSession().setAttribute("details", (Object)wddxPacket);
        return mapping.findForward("success");
    }

    public ActionForward deleteWorkspacFolder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer folderID = new Integer(WebUtil.readIntParam(request, "folderID"));
        Integer userID = new Integer(WebUtil.readIntParam(request, "userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.deleteFolder(folderID, userID);
        request.getSession().setAttribute("details", (Object)wddxPacket);
        return mapping.findForward("success");
    }

    public ActionForward deleteLearningDesign(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Long learningDesignID = new Long(WebUtil.readIntParam(request, "learningDesignID"));
        Integer userID = new Integer(WebUtil.readIntParam(request, "userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.deleteLearningDesign(learningDesignID, userID);
        request.getSession().setAttribute("details", (Object)wddxPacket);
        return mapping.findForward("success");
    }

    public ActionForward copyFolder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer folderID = new Integer(WebUtil.readIntParam(request, "folderID"));
        Integer targetFolderID = new Integer(WebUtil.readIntParam(request, "targetFolderID"));
        Integer userID = new Integer(WebUtil.readIntParam(request, "userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.copyFolder(folderID, targetFolderID, userID);
        return mapping.findForward("success");
    }

    public ActionForward moveFolder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer currentFolderID = new Integer(WebUtil.readIntParam(request, "currentFolderID"));
        Integer targetFolderID = new Integer(WebUtil.readIntParam(request, "targetFolderID"));
        Integer userID = new Integer(WebUtil.readIntParam(request, "userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.moveFolder(currentFolderID, targetFolderID, userID);
        return mapping.findForward("success");
    }
}

