/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.notebook.dao.hibernate;

import java.util.List;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.tool.notebook.dao.INotebookDAO;
import org.lamsfoundation.lams.tool.notebook.model.Notebook;
import org.lamsfoundation.lams.tool.notebook.model.NotebookAttachment;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class NotebookDAO
extends BaseDAO
implements INotebookDAO {
    private static final String FIND_FORUM_BY_CONTENTID = "from Notebook notebook where notebook.toolContentId=?";
    private static final String FIND_INSTRUCTION_FILE = "from " + NotebookAttachment.class.getName() + " as i where tool_content_id=? and i.file_uuid=? and i.file_version_id=? and i.file_type=?";

    public Notebook getByContentId(Long toolContentId) {
        List list = this.getHibernateTemplate().find(FIND_FORUM_BY_CONTENTID, (Object)toolContentId);
        if (list != null && list.size() > 0) {
            return (Notebook)list.get(0);
        }
        return null;
    }

    public void saveOrUpdate(Notebook notebook) {
        this.getHibernateTemplate().saveOrUpdate((Object)notebook);
        this.getHibernateTemplate().flush();
    }

    public void deleteInstructionFile(Long toolContentId, Long uuid, Long versionId, String type) {
        List list;
        HibernateTemplate templ = this.getHibernateTemplate();
        if (toolContentId != null && uuid != null && versionId != null && (list = this.getSession().createQuery(FIND_INSTRUCTION_FILE).setLong(0, toolContentId.longValue()).setLong(1, uuid.longValue()).setLong(2, versionId.longValue()).setString(3, type).list()) != null && list.size() > 0) {
            NotebookAttachment file = (NotebookAttachment)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            templ.delete((Object)file);
            templ.flush();
        }
    }
}

