/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.notebook.dto;

import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.notebook.dto.NotebookAttachmentDTO;
import org.lamsfoundation.lams.tool.notebook.dto.NotebookSessionDTO;
import org.lamsfoundation.lams.tool.notebook.model.Notebook;
import org.lamsfoundation.lams.tool.notebook.model.NotebookAttachment;
import org.lamsfoundation.lams.tool.notebook.model.NotebookSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotebookDTO {
    private static Logger logger = Logger.getLogger(NotebookDTO.class);
    public Long toolContentId;
    public String title;
    public String instructions;
    public String onlineInstructions;
    public String offlineInstructions;
    public boolean defineLater;
    public boolean contentInUse;
    public boolean allowRichEditor;
    public boolean lockOnFinish;
    public Set<NotebookAttachmentDTO> onlineInstructionsFiles;
    public Set<NotebookAttachmentDTO> offlineInstructionsFiles;
    public Set<NotebookSessionDTO> sessionDTOs = new TreeSet<NotebookSessionDTO>();
    public Long currentTab;

    public NotebookDTO() {
    }

    public NotebookDTO(Notebook notebook) {
        this.toolContentId = notebook.getToolContentId();
        this.title = notebook.getTitle();
        this.instructions = notebook.getInstructions();
        this.onlineInstructions = notebook.getOnlineInstructions();
        this.offlineInstructions = notebook.getOfflineInstructions();
        this.contentInUse = notebook.isContentInUse();
        this.allowRichEditor = notebook.isAllowRichEditor();
        this.lockOnFinish = notebook.isLockOnFinished();
        this.onlineInstructionsFiles = new TreeSet<NotebookAttachmentDTO>();
        this.offlineInstructionsFiles = new TreeSet<NotebookAttachmentDTO>();
        for (NotebookAttachment att : notebook.getNotebookAttachments()) {
            NotebookAttachmentDTO attDTO;
            if (att.getFileType().equals("OFFLINE")) {
                attDTO = new NotebookAttachmentDTO(att);
                this.offlineInstructionsFiles.add(attDTO);
                continue;
            }
            if (att.getFileType().equals("ONLINE")) {
                attDTO = new NotebookAttachmentDTO(att);
                this.onlineInstructionsFiles.add(attDTO);
                continue;
            }
            logger.error((Object)("File with uid " + att.getFileUuid() + " contains invalid fileType: " + att.getFileType()));
        }
        for (NotebookSession session : notebook.getNotebookSessions()) {
            NotebookSessionDTO sessionDTO = new NotebookSessionDTO(session);
            this.sessionDTOs.add(sessionDTO);
        }
    }

    public Set<NotebookSessionDTO> getSessionDTOs() {
        return this.sessionDTOs;
    }

    public void setSessionDTOs(Set<NotebookSessionDTO> sessionDTOs) {
        this.sessionDTOs = sessionDTOs;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public Set<NotebookAttachmentDTO> getOfflineInstructionsFiles() {
        return this.offlineInstructionsFiles;
    }

    public void setOfflineInstructionsFiles(Set<NotebookAttachmentDTO> offlineInstructionsFiles) {
        this.offlineInstructionsFiles = offlineInstructionsFiles;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public Set<NotebookAttachmentDTO> getOnlineInstructionsFiles() {
        return this.onlineInstructionsFiles;
    }

    public void setOnlineInstructionsFiles(Set<NotebookAttachmentDTO> onlineInstructionsFiles) {
        this.onlineInstructionsFiles = onlineInstructionsFiles;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getToolContentId() {
        return this.toolContentId;
    }

    public void setToolContentId(Long toolContentID) {
        this.toolContentId = toolContentID;
    }

    public Boolean getContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(Boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isAllowRichEditor() {
        return this.allowRichEditor;
    }

    public void setAllowRichEditor(boolean allowRichEditor) {
        this.allowRichEditor = allowRichEditor;
    }

    public boolean isLockOnFinish() {
        return this.lockOnFinish;
    }

    public void setLockOnFinish(boolean lockOnFinish) {
        this.lockOnFinish = lockOnFinish;
    }

    public Long getCurrentTab() {
        return this.currentTab;
    }

    public void setCurrentTab(Long currentTab) {
        this.currentTab = currentTab;
    }
}

