/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.notebook.dto;

import java.util.Set;
import java.util.TreeSet;
import org.lamsfoundation.lams.tool.notebook.dto.NotebookUserDTO;
import org.lamsfoundation.lams.tool.notebook.model.NotebookSession;
import org.lamsfoundation.lams.tool.notebook.model.NotebookUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotebookSessionDTO
implements Comparable {
    Long sessionID;
    String sessionName;
    Set<NotebookUserDTO> userDTOs = new TreeSet<NotebookUserDTO>();
    int numberOfLearners;
    int numberOfFinishedLearners;

    public NotebookSessionDTO(NotebookSession session) {
        this.sessionID = session.getSessionId();
        this.sessionName = session.getSessionName();
        this.numberOfFinishedLearners = 0;
        for (NotebookUser user : session.getNotebookUsers()) {
            NotebookUserDTO userDTO = new NotebookUserDTO(user);
            if (userDTO.getEntryUID() != null) {
                ++this.numberOfFinishedLearners;
            }
            this.userDTOs.add(userDTO);
        }
        this.numberOfLearners = this.userDTOs.size();
    }

    public NotebookSessionDTO() {
    }

    public Long getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(Long sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public int compareTo(Object o) {
        NotebookSessionDTO toSession = (NotebookSessionDTO)o;
        int returnValue = this.sessionName.compareTo(toSession.sessionName);
        if (returnValue == 0) {
            returnValue = this.sessionID.compareTo(toSession.sessionID);
        }
        return returnValue;
    }

    public Set<NotebookUserDTO> getUserDTOs() {
        return this.userDTOs;
    }

    public void setUserDTOs(Set<NotebookUserDTO> notebookUsers) {
        this.userDTOs = notebookUsers;
    }

    public int getNumberOfLearners() {
        return this.numberOfLearners;
    }

    public void setNumberOfLearners(int numberOfLearners) {
        this.numberOfLearners = numberOfLearners;
    }

    public int getNumberOfFinishedLearners() {
        return this.numberOfFinishedLearners;
    }

    public void setNumberOfFinishedLearners(int numberOfFinishedLearners) {
        this.numberOfFinishedLearners = numberOfFinishedLearners;
    }
}

