/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.notebook.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.notebook.model.NotebookAttachment;
import org.lamsfoundation.lams.tool.notebook.service.NotebookService;

public class Notebook
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 579733009969321015L;
    static Logger log = Logger.getLogger((String)NotebookService.class.getName());
    private Long uid;
    private Date createDate;
    private Date updateDate;
    private Long createBy;
    private String title;
    private String instructions;
    private boolean runOffline;
    private boolean lockOnFinished;
    private boolean allowRichEditor;
    private String onlineInstructions;
    private String offlineInstructions;
    private boolean contentInUse;
    private boolean defineLater;
    private Long toolContentId;
    private Set notebookAttachments;
    private Set notebookSessions;
    private IToolContentHandler toolContentHandler;

    public Notebook() {
    }

    public Notebook(Date createDate, Date updateDate, Long createBy, String title, String instructions, boolean runOffline, boolean lockOnFinished, boolean filteringEnabled, String filterKeywords, String onlineInstructions, String offlineInstructions, boolean contentInUse, boolean defineLater, Long toolContentId, Set notebookAttachments, Set notebookSessions) {
        this.createDate = createDate;
        this.updateDate = updateDate;
        this.createBy = createBy;
        this.title = title;
        this.instructions = instructions;
        this.runOffline = runOffline;
        this.lockOnFinished = lockOnFinished;
        this.onlineInstructions = onlineInstructions;
        this.offlineInstructions = offlineInstructions;
        this.contentInUse = contentInUse;
        this.defineLater = defineLater;
        this.toolContentId = toolContentId;
        this.notebookAttachments = notebookAttachments;
        this.notebookSessions = notebookSessions;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public boolean isRunOffline() {
        return this.runOffline;
    }

    public void setRunOffline(boolean runOffline) {
        this.runOffline = runOffline;
    }

    public boolean isLockOnFinished() {
        return this.lockOnFinished;
    }

    public void setLockOnFinished(boolean lockOnFinished) {
        this.lockOnFinished = lockOnFinished;
    }

    public boolean isAllowRichEditor() {
        return this.allowRichEditor;
    }

    public void setAllowRichEditor(boolean allowRichEditor) {
        this.allowRichEditor = allowRichEditor;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public Long getToolContentId() {
        return this.toolContentId;
    }

    public void setToolContentId(Long toolContentId) {
        this.toolContentId = toolContentId;
    }

    public Set getNotebookAttachments() {
        return this.notebookAttachments;
    }

    public void setNotebookAttachments(Set notebookAttachments) {
        this.notebookAttachments = notebookAttachments;
    }

    public Set getNotebookSessions() {
        return this.notebookSessions;
    }

    public void setNotebookSessions(Set notebookSessions) {
        this.notebookSessions = notebookSessions;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode())).append(" [");
        buffer.append("title").append("='").append(this.getTitle()).append("' ");
        buffer.append("instructions").append("='").append(this.getInstructions()).append("' ");
        buffer.append("toolContentId").append("='").append(this.getToolContentId()).append("' ");
        buffer.append("]");
        return buffer.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Notebook)) {
            return false;
        }
        Notebook castOther = (Notebook)other;
        return this.getUid() == castOther.getUid() || this.getUid() != null && castOther.getUid() != null && this.getUid().equals(castOther.getUid());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.getUid() == null ? 0 : this.getUid().hashCode());
        return result;
    }

    public static Notebook newInstance(Notebook fromContent, Long toContentId, IToolContentHandler notebookToolContentHandler) {
        Notebook toContent = new Notebook();
        fromContent.toolContentHandler = notebookToolContentHandler;
        toContent = (Notebook)fromContent.clone();
        toContent.setToolContentId(toContentId);
        toContent.setCreateDate(new Date());
        return toContent;
    }

    protected Object clone() {
        Notebook notebook = null;
        try {
            notebook = (Notebook)super.clone();
            notebook.setUid(null);
            if (this.notebookAttachments != null) {
                Iterator iter = this.notebookAttachments.iterator();
                HashSet<NotebookAttachment> set = new HashSet<NotebookAttachment>();
                while (iter.hasNext()) {
                    NotebookAttachment originalFile = (NotebookAttachment)iter.next();
                    NotebookAttachment newFile = (NotebookAttachment)originalFile.clone();
                    set.add(newFile);
                }
                notebook.notebookAttachments = set;
            }
            notebook.notebookSessions = new HashSet();
        }
        catch (CloneNotSupportedException cnse) {
            log.error((Object)("Error cloning " + Notebook.class));
        }
        return notebook;
    }

    public IToolContentHandler getToolContentHandler() {
        return this.toolContentHandler;
    }

    public void setToolContentHandler(IToolContentHandler toolContentHandler) {
        this.toolContentHandler = toolContentHandler;
    }
}

