/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.notebook.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.RepositoryProxy;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.notebook.dao.INotebookAttachmentDAO;
import org.lamsfoundation.lams.tool.notebook.dao.INotebookDAO;
import org.lamsfoundation.lams.tool.notebook.dao.INotebookSessionDAO;
import org.lamsfoundation.lams.tool.notebook.dao.INotebookUserDAO;
import org.lamsfoundation.lams.tool.notebook.model.Notebook;
import org.lamsfoundation.lams.tool.notebook.model.NotebookAttachment;
import org.lamsfoundation.lams.tool.notebook.model.NotebookSession;
import org.lamsfoundation.lams.tool.notebook.model.NotebookUser;
import org.lamsfoundation.lams.tool.notebook.service.INotebookService;
import org.lamsfoundation.lams.tool.notebook.util.NotebookException;
import org.lamsfoundation.lams.tool.notebook.util.NotebookToolContentHandler;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotebookService
implements ToolSessionManager,
ToolContentManager,
INotebookService,
ToolContentImport102Manager {
    static Logger logger = Logger.getLogger((String)NotebookService.class.getName());
    private INotebookDAO notebookDAO = null;
    private INotebookSessionDAO notebookSessionDAO = null;
    private INotebookUserDAO notebookUserDAO = null;
    private INotebookAttachmentDAO notebookAttachmentDAO = null;
    private ILearnerService learnerService;
    private ILamsToolService toolService;
    private IToolContentHandler notebookToolContentHandler = null;
    private IRepositoryService repositoryService = null;
    private IAuditService auditService = null;
    private IExportToolContentService exportContentService;
    private ICoreNotebookService coreNotebookService;

    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) throws ToolException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("entering method createToolSession: toolSessionId = " + toolSessionId + " toolSessionName = " + toolSessionName + " toolContentId = " + toolContentId));
        }
        NotebookSession session = new NotebookSession();
        session.setSessionId(toolSessionId);
        session.setSessionName(toolSessionName);
        Notebook notebook = this.notebookDAO.getByContentId(toolContentId);
        session.setNotebook(notebook);
        this.notebookSessionDAO.saveOrUpdate(session);
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        return this.learnerService.completeToolSession(toolSessionId, learnerId);
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        return null;
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) throws DataMissingException, ToolException {
        return null;
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        this.notebookSessionDAO.deleteBySessionID(toolSessionId);
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, Long toolSessionId, Long learnerId) {
        return new TreeMap<String, ToolOutput>();
    }

    public ToolOutput getToolOutput(String name, Long toolSessionId, Long learnerId) {
        return null;
    }

    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("entering method copyToolContent: fromContentId=" + fromContentId + " toContentId=" + toContentId));
        }
        if (toContentId == null) {
            String error = "Failed to copy tool content: toContentID is null";
            throw new ToolException(error);
        }
        Notebook fromContent = null;
        if (fromContentId != null) {
            fromContent = this.notebookDAO.getByContentId(fromContentId);
        }
        if (fromContent == null) {
            fromContent = this.getDefaultContent();
        }
        Notebook toContent = Notebook.newInstance(fromContent, toContentId, this.notebookToolContentHandler);
        this.notebookDAO.saveOrUpdate(toContent);
    }

    public void setAsDefineLater(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Notebook notebook = this.notebookDAO.getByContentId(toolContentId);
        if (notebook == null) {
            throw new ToolException("Could not find tool with toolContentID: " + toolContentId);
        }
        notebook.setDefineLater(value);
        this.notebookDAO.saveOrUpdate(notebook);
    }

    public void setAsRunOffline(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Notebook notebook = this.notebookDAO.getByContentId(toolContentId);
        if (notebook == null) {
            throw new ToolException("Could not find tool with toolContentID: " + toolContentId);
        }
        notebook.setRunOffline(value);
        this.notebookDAO.saveOrUpdate(notebook);
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException, ToolException {
    }

    public void exportToolContent(Long toolContentId, String rootPath) throws DataMissingException, ToolException {
        Notebook notebook = this.notebookDAO.getByContentId(toolContentId);
        if (notebook == null) {
            notebook = this.getDefaultContent();
        }
        if (notebook == null) {
            throw new DataMissingException("Unable to find default content for the notebook tool");
        }
        notebook = Notebook.newInstance(notebook, toolContentId, null);
        notebook.setToolContentHandler(null);
        notebook.setNotebookSessions(null);
        Set atts = notebook.getNotebookAttachments();
        for (NotebookAttachment att : atts) {
            att.setNotebook(null);
        }
        try {
            this.exportContentService.registerFileClassForExport(NotebookAttachment.class.getName(), "fileUuid", "fileVersionId");
            this.exportContentService.exportToolContent(toolContentId, (Object)notebook, this.notebookToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(NotebookAttachment.class.getName(), "fileUuid", "fileVersionId", "fileName", "fileType", null, null);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, this.notebookToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof Notebook)) {
                throw new ImportToolContentException("Import Notebook tool content failed. Deserialized object is " + toolPOJO);
            }
            Notebook notebook = (Notebook)toolPOJO;
            notebook.setToolContentId(toolContentId);
            notebook.setCreateBy(new Long(newUserUid.longValue()));
            this.notebookDAO.saveOrUpdate(notebook);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Long toolContentId) throws ToolException {
        return new TreeMap<String, ToolOutputDefinition>();
    }

    @Override
    public Long createNotebookEntry(Long id, Integer idType, String signature, Integer userID, String entry) {
        return this.coreNotebookService.createNotebookEntry(id, idType, signature, userID, "", entry);
    }

    @Override
    public NotebookEntry getEntry(Long uid) {
        return this.coreNotebookService.getEntry(uid);
    }

    @Override
    public void updateEntry(Long uid, String entry) {
        this.coreNotebookService.updateEntry(uid, "", entry);
    }

    @Override
    public Long getDefaultContentIdBySignature(String toolSignature) {
        Long toolContentId = null;
        toolContentId = new Long(this.toolService.getToolDefaultContentIdBySignature(toolSignature));
        if (toolContentId == null) {
            String error = "Could not retrieve default content id for this tool";
            logger.error((Object)error);
            throw new NotebookException(error);
        }
        return toolContentId;
    }

    @Override
    public Notebook getDefaultContent() {
        Long defaultContentID = this.getDefaultContentIdBySignature("lantbk11");
        Notebook defaultContent = this.getNotebookByContentId(defaultContentID);
        if (defaultContent == null) {
            String error = "Could not retrieve default content record for this tool";
            logger.error((Object)error);
            throw new NotebookException(error);
        }
        return defaultContent;
    }

    @Override
    public Notebook copyDefaultContent(Long newContentID) {
        if (newContentID == null) {
            String error = "Cannot copy the Notebook tools default content: + newContentID is null";
            logger.error((Object)error);
            throw new NotebookException(error);
        }
        Notebook defaultContent = this.getDefaultContent();
        Notebook newContent = new Notebook();
        newContent = Notebook.newInstance(defaultContent, newContentID, this.notebookToolContentHandler);
        this.notebookDAO.saveOrUpdate(newContent);
        return newContent;
    }

    @Override
    public Notebook getNotebookByContentId(Long toolContentID) {
        Notebook notebook = this.notebookDAO.getByContentId(toolContentID);
        if (notebook == null) {
            logger.debug((Object)("Could not find the content with toolContentID:" + toolContentID));
        }
        return notebook;
    }

    @Override
    public NotebookSession getSessionBySessionId(Long toolSessionId) {
        NotebookSession notebookSession = this.notebookSessionDAO.getBySessionId(toolSessionId);
        if (notebookSession == null) {
            logger.debug((Object)("Could not find the notebook session with toolSessionID:" + toolSessionId));
        }
        return notebookSession;
    }

    @Override
    public NotebookUser getUserByUserIdAndSessionId(Long userId, Long toolSessionId) {
        return this.notebookUserDAO.getByUserIdAndSessionId(userId, toolSessionId);
    }

    public NotebookUser getUserByLoginNameAndSessionId(String loginName, Long toolSessionId) {
        return this.notebookUserDAO.getByLoginNameAndSessionId(loginName, toolSessionId);
    }

    @Override
    public NotebookUser getUserByUID(Long uid) {
        return this.notebookUserDAO.getByUID(uid);
    }

    @Override
    public NotebookAttachment uploadFileToContent(Long toolContentId, FormFile file, String type) {
        if (file == null || StringUtils.isEmpty((String)file.getFileName())) {
            throw new NotebookException("Could not find upload file: " + file);
        }
        NodeKey nodeKey = this.processFile(file, type);
        NotebookAttachment attachment = new NotebookAttachment(nodeKey.getVersion(), type, file.getFileName(), nodeKey.getUuid(), new Date());
        return attachment;
    }

    @Override
    public void deleteFromRepository(Long uuid, Long versionID) throws NotebookException {
        ITicket ticket = this.getRepositoryLoginTicket();
        try {
            this.repositoryService.deleteVersion(ticket, uuid, versionID);
        }
        catch (Exception e) {
            throw new NotebookException("Exception occured while deleting files from the repository " + e.getMessage());
        }
    }

    @Override
    public void deleteInstructionFile(Long contentID, Long uuid, Long versionID, String type) {
        this.notebookDAO.deleteInstructionFile(contentID, uuid, versionID, type);
    }

    @Override
    public void saveOrUpdateNotebook(Notebook notebook) {
        this.notebookDAO.saveOrUpdate(notebook);
    }

    @Override
    public void saveOrUpdateNotebookSession(NotebookSession notebookSession) {
        this.notebookSessionDAO.saveOrUpdate(notebookSession);
    }

    @Override
    public void saveOrUpdateNotebookUser(NotebookUser notebookUser) {
        this.notebookUserDAO.saveOrUpdate(notebookUser);
    }

    @Override
    public NotebookUser createNotebookUser(UserDTO user, NotebookSession notebookSession) {
        NotebookUser notebookUser = new NotebookUser(user, notebookSession);
        this.saveOrUpdateNotebookUser(notebookUser);
        return notebookUser;
    }

    public IAuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }

    private NodeKey processFile(FormFile file, String type) {
        NodeKey node = null;
        if (file != null && !StringUtils.isEmpty((String)file.getFileName())) {
            String fileName = file.getFileName();
            try {
                node = this.getNotebookToolContentHandler().uploadFile(file.getInputStream(), fileName, file.getContentType(), type);
            }
            catch (InvalidParameterException e) {
                throw new NotebookException("InvalidParameterException occured while trying to upload File" + e.getMessage());
            }
            catch (FileNotFoundException e) {
                throw new NotebookException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
            catch (RepositoryCheckedException e) {
                throw new NotebookException("RepositoryCheckedException occured while trying to upload File" + e.getMessage());
            }
            catch (IOException e) {
                throw new NotebookException("IOException occured while trying to upload File" + e.getMessage());
            }
        }
        return node;
    }

    private ITicket getRepositoryLoginTicket() throws NotebookException {
        this.repositoryService = RepositoryProxy.getRepositoryService();
        SimpleCredentials credentials = new SimpleCredentials(NotebookToolContentHandler.repositoryUser, NotebookToolContentHandler.repositoryId);
        try {
            ITicket ticket = this.repositoryService.login((ICredentials)credentials, NotebookToolContentHandler.repositoryWorkspaceName);
            return ticket;
        }
        catch (AccessDeniedException ae) {
            throw new NotebookException("Access Denied to repository." + ae.getMessage());
        }
        catch (WorkspaceNotFoundException we) {
            throw new NotebookException("Workspace not found." + we.getMessage());
        }
        catch (LoginException e) {
            throw new NotebookException("Login failed." + e.getMessage());
        }
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        Date now = new Date();
        Notebook notebook = new Notebook();
        notebook.setContentInUse(Boolean.FALSE);
        notebook.setCreateBy(new Long(user.getUserID().longValue()));
        notebook.setCreateDate(now);
        notebook.setDefineLater(Boolean.FALSE);
        notebook.setInstructions(WebUtil.convertNewlines((String)((String)importValues.get("body"))));
        notebook.setLockOnFinished(Boolean.TRUE);
        notebook.setOfflineInstructions(null);
        notebook.setOnlineInstructions(null);
        notebook.setRunOffline(Boolean.FALSE);
        notebook.setTitle((String)importValues.get("title"));
        notebook.setToolContentId(toolContentId);
        notebook.setUpdateDate(now);
        notebook.setAllowRichEditor(Boolean.FALSE);
        this.notebookDAO.saveOrUpdate(notebook);
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        logger.warn((Object)"Setting the reflective field on a notebook. This doesn't make sense as the notebook is for reflection and we don't reflect on reflection!");
        Notebook notebook = this.getNotebookByContentId(toolContentId);
        if (notebook == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        notebook.setInstructions(description);
    }

    public INotebookAttachmentDAO getNotebookAttachmentDAO() {
        return this.notebookAttachmentDAO;
    }

    public void setNotebookAttachmentDAO(INotebookAttachmentDAO attachmentDAO) {
        this.notebookAttachmentDAO = attachmentDAO;
    }

    public INotebookDAO getNotebookDAO() {
        return this.notebookDAO;
    }

    public void setNotebookDAO(INotebookDAO notebookDAO) {
        this.notebookDAO = notebookDAO;
    }

    public IToolContentHandler getNotebookToolContentHandler() {
        return this.notebookToolContentHandler;
    }

    public void setNotebookToolContentHandler(IToolContentHandler notebookToolContentHandler) {
        this.notebookToolContentHandler = notebookToolContentHandler;
    }

    public INotebookSessionDAO getNotebookSessionDAO() {
        return this.notebookSessionDAO;
    }

    public void setNotebookSessionDAO(INotebookSessionDAO sessionDAO) {
        this.notebookSessionDAO = sessionDAO;
    }

    public ILamsToolService getToolService() {
        return this.toolService;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public INotebookUserDAO getNotebookUserDAO() {
        return this.notebookUserDAO;
    }

    public void setNotebookUserDAO(INotebookUserDAO userDAO) {
        this.notebookUserDAO = userDAO;
    }

    public ILearnerService getLearnerService() {
        return this.learnerService;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }
}

