/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.notebook.web.actions;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.notebook.dto.NotebookDTO;
import org.lamsfoundation.lams.tool.notebook.model.Notebook;
import org.lamsfoundation.lams.tool.notebook.model.NotebookSession;
import org.lamsfoundation.lams.tool.notebook.model.NotebookUser;
import org.lamsfoundation.lams.tool.notebook.service.INotebookService;
import org.lamsfoundation.lams.tool.notebook.service.NotebookServiceProxy;
import org.lamsfoundation.lams.tool.notebook.util.NotebookException;
import org.lamsfoundation.lams.tool.notebook.web.forms.LearningForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class LearningAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(LearningAction.class);
    private static final boolean MODE_OPTIONAL = false;
    private INotebookService notebookService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NotebookUser notebookUser;
        NotebookSession notebookSession;
        LearningForm learningForm = (LearningForm)form;
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)false);
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        if (this.notebookService == null) {
            this.notebookService = NotebookServiceProxy.getNotebookService(this.getServlet().getServletContext());
        }
        if ((notebookSession = this.notebookService.getSessionBySessionId(toolSessionID)) == null) {
            throw new NotebookException("Cannot retreive session with toolSessionID" + toolSessionID);
        }
        Notebook notebook = notebookSession.getNotebook();
        if (notebook.isDefineLater()) {
            return mapping.findForward("defineLater");
        }
        request.setAttribute("mode", (Object)mode.toString());
        learningForm.setToolSessionID(toolSessionID);
        NotebookDTO notebookDTO = new NotebookDTO();
        notebookDTO.title = notebook.getTitle();
        notebookDTO.instructions = notebook.getInstructions();
        notebookDTO.allowRichEditor = notebook.isAllowRichEditor();
        notebookDTO.lockOnFinish = notebook.isLockOnFinished();
        request.setAttribute("notebookDTO", (Object)notebookDTO);
        if (!notebook.isContentInUse()) {
            notebook.setContentInUse(new Boolean(true));
            this.notebookService.saveOrUpdateNotebook(notebook);
        }
        if (notebook.isRunOffline()) {
            return mapping.findForward("runOffline");
        }
        if (mode.equals((Object)ToolAccessMode.TEACHER)) {
            Long userID = WebUtil.readLongParam((HttpServletRequest)request, (String)"userID", (boolean)false);
            notebookUser = this.notebookService.getUserByUserIdAndSessionId(userID, toolSessionID);
        } else {
            notebookUser = this.getCurrentUser(toolSessionID);
        }
        NotebookEntry nbEntry = null;
        if (notebookUser != null) {
            nbEntry = this.notebookService.getEntry(notebookUser.getEntryUID());
        }
        if (nbEntry != null) {
            learningForm.setEntryText(nbEntry.getEntry());
        }
        if (mode.equals((Object)ToolAccessMode.TEACHER) || notebook.isLockOnFinished() && notebookUser.isFinishedActivity()) {
            request.setAttribute("contentEditable", (Object)false);
        } else {
            request.setAttribute("contentEditable", (Object)true);
        }
        request.setAttribute("finishedActivity", (Object)notebookUser.isFinishedActivity());
        return mapping.findForward("notebook");
    }

    private NotebookUser getCurrentUser(Long toolSessionId) {
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        NotebookUser notebookUser = this.notebookService.getUserByUserIdAndSessionId(new Long(user.getUserID().intValue()), toolSessionId);
        if (notebookUser == null) {
            NotebookSession notebookSession = this.notebookService.getSessionBySessionId(toolSessionId);
            notebookUser = this.notebookService.createNotebookUser(user, notebookSession);
        }
        return notebookUser;
    }

    public ActionForward finishActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        NotebookUser notebookUser = this.getCurrentUser(toolSessionID);
        if (notebookUser != null) {
            LearningForm learningForm = (LearningForm)form;
            if (notebookUser.getEntryUID() == null) {
                notebookUser.setEntryUID(this.notebookService.createNotebookEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lantbk11", notebookUser.getUserId().intValue(), learningForm.getEntryText()));
            } else {
                this.notebookService.updateEntry(notebookUser.getEntryUID(), learningForm.getEntryText());
            }
            notebookUser.setFinishedActivity(true);
            this.notebookService.saveOrUpdateNotebookUser(notebookUser);
        } else {
            log.error((Object)("finishActivity(): couldn't find NotebookUser with id: " + notebookUser.getUserId() + "and toolSessionID: " + toolSessionID));
        }
        ToolSessionManager sessionMgrService = NotebookServiceProxy.getNotebookSessionManager(this.getServlet().getServletContext());
        try {
            String nextActivityUrl = sessionMgrService.leaveToolSession(toolSessionID, notebookUser.getUserId());
            response.sendRedirect(nextActivityUrl);
        }
        catch (DataMissingException e) {
            throw new NotebookException(e);
        }
        catch (ToolException e) {
            throw new NotebookException(e);
        }
        catch (IOException e) {
            throw new NotebookException(e);
        }
        return null;
    }
}

