/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.notebook.web.servlets;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.notebook.dto.NotebookDTO;
import org.lamsfoundation.lams.tool.notebook.dto.NotebookEntryDTO;
import org.lamsfoundation.lams.tool.notebook.dto.NotebookSessionDTO;
import org.lamsfoundation.lams.tool.notebook.dto.NotebookUserDTO;
import org.lamsfoundation.lams.tool.notebook.model.Notebook;
import org.lamsfoundation.lams.tool.notebook.model.NotebookSession;
import org.lamsfoundation.lams.tool.notebook.model.NotebookUser;
import org.lamsfoundation.lams.tool.notebook.service.INotebookService;
import org.lamsfoundation.lams.tool.notebook.service.NotebookServiceProxy;
import org.lamsfoundation.lams.tool.notebook.util.NotebookException;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;
import org.lamsfoundation.lams.web.session.SessionManager;

public class ExportServlet
extends AbstractExportPortfolioServlet {
    private static final long serialVersionUID = -2829707715037631881L;
    private static Logger logger = Logger.getLogger(ExportServlet.class);
    private final String FILENAME = "notebook_main.html";
    private INotebookService notebookService;

    protected String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.notebookService == null) {
            this.notebookService = NotebookServiceProxy.getNotebookService(this.getServletContext());
        }
        try {
            if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.LEARNER.toString())) {
                request.getSession().setAttribute("mode", (Object)ToolAccessMode.LEARNER);
                this.doLearnerExport(request, response, directoryName, cookies);
            } else if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.TEACHER.toString())) {
                request.getSession().setAttribute("mode", (Object)ToolAccessMode.TEACHER);
                this.doTeacherExport(request, response, directoryName, cookies);
            }
        }
        catch (NotebookException e) {
            logger.error((Object)"Cannot perform export for notebook tool.");
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        this.writeResponseToFile(basePath + "/pages/export/exportPortfolio.jsp", directoryName, "notebook_main.html", cookies);
        return "notebook_main.html";
    }

    protected String doOfflineExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.toolContentID == null && this.toolSessionID == null) {
            logger.error((Object)"Tool content Id or and session Id are null. Unable to activity title");
        } else {
            if (this.notebookService == null) {
                this.notebookService = NotebookServiceProxy.getNotebookService(this.getServletContext());
            }
            Notebook content = null;
            if (this.toolContentID != null) {
                content = this.notebookService.getNotebookByContentId(this.toolContentID);
            } else {
                NotebookSession session = this.notebookService.getSessionBySessionId(this.toolSessionID);
                if (session != null) {
                    content = session.getNotebook();
                }
            }
            if (content != null) {
                this.activityTitle = content.getTitle();
            }
        }
        return super.doOfflineExport(request, response, directoryName, cookies);
    }

    private void doLearnerExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) throws NotebookException {
        logger.debug((Object)("doExportLearner: toolContentID:" + this.toolSessionID));
        if (this.toolSessionID == null) {
            String error = "Tool Session ID is missing. Unable to continue";
            logger.error((Object)error);
            throw new NotebookException(error);
        }
        NotebookSession notebookSession = this.notebookService.getSessionBySessionId(this.toolSessionID);
        Notebook notebook = notebookSession.getNotebook();
        UserDTO lamsUserDTO = (UserDTO)SessionManager.getSession().getAttribute("user");
        NotebookUser notebookUser = this.notebookService.getUserByUserIdAndSessionId(new Long(lamsUserDTO.getUserID().intValue()), this.toolSessionID);
        NotebookEntry notebookEntry = this.notebookService.getEntry(notebookUser.getEntryUID());
        NotebookDTO notebookDTO = new NotebookDTO();
        notebookDTO.setTitle(notebook.getTitle());
        notebookDTO.setInstructions(notebook.getInstructions());
        NotebookSessionDTO sessionDTO = new NotebookSessionDTO();
        sessionDTO.setSessionName(notebookSession.getSessionName());
        sessionDTO.setSessionID(notebookSession.getSessionId());
        NotebookUserDTO userDTO = notebookEntry != null ? new NotebookUserDTO(notebookUser, notebookEntry) : new NotebookUserDTO(notebookUser);
        sessionDTO.getUserDTOs().add(userDTO);
        notebookDTO.getSessionDTOs().add(sessionDTO);
        request.getSession().setAttribute("notebookDTO", (Object)notebookDTO);
    }

    private void doTeacherExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) throws NotebookException {
        logger.debug((Object)("doExportTeacher: toolContentID:" + this.toolContentID));
        if (this.toolContentID == null) {
            String error = "Tool Content ID is missing. Unable to continue";
            logger.error((Object)error);
            throw new NotebookException(error);
        }
        Notebook notebook = this.notebookService.getNotebookByContentId(this.toolContentID);
        NotebookDTO notebookDTO = new NotebookDTO(notebook);
        for (NotebookSessionDTO session : notebookDTO.getSessionDTOs()) {
            for (NotebookUserDTO user : session.getUserDTOs()) {
                NotebookEntry entry = this.notebookService.getEntry(user.getEntryUID());
                if (entry == null) continue;
                NotebookEntryDTO entryDTO = new NotebookEntryDTO(entry);
                user.setEntryDTO(entryDTO);
            }
        }
        request.getSession().setAttribute("notebookDTO", (Object)notebookDTO);
    }
}

