/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.dto;

import java.util.ArrayList;
import java.util.List;
import org.lamsfoundation.lams.tool.forum.persistence.ForumReport;
import org.lamsfoundation.lams.tool.forum.persistence.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDTO {
    private Message message;
    private String author;
    private boolean hasAttachment;
    private short level;
    private int threadNum;
    private boolean isAuthor;
    private Float mark;
    private String comment;
    private boolean released;
    private int numOfPosts;
    private String attachmentName;
    private String attachmentLocalUrl;

    public static MessageDTO getMessageDTO(Message msg) {
        if (msg == null) {
            return null;
        }
        MessageDTO dto = new MessageDTO();
        dto.setMessage(msg);
        if (msg.getCreatedBy() != null) {
            dto.setAuthor(msg.getCreatedBy().getFirstName() + " " + msg.getCreatedBy().getLastName());
        }
        if (msg.getAttachments() == null || msg.getAttachments().isEmpty()) {
            dto.setHasAttachment(false);
        } else {
            dto.setHasAttachment(true);
        }
        ForumReport report = msg.getReport();
        if (report != null && report.getMark() != null) {
            dto.mark = report.getMark();
            dto.comment = report.getComment();
            dto.released = report.getDateMarksReleased() != null;
        }
        return dto;
    }

    public static List<MessageDTO> getMessageDTO(List msgList) {
        ArrayList<MessageDTO> retSet = new ArrayList<MessageDTO>();
        if (msgList == null || msgList.isEmpty()) {
            return retSet;
        }
        for (Message msg : msgList) {
            MessageDTO msgDto = new MessageDTO();
            msgDto.setMessage(msg);
            if (msg.getCreatedBy() != null) {
                msgDto.setAuthor(msg.getCreatedBy().getFirstName() + " " + msg.getCreatedBy().getLastName());
            }
            if (msg.getAttachments() == null || msg.getAttachments().isEmpty()) {
                msgDto.setHasAttachment(false);
            } else {
                msgDto.setHasAttachment(true);
            }
            ForumReport report = msg.getReport();
            if (report != null && report.getMark() != null) {
                msgDto.mark = report.getMark();
                msgDto.comment = report.getComment();
                msgDto.released = report.getDateMarksReleased() != null;
            }
            retSet.add(msgDto);
        }
        return retSet;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public boolean getHasAttachment() {
        return this.hasAttachment;
    }

    public void setHasAttachment(boolean isAttachment) {
        this.hasAttachment = isAttachment;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public short getLevel() {
        return this.level;
    }

    public void setLevel(short level) {
        this.level = level;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public boolean getIsAuthor() {
        return this.isAuthor;
    }

    public void setAuthor(boolean isAuthor) {
        this.isAuthor = isAuthor;
    }

    public Float getMark() {
        return this.mark;
    }

    public void setMark(Float mark) {
        this.mark = mark;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isReleased() {
        return this.released;
    }

    public void setReleased(boolean isReleased) {
        this.released = isReleased;
    }

    public String getAttachmentLocalUrl() {
        return this.attachmentLocalUrl;
    }

    public void setAttachmentLocalUrl(String attachmentLocalUrl) {
        this.attachmentLocalUrl = attachmentLocalUrl;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public int getNumOfPosts() {
        return this.numOfPosts;
    }

    public void setNumOfPosts(int numOfPosts) {
        this.numOfPosts = numOfPosts;
    }
}

