/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.persistence;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.forum.persistence.Attachment;
import org.lamsfoundation.lams.tool.forum.persistence.ForumUser;
import org.lamsfoundation.lams.tool.forum.persistence.Message;
import org.lamsfoundation.lams.tool.forum.util.ForumToolContentHandler;

public class Forum
implements Cloneable {
    private static final Logger log = Logger.getLogger(Forum.class);
    private Long uid;
    private Long contentId;
    private String title;
    private boolean lockWhenFinished;
    private boolean runOffline;
    private boolean allowAnonym;
    private boolean allowEdit;
    private boolean allowNewTopic;
    private boolean allowUpload;
    private int maximumReply;
    private int minimumReply;
    private boolean allowRichEditor;
    private String instructions;
    private String onlineInstructions;
    private String offlineInstructions;
    private boolean defineLater;
    private boolean contentInUse;
    private Date created;
    private Date updated;
    private ForumUser createdBy;
    private Set messages;
    private Set attachments = new HashSet();
    private int limitedChar;
    private boolean limitedInput;
    private boolean reflectOnActivity;
    private String reflectInstructions;
    private ForumToolContentHandler toolContentHandler;

    public Forum() {
        this.messages = new HashSet();
    }

    public Object clone() {
        Forum forum = null;
        try {
            HashSet<Cloneable> set;
            Iterator iter;
            forum = (Forum)super.clone();
            forum.setUid(null);
            if (this.messages != null) {
                iter = this.messages.iterator();
                set = new HashSet<Cloneable>();
                while (iter.hasNext()) {
                    set.add(Message.newInstance((Message)iter.next(), this.toolContentHandler));
                }
                forum.messages = set;
            }
            if (this.attachments != null) {
                iter = this.attachments.iterator();
                set = new HashSet();
                while (iter.hasNext()) {
                    Attachment file = (Attachment)iter.next();
                    Attachment newFile = (Attachment)file.clone();
                    set.add(newFile);
                }
                forum.attachments = set;
            }
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("When clone " + Forum.class + " failed"));
        }
        return forum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Forum)) {
            return false;
        }
        Forum genericEntity = (Forum)o;
        return new EqualsBuilder().append((Object)this.uid, (Object)genericEntity.uid).append((Object)this.title, (Object)genericEntity.title).append((Object)this.instructions, (Object)genericEntity.instructions).append((Object)this.onlineInstructions, (Object)genericEntity.onlineInstructions).append((Object)this.offlineInstructions, (Object)genericEntity.offlineInstructions).append((Object)this.created, (Object)genericEntity.created).append((Object)this.updated, (Object)genericEntity.updated).append((Object)this.createdBy, (Object)genericEntity.createdBy).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uid).append((Object)this.title).append((Object)this.instructions).append((Object)this.onlineInstructions).append((Object)this.offlineInstructions).append((Object)this.created).append((Object)this.updated).append((Object)this.createdBy).toHashCode();
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public ForumUser getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(ForumUser createdBy) {
        this.createdBy = createdBy;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean getAllowAnonym() {
        return this.allowAnonym;
    }

    public void setAllowAnonym(boolean allowAnnomity) {
        this.allowAnonym = allowAnnomity;
    }

    public boolean getRunOffline() {
        return this.runOffline;
    }

    public void setRunOffline(boolean forceOffline) {
        this.runOffline = forceOffline;
    }

    public boolean getLockWhenFinished() {
        return this.lockWhenFinished;
    }

    public void setLockWhenFinished(boolean lockWhenFinished) {
        this.lockWhenFinished = lockWhenFinished;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public Set getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Set attachments) {
        this.attachments = attachments;
    }

    public Set getMessages() {
        return this.messages;
    }

    public void setMessages(Set messages) {
        this.messages = messages;
    }

    public void updateModificationData() {
        long now = System.currentTimeMillis();
        if (this.created == null) {
            this.setCreated(new Date(now));
        }
        this.setUpdated(new Date(now));
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public Long getContentId() {
        return this.contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public boolean isAllowEdit() {
        return this.allowEdit;
    }

    public void setAllowEdit(boolean allowEdit) {
        this.allowEdit = allowEdit;
    }

    public boolean isAllowRichEditor() {
        return this.allowRichEditor;
    }

    public void setAllowRichEditor(boolean allowRichEditor) {
        this.allowRichEditor = allowRichEditor;
    }

    public static Forum newInstance(Forum fromContent, Long contentId, ForumToolContentHandler forumToolContentHandler) {
        Forum toContent = new Forum();
        fromContent.toolContentHandler = forumToolContentHandler;
        toContent = (Forum)fromContent.clone();
        toContent.setContentId(contentId);
        return toContent;
    }

    public int getLimitedChar() {
        return this.limitedChar;
    }

    public void setLimitedChar(int limitedChar) {
        this.limitedChar = limitedChar;
    }

    public boolean isLimitedInput() {
        return this.limitedInput;
    }

    public void setLimitedInput(boolean limitedInput) {
        this.limitedInput = limitedInput;
    }

    public ForumToolContentHandler getToolContentHandler() {
        return this.toolContentHandler;
    }

    public void setToolContentHandler(ForumToolContentHandler toolContentHandler) {
        this.toolContentHandler = toolContentHandler;
    }

    public boolean isAllowNewTopic() {
        return this.allowNewTopic;
    }

    public void setAllowNewTopic(boolean allowNewTopic) {
        this.allowNewTopic = allowNewTopic;
    }

    public boolean isAllowUpload() {
        return this.allowUpload;
    }

    public void setAllowUpload(boolean allowUpload) {
        this.allowUpload = allowUpload;
    }

    public int getMaximumReply() {
        return this.maximumReply;
    }

    public void setMaximumReply(int maximumReply) {
        this.maximumReply = maximumReply;
    }

    public int getMinimumReply() {
        return this.minimumReply;
    }

    public void setMinimumReply(int minimumReply) {
        this.minimumReply = minimumReply;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }
}

