/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.persistence;

import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.forum.persistence.ForumToolSession;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;

public class ForumUser
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7043502180037866257L;
    private static Logger log = Logger.getLogger(ForumUser.class);
    private Long uid;
    private Long userId;
    private String firstName;
    private String lastName;
    private String loginName;
    private boolean sessionFinished;
    private ForumToolSession session;

    public ForumUser() {
    }

    public ForumUser(UserDTO user, ForumToolSession session) {
        this.userId = new Long(user.getUserID().intValue());
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.loginName = user.getLogin();
        this.session = session;
        this.sessionFinished = false;
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("When clone " + ForumUser.class + " failed"));
        }
        return obj;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long userID) {
        this.uid = userID;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userID) {
        this.userId = userID;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public ForumToolSession getSession() {
        return this.session;
    }

    public void setSession(ForumToolSession session) {
        this.session = session;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public boolean isSessionFinished() {
        return this.sessionFinished;
    }

    public void setSessionFinished(boolean sessionFinished) {
        this.sessionFinished = sessionFinished;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ForumUser)) {
            return false;
        }
        ForumUser user = (ForumUser)obj;
        return new EqualsBuilder().append((Object)this.uid, (Object)user.uid).append((Object)this.firstName, (Object)user.firstName).append((Object)this.lastName, (Object)user.lastName).append((Object)this.loginName, (Object)user.loginName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uid).append((Object)this.firstName).append((Object)this.lastName).append((Object)this.loginName).toHashCode();
    }
}

