/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.persistence;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.forum.persistence.Attachment;
import org.lamsfoundation.lams.tool.forum.persistence.Forum;
import org.lamsfoundation.lams.tool.forum.persistence.ForumReport;
import org.lamsfoundation.lams.tool.forum.persistence.ForumToolSession;
import org.lamsfoundation.lams.tool.forum.persistence.ForumUser;
import org.lamsfoundation.lams.tool.forum.util.ForumToolContentHandler;

public class Message
implements Cloneable {
    private static Logger log = Logger.getLogger(Message.class);
    private Long uid;
    private String subject;
    private String body;
    private boolean isAuthored;
    private boolean isAnonymous;
    private Date created;
    private Date updated;
    private Date lastReplyDate;
    private int replyNumber;
    private boolean hideFlag;
    private Message parent;
    private ForumToolSession toolSession;
    private Forum forum;
    private ForumUser createdBy;
    private ForumUser modifiedBy;
    private Set attachments = new TreeSet();
    private ForumReport report;
    private Set sessionClones = new HashSet();
    private ForumToolContentHandler toolContentHandler;

    public static Message newInstance(Message fromMsg, ForumToolContentHandler toolContentHandler) {
        Message toMsg = new Message();
        fromMsg.toolContentHandler = toolContentHandler;
        toMsg = (Message)fromMsg.clone();
        return toMsg;
    }

    public Object clone() {
        Message msg = null;
        try {
            msg = (Message)super.clone();
            msg.setUid(null);
            if (this.attachments != null) {
                Iterator iter = this.attachments.iterator();
                TreeSet<Attachment> set = new TreeSet<Attachment>();
                while (iter.hasNext()) {
                    Attachment file = (Attachment)iter.next();
                    Attachment newFile = (Attachment)file.clone();
                    set.add(newFile);
                }
                msg.attachments = set;
            }
            msg.sessionClones = new HashSet();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("When clone " + Forum.class + " failed"));
        }
        return msg;
    }

    public Object updateClone(Message clone) {
        clone.setBody(this.getBody());
        clone.setForum(this.getForum());
        clone.setHideFlag(this.isHideFlag());
        clone.setIsAnonymous(this.isAnonymous);
        clone.setIsAuthored(this.getIsAuthored());
        clone.setLastReplyDate(this.getLastReplyDate());
        clone.setModifiedBy(clone.getModifiedBy());
        clone.setReplyNumber(this.getReplyNumber());
        clone.setReport(this.getReport());
        clone.setSubject(this.getSubject());
        clone.setToolContentHandler(this.getToolContentHandler());
        clone.setUpdated(clone.getUpdated());
        clone.getAttachments().clear();
        if (this.attachments != null) {
            for (Attachment file : this.attachments) {
                Attachment newFile = (Attachment)file.clone();
                clone.getAttachments().add(newFile);
            }
        }
        return clone;
    }

    public void updateModificationData() {
        long now = System.currentTimeMillis();
        if (this.created == null) {
            this.setCreated(new Date(now));
        }
        this.setUpdated(new Date(now));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message genericEntity = (Message)o;
        return new EqualsBuilder().append((Object)this.uid, (Object)genericEntity.uid).append((Object)this.subject, (Object)genericEntity.subject).append((Object)this.body, (Object)genericEntity.body).append(this.replyNumber, genericEntity.replyNumber).append((Object)this.lastReplyDate, (Object)genericEntity.lastReplyDate).append((Object)this.created, (Object)genericEntity.created).append((Object)this.updated, (Object)genericEntity.updated).append((Object)this.createdBy, (Object)genericEntity.createdBy).append((Object)this.modifiedBy, (Object)genericEntity.modifiedBy).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uid).append((Object)this.subject).append((Object)this.body).append((Object)this.created).append((Object)this.updated).append((Object)this.createdBy).append((Object)this.modifiedBy).toHashCode();
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getLastReplyDate() {
        return this.lastReplyDate;
    }

    public void setLastReplyDate(Date lastPostDate) {
        this.lastReplyDate = lastPostDate;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public ForumUser getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(ForumUser createdBy) {
        this.createdBy = createdBy;
    }

    public ForumUser getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(ForumUser modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uuid) {
        this.uid = uuid;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean getIsAuthored() {
        return this.isAuthored;
    }

    public void setIsAuthored(boolean isAuthored) {
        this.isAuthored = isAuthored;
    }

    public boolean getIsAnonymous() {
        return this.isAnonymous;
    }

    public void setIsAnonymous(boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public ForumToolSession getToolSession() {
        return this.toolSession;
    }

    public void setToolSession(ForumToolSession session) {
        this.toolSession = session;
    }

    public void setParent(Message parent) {
        this.parent = parent;
    }

    public Message getParent() {
        return this.parent;
    }

    public Set getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Set attachments) {
        this.attachments = attachments;
    }

    public Forum getForum() {
        return this.forum;
    }

    public void setForum(Forum forum) {
        this.forum = forum;
    }

    public int getReplyNumber() {
        return this.replyNumber;
    }

    public void setReplyNumber(int replyNumber) {
        this.replyNumber = replyNumber;
    }

    public boolean isHideFlag() {
        return this.hideFlag;
    }

    public void setHideFlag(boolean hideFlag) {
        this.hideFlag = hideFlag;
    }

    public ForumReport getReport() {
        return this.report;
    }

    public void setReport(ForumReport report) {
        this.report = report;
    }

    public Set getSessionClones() {
        return this.sessionClones;
    }

    public void setSessionClones(Set sessionClones) {
        this.sessionClones = sessionClones;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("uid", (Object)this.uid).append("subject", (Object)this.subject).append("body", (Object)this.body).toString();
    }

    public ForumToolContentHandler getToolContentHandler() {
        return this.toolContentHandler;
    }

    public void setToolContentHandler(ForumToolContentHandler toolContentHandler) {
        this.toolContentHandler = toolContentHandler;
    }
}

