/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.persistence;

import java.io.Serializable;
import java.util.List;
import org.lamsfoundation.lams.tool.forum.persistence.Message;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class MessageDao
extends HibernateDaoSupport {
    private static final String SQL_QUERY_FIND_ROOT_TOPICS = "from " + Message.class.getName() + " m " + " where parent_uid is null and m.toolSession.sessionId=?";
    private static final String SQL_QUERY_FIND_TOPICS_FROM_AUTHOR = "from " + Message.class.getName() + " where is_authored = true and forum_uid=? order by create_date";
    private static final String SQL_QUERY_FIND_CHILDREN = "from " + Message.class.getName() + " where parent=?";
    private static final String SQL_QUERY_BY_USER_SESSION = "from " + Message.class.getName() + " m " + " where m.createdBy.uid = ? and  m.toolSession.sessionId=?";
    private static final String SQL_QUERY_BY_SESSION = "from " + Message.class.getName() + " m " + " where m.toolSession.sessionId=?";
    private static final String SQL_QUERY_TOPICS_NUMBER_BY_USER_SESSION = "select count(*) from " + Message.class.getName() + " m " + " where m.createdBy.userId=? and m.toolSession.sessionId=? and m.isAuthored = false";

    public void saveOrUpdate(Message message) {
        message.updateModificationData();
        this.getHibernateTemplate().saveOrUpdate((Object)message);
    }

    public void update(Message message) {
        this.getHibernateTemplate().saveOrUpdate((Object)message);
    }

    public Message getById(Long messageId) {
        return (Message)this.getHibernateTemplate().get(Message.class, (Serializable)messageId);
    }

    public List getRootTopics(Long sessionId) {
        return this.getHibernateTemplate().find(SQL_QUERY_FIND_ROOT_TOPICS, (Object)sessionId);
    }

    public List getTopicsFromAuthor(Long forumUid) {
        return this.getHibernateTemplate().find(SQL_QUERY_FIND_TOPICS_FROM_AUTHOR, (Object)forumUid);
    }

    public void delete(Long uid) {
        Message msg = this.getById(uid);
        if (msg != null) {
            this.getHibernateTemplate().delete((Object)msg);
        }
    }

    public List getChildrenTopics(Long parentId) {
        return this.getHibernateTemplate().find(SQL_QUERY_FIND_CHILDREN, (Object)parentId);
    }

    public List getByUserAndSession(Long userUid, Long sessionId) {
        return this.getHibernateTemplate().find(SQL_QUERY_BY_USER_SESSION, new Object[]{userUid, sessionId});
    }

    public List getBySession(Long sessionId) {
        return this.getHibernateTemplate().find(SQL_QUERY_BY_SESSION, (Object)sessionId);
    }

    public int getTopicsNum(Long userID, Long sessionId) {
        List list = this.getHibernateTemplate().find(SQL_QUERY_TOPICS_NUMBER_BY_USER_SESSION, new Object[]{userID, sessionId});
        if (list != null && list.size() > 0) {
            return ((Number)list.get(0)).intValue();
        }
        return 0;
    }
}

