/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.persistence;

import java.util.List;
import org.lamsfoundation.lams.tool.forum.persistence.MessageSeq;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class MessageSeqDao
extends HibernateDaoSupport {
    private static final String SQL_QUERY_FIND_TOPIC_THREAD = "from " + MessageSeq.class.getName() + " where root_message_uid = ?";
    private static final String SQL_QUERY_FIND_TOPIC_ID = "from " + MessageSeq.class.getName() + " where message_uid = ?";
    private static final String SQL_QUERY_NUM_POSTS_BY_TOPIC = "select count(*) from " + MessageSeq.class.getName() + " ms where ms.message.createdBy.userId=? and ms.message.isAuthored = false and ms.rootMessage=?";

    public List getTopicThread(Long rootTopicId) {
        return this.getHibernateTemplate().find(SQL_QUERY_FIND_TOPIC_THREAD, (Object)rootTopicId);
    }

    public MessageSeq getByTopicId(Long messageId) {
        List list = this.getHibernateTemplate().find(SQL_QUERY_FIND_TOPIC_ID, (Object)messageId);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (MessageSeq)list.get(0);
    }

    public void save(MessageSeq msgSeq) {
        this.getHibernateTemplate().save((Object)msgSeq);
    }

    public void deleteByTopicId(Long topicUid) {
        MessageSeq seq = this.getByTopicId(topicUid);
        if (seq != null) {
            this.getHibernateTemplate().delete((Object)seq);
        }
    }

    public int getNumOfPostsByTopic(Long userID, Long topicID) {
        List list = this.getHibernateTemplate().find(SQL_QUERY_NUM_POSTS_BY_TOPIC, new Object[]{userID, topicID});
        if (list != null && list.size() > 0) {
            return ((Number)list.get(0)).intValue();
        }
        return 0;
    }
}

