/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.service;

import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.lamsfoundation.lams.tool.OutputFactory;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.forum.service.IForumService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumOutputFactory
extends OutputFactory {
    protected static final String OUTPUT_NAME_LEARNER_NUM_POSTS = "learner.number.of.posts";

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Object toolContentObject) throws ToolException {
        TreeMap<String, ToolOutputDefinition> definitionMap = new TreeMap<String, ToolOutputDefinition>();
        ToolOutputDefinition definition = this.buildRangeDefinition(OUTPUT_NAME_LEARNER_NUM_POSTS, new Long(0L), null);
        definitionMap.put(OUTPUT_NAME_LEARNER_NUM_POSTS, definition);
        return definitionMap;
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, IForumService forumService, Long toolSessionId, Long learnerId) {
        TreeMap<String, ToolOutput> map = new TreeMap<String, ToolOutput>();
        if (names == null || names.contains(OUTPUT_NAME_LEARNER_NUM_POSTS)) {
            map.put(OUTPUT_NAME_LEARNER_NUM_POSTS, this.getNumPosts(forumService, learnerId, toolSessionId));
        }
        return map;
    }

    public ToolOutput getToolOutput(String name, IForumService forumService, Long toolSessionId, Long learnerId) {
        if (name != null && name.equals(OUTPUT_NAME_LEARNER_NUM_POSTS)) {
            return this.getNumPosts(forumService, learnerId, toolSessionId);
        }
        return null;
    }

    private ToolOutput getNumPosts(IForumService forumService, Long learnerId, Long toolSessionId) {
        int num = forumService.getTopicsNum(learnerId, toolSessionId);
        return new ToolOutput(OUTPUT_NAME_LEARNER_NUM_POSTS, this.getI18NText(OUTPUT_NAME_LEARNER_NUM_POSTS, true), new Long(num));
    }
}

