/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.forum.dto.MessageDTO;
import org.lamsfoundation.lams.tool.forum.persistence.Attachment;
import org.lamsfoundation.lams.tool.forum.persistence.AttachmentDao;
import org.lamsfoundation.lams.tool.forum.persistence.Forum;
import org.lamsfoundation.lams.tool.forum.persistence.ForumDao;
import org.lamsfoundation.lams.tool.forum.persistence.ForumException;
import org.lamsfoundation.lams.tool.forum.persistence.ForumReport;
import org.lamsfoundation.lams.tool.forum.persistence.ForumReportDAO;
import org.lamsfoundation.lams.tool.forum.persistence.ForumToolSession;
import org.lamsfoundation.lams.tool.forum.persistence.ForumToolSessionDao;
import org.lamsfoundation.lams.tool.forum.persistence.ForumUser;
import org.lamsfoundation.lams.tool.forum.persistence.ForumUserDao;
import org.lamsfoundation.lams.tool.forum.persistence.Message;
import org.lamsfoundation.lams.tool.forum.persistence.MessageDao;
import org.lamsfoundation.lams.tool.forum.persistence.MessageSeq;
import org.lamsfoundation.lams.tool.forum.persistence.MessageSeqDao;
import org.lamsfoundation.lams.tool.forum.persistence.PersistenceException;
import org.lamsfoundation.lams.tool.forum.service.ForumOutputFactory;
import org.lamsfoundation.lams.tool.forum.service.IForumService;
import org.lamsfoundation.lams.tool.forum.util.DateComparator;
import org.lamsfoundation.lams.tool.forum.util.ForumToolContentHandler;
import org.lamsfoundation.lams.tool.forum.util.TopicComparator;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumService
implements IForumService,
ToolContentManager,
ToolSessionManager,
ToolContentImport102Manager {
    private static final Logger log = Logger.getLogger(ForumService.class);
    private ForumDao forumDao;
    private AttachmentDao attachmentDao;
    private MessageDao messageDao;
    private MessageSeqDao messageSeqDao;
    private ForumUserDao forumUserDao;
    private ForumToolSessionDao forumToolSessionDao;
    private ForumReportDAO forumReportDAO;
    private ILamsToolService toolService;
    private ForumToolContentHandler forumToolContentHandler;
    private IRepositoryService repositoryService;
    private ILearnerService learnerService;
    private IAuditService auditService;
    private MessageService messageService;
    private IExportToolContentService exportContentService;
    private IUserManagementService userManagementService;
    private ICoreNotebookService coreNotebookService;
    private ForumOutputFactory forumOutputFactory;

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    public IAuditService getAuditService() {
        return this.auditService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public ForumOutputFactory getForumOutputFactory() {
        return this.forumOutputFactory;
    }

    public void setForumOutputFactory(ForumOutputFactory forumOutputFactory) {
        this.forumOutputFactory = forumOutputFactory;
    }

    @Override
    public Forum updateForum(Forum forum) throws PersistenceException {
        this.forumDao.saveOrUpdate(forum);
        return forum;
    }

    @Override
    public Forum getForum(Long forumUid) throws PersistenceException {
        return this.forumDao.getById(forumUid);
    }

    @Override
    public Forum getForumByContentId(Long contentID) throws PersistenceException {
        return this.forumDao.getByContentId(contentID);
    }

    @Override
    public void deleteForumAttachment(Long attachmentId) throws PersistenceException {
        Attachment attachment = this.attachmentDao.getById(attachmentId);
        this.attachmentDao.delete(attachment);
    }

    @Override
    public Message createRootTopic(Long forumId, Long sessionId, Message message) throws PersistenceException {
        return this.createRootTopic(forumId, this.getSessionBySessionId(sessionId), message);
    }

    public Message createRootTopic(Long forumId, ForumToolSession session, Message message) throws PersistenceException {
        if (message.getForum() == null) {
            Forum forum = this.forumDao.getById(forumId);
            message.setForum(forum);
        }
        if (session != null) {
            message.setToolSession(session);
        }
        if (message.getUid() == null) {
            MessageSeq msgSeq = new MessageSeq();
            msgSeq.setMessage(message);
            msgSeq.setMessageLevel((short)0);
            msgSeq.setRootMessage(message);
            this.messageSeqDao.save(msgSeq);
        }
        if (message.getSessionClones().size() > 0) {
            for (Message clone : message.getSessionClones()) {
                message.updateClone(clone);
            }
        }
        this.messageDao.saveOrUpdate(message);
        return message;
    }

    @Override
    public Message updateTopic(Message message) throws PersistenceException {
        this.messageDao.saveOrUpdate(message);
        MessageSeq msgSeq = this.messageSeqDao.getByTopicId(message.getUid());
        Message root = msgSeq.getRootMessage();
        this.messageDao.saveOrUpdate(root);
        return message;
    }

    @Override
    public void updateReport(ForumReport report) {
        this.forumReportDAO.saveObject(report);
    }

    @Override
    public Message updateMessageHideFlag(Long messageId, boolean hideFlag) {
        Message message = this.getMessage(messageId);
        if (message != null) {
            Long userId = 0L;
            String loginName = "Default";
            if (message.getCreatedBy() == null) {
                userId = message.getCreatedBy().getUserId();
                loginName = message.getCreatedBy().getLoginName();
            }
            if (hideFlag) {
                this.auditService.logHideEntry("lafrum11", userId, loginName, message.toString());
            } else {
                this.auditService.logShowEntry("lafrum11", userId, loginName, message.toString());
            }
            message.setHideFlag(hideFlag);
            this.messageDao.update(message);
        }
        return message;
    }

    @Override
    public Message getMessage(Long messageUid) throws PersistenceException {
        return this.messageDao.getById(messageUid);
    }

    @Override
    public void deleteTopic(Long topicUid) throws PersistenceException {
        List children = this.messageDao.getChildrenTopics(topicUid);
        if (children != null) {
            for (Message msg : children) {
                this.deleteTopic(msg.getUid());
            }
        }
        this.messageSeqDao.deleteByTopicId(topicUid);
        this.messageDao.delete(topicUid);
    }

    @Override
    public Message replyTopic(Long parentId, Long sessionId, Message replyMessage) throws PersistenceException {
        Message parent = this.getMessage(parentId);
        replyMessage.setParent(parent);
        replyMessage.setForum(parent.getForum());
        ForumToolSession session = this.getSessionBySessionId(sessionId);
        replyMessage.setToolSession(session);
        this.messageDao.saveOrUpdate(replyMessage);
        MessageSeq parentSeq = this.messageSeqDao.getByTopicId(parent.getUid());
        if (parentSeq == null) {
            log.error((Object)("Message Sequence table is broken becuase topic " + parent + " can not get Sequence Record"));
        }
        Message root = parentSeq.getRootMessage();
        MessageSeq msgSeq = new MessageSeq();
        msgSeq.setMessage(replyMessage);
        msgSeq.setMessageLevel((short)(parentSeq.getMessageLevel() + 1));
        msgSeq.setRootMessage(root);
        this.messageSeqDao.save(msgSeq);
        root.setLastReplyDate(new Date());
        root.setReplyNumber(root.getReplyNumber() + 1);
        this.messageDao.saveOrUpdate(root);
        return replyMessage;
    }

    @Override
    public Attachment uploadInstructionFile(FormFile uploadFile, String fileType) throws PersistenceException {
        if (uploadFile == null || StringUtils.isEmpty((String)uploadFile.getFileName())) {
            throw new ForumException("Could not find upload file: " + uploadFile);
        }
        NodeKey nodeKey = this.processFile(uploadFile, fileType);
        Attachment file = new Attachment();
        file.setFileType(fileType);
        file.setFileUuid(nodeKey.getUuid());
        file.setFileVersionId(nodeKey.getVersion());
        file.setFileName(uploadFile.getFileName());
        file.setCreated(new Date());
        return file;
    }

    @Override
    public void deleteFromRepository(Long uuid, Long versionID) throws ForumException {
        ITicket ticket = this.getRepositoryLoginTicket();
        try {
            this.repositoryService.deleteVersion(ticket, uuid, versionID);
        }
        catch (Exception e) {
            throw new ForumException("Exception occured while deleting files from the repository " + e.getMessage());
        }
    }

    @Override
    public Attachment uploadAttachment(FormFile uploadFile) throws PersistenceException {
        if (uploadFile == null || StringUtils.isEmpty((String)uploadFile.getFileName())) {
            throw new ForumException("Could not find upload file: " + uploadFile);
        }
        NodeKey nodeKey = this.processFile(uploadFile, "ONLINE");
        Attachment file = new Attachment();
        file.setFileType("ONLINE");
        file.setFileUuid(nodeKey.getUuid());
        file.setFileVersionId(nodeKey.getVersion());
        file.setFileName(uploadFile.getFileName());
        return file;
    }

    @Override
    public List getTopicThread(Long rootTopicId) {
        List unsortedThread = this.messageSeqDao.getTopicThread(rootTopicId);
        Iterator iter = unsortedThread.iterator();
        TreeMap<MessageSeq, Message> map = new TreeMap<MessageSeq, Message>(new TopicComparator());
        while (iter.hasNext()) {
            MessageSeq msgSeq = (MessageSeq)iter.next();
            map.put(msgSeq, msgSeq.getMessage());
        }
        return this.getSortedMessageDTO(map);
    }

    @Override
    public List getRootTopics(Long sessionId) {
        List topicsBySession = this.messageDao.getRootTopics(sessionId);
        ForumToolSession session = this.getSessionBySessionId(sessionId);
        if (session == null || session.getForum() == null) {
            log.error((Object)("Failed on getting session by given sessionID:" + sessionId));
            throw new ForumException("Failed on getting session by given sessionID:" + sessionId);
        }
        TreeMap<Date, Message> map = new TreeMap<Date, Message>(new DateComparator());
        for (Message msg : topicsBySession) {
            map.put(msg.getCreated(), msg);
        }
        return MessageDTO.getMessageDTO(new ArrayList(map.values()));
    }

    @Override
    public int getTopicsNum(Long userID, Long sessionId) {
        return this.messageDao.getTopicsNum(userID, sessionId);
    }

    @Override
    public int getNumOfPostsByTopic(Long userId, Long topicId) {
        return this.messageSeqDao.getNumOfPostsByTopic(userId, topicId);
    }

    @Override
    public ForumUser getUserByID(Long userId) {
        return this.forumUserDao.getByUserId(userId);
    }

    @Override
    public ForumUser getUserByUserAndSession(Long userId, Long sessionId) {
        return this.forumUserDao.getByUserIdAndSessionId(userId, sessionId);
    }

    @Override
    public void createUser(ForumUser forumUser) {
        this.forumUserDao.save(forumUser);
    }

    @Override
    public ForumToolSession getSessionBySessionId(Long sessionId) {
        return this.forumToolSessionDao.getBySessionId(sessionId);
    }

    @Override
    public Long getRootTopicId(Long topicId) {
        MessageSeq seq = this.messageSeqDao.getByTopicId(topicId);
        if (seq == null || seq.getRootMessage() == null) {
            log.error((Object)("A sequence information can not be found for topic ID:" + topicId));
            return null;
        }
        return seq.getRootMessage().getUid();
    }

    @Override
    public List getAuthoredTopics(Long forumUid) {
        List list = this.messageDao.getTopicsFromAuthor(forumUid);
        TreeMap<Date, Message> map = new TreeMap<Date, Message>(new DateComparator());
        for (Message topic : list) {
            if (topic.getToolSession() != null) continue;
            map.put(topic.getCreated(), topic);
        }
        return MessageDTO.getMessageDTO(new ArrayList(map.values()));
    }

    public Long getToolDefaultContentIdBySignature(String toolSignature) {
        Long contentId = null;
        contentId = new Long(this.toolService.getToolDefaultContentIdBySignature(toolSignature));
        if (contentId == null) {
            String error = "Could not retrieve default content id for this tool";
            log.error((Object)error);
            throw new ForumException(error);
        }
        return contentId;
    }

    @Override
    public List getSessionsByContentId(Long contentID) {
        return this.forumToolSessionDao.getByContentId(contentID);
    }

    @Override
    public List getUsersBySessionId(Long sessionID) {
        return this.forumUserDao.getBySessionId(sessionID);
    }

    @Override
    public List getMessagesByUserUid(Long userId, Long sessionId) {
        List list = this.messageDao.getByUserAndSession(userId, sessionId);
        return MessageDTO.getMessageDTO(list);
    }

    @Override
    public ForumUser getUser(Long userUid) {
        return this.forumUserDao.getByUid(userUid);
    }

    @Override
    public void releaseMarksForSession(Long sessionID) {
        List list = this.messageDao.getBySession(sessionID);
        for (Message msg : list) {
            ForumReport report = msg.getReport();
            if (report != null) {
                report.setDateMarksReleased(new Date());
            }
            this.messageDao.saveOrUpdate(msg);
        }
        ForumToolSession session = this.forumToolSessionDao.getBySessionId(sessionID);
        session.setMarkReleased(true);
        this.forumToolSessionDao.saveOrUpdate(session);
    }

    @Override
    public void finishUserSession(ForumUser currentUser) {
        currentUser.setSessionFinished(true);
        this.forumUserDao.save(currentUser);
    }

    private List getSortedMessageDTO(SortedMap<MessageSeq, Message> map) {
        ArrayList<MessageDTO> msgDtoList = new ArrayList<MessageDTO>();
        for (Map.Entry<MessageSeq, Message> entry : map.entrySet()) {
            MessageSeq msgSeq = entry.getKey();
            MessageDTO dto = MessageDTO.getMessageDTO(entry.getValue());
            dto.setLevel(msgSeq.getMessageLevel());
            msgDtoList.add(dto);
        }
        return msgDtoList;
    }

    private NodeKey processFile(FormFile file, String fileType) {
        NodeKey node = null;
        if (file != null && !StringUtils.isEmpty((String)file.getFileName())) {
            String fileName = file.getFileName();
            try {
                node = this.getForumToolContentHandler().uploadFile(file.getInputStream(), fileName, file.getContentType(), fileType);
            }
            catch (InvalidParameterException e) {
                throw new ForumException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
            catch (FileNotFoundException e) {
                throw new ForumException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
            catch (RepositoryCheckedException e) {
                throw new ForumException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
            catch (IOException e) {
                throw new ForumException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
        }
        return node;
    }

    private ITicket getRepositoryLoginTicket() throws ForumException {
        SimpleCredentials credentials = new SimpleCredentials(this.forumToolContentHandler.getRepositoryUser(), this.forumToolContentHandler.getRepositoryId());
        try {
            ITicket ticket = this.repositoryService.login((ICredentials)credentials, this.forumToolContentHandler.getRepositoryWorkspaceName());
            return ticket;
        }
        catch (AccessDeniedException ae) {
            throw new ForumException("Access Denied to repository." + ae.getMessage());
        }
        catch (WorkspaceNotFoundException we) {
            throw new ForumException("Workspace not found." + we.getMessage());
        }
        catch (LoginException e) {
            throw new ForumException("Login failed." + e.getMessage());
        }
    }

    private Forum getDefaultForum() {
        Long defaultForumId = this.getToolDefaultContentIdBySignature("lafrum11");
        Forum defaultForum = this.getForumByContentId(defaultForumId);
        if (defaultForum == null) {
            String error = "Could not retrieve default content record for this tool";
            log.error((Object)error);
            throw new ForumException(error);
        }
        return defaultForum;
    }

    @Override
    public Long createNotebookEntry(Long sessionId, Integer notebookToolType, String toolSignature, Integer userId, String entryText) {
        return this.coreNotebookService.createNotebookEntry(sessionId, notebookToolType, toolSignature, userId, "", entryText);
    }

    @Override
    public NotebookEntry getEntry(Long sessionId, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(sessionId, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    @Override
    public void updateEntry(NotebookEntry notebookEntry) {
        this.coreNotebookService.updateEntry(notebookEntry);
    }

    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        if (toContentId == null) {
            throw new ToolException("Failed to create the ForumFiles tool seession");
        }
        Forum fromContent = null;
        if (fromContentId != null) {
            fromContent = this.forumDao.getByContentId(fromContentId);
        }
        if (fromContent == null) {
            fromContent = this.getDefaultForum();
        }
        Forum toContent = Forum.newInstance(fromContent, toContentId, this.forumToolContentHandler);
        this.forumDao.saveOrUpdate(toContent);
        Set topics = toContent.getMessages();
        if (topics != null) {
            for (Message msg : topics) {
                if (!msg.getIsAuthored()) continue;
                msg.setReplyNumber(0);
                msg.setUpdated(new Date());
                msg.setLastReplyDate(new Date());
                msg.setHideFlag(false);
                msg.setForum(toContent);
                this.createRootTopic(toContent.getUid(), (ForumToolSession)null, msg);
            }
        }
    }

    public void setAsDefineLater(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Forum forum = this.forumDao.getByContentId(toolContentId);
        if (forum == null) {
            throw new ToolException("No found tool content by given content ID:" + toolContentId);
        }
        forum.setDefineLater(value);
        forum.setContentInUse(false);
    }

    public void setAsRunOffline(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Forum forum = this.forumDao.getByContentId(toolContentId);
        if (forum == null) {
            throw new ToolException("No found tool content by given content ID:" + toolContentId);
        }
        forum.setRunOffline(value);
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException, ToolException {
        Forum forum = this.forumDao.getByContentId(toolContentId);
        if (removeSessionData) {
            List list = this.forumToolSessionDao.getByContentId(toolContentId);
            for (ForumToolSession session : list) {
                this.forumToolSessionDao.delete(session);
            }
        }
        this.forumDao.delete(forum);
    }

    public void exportToolContent(Long toolContentId, String rootPath) throws DataMissingException, ToolException {
        Forum toolContentObj = this.forumDao.getByContentId(toolContentId);
        if (toolContentObj == null) {
            toolContentObj = this.getDefaultForum();
        }
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to find default content for the forum tool");
        }
        toolContentObj = Forum.newInstance(toolContentObj, toolContentId, null);
        toolContentObj.setToolContentHandler(null);
        toolContentObj.setCreatedBy(null);
        Set items = toolContentObj.getMessages();
        HashSet<Message> authorItems = new HashSet<Message>();
        for (Message item : items) {
            if (!item.getIsAuthored()) continue;
            authorItems.add(item);
            item.setCreatedBy(null);
            item.setModifiedBy(null);
            item.setToolSession(null);
            item.setForum(null);
            item.setToolContentHandler(null);
            item.setReport(null);
            item.setReplyNumber(0);
            item.setParent(null);
            item.setSessionClones(null);
        }
        toolContentObj.setMessages(authorItems);
        try {
            this.exportContentService.registerFileClassForExport(Attachment.class.getName(), "fileUuid", "fileVersionId");
            this.exportContentService.exportToolContent(toolContentId, (Object)toolContentObj, (IToolContentHandler)this.forumToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(Attachment.class.getName(), "fileUuid", "fileVersionId", "fileName", "fileType", null, null);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, (IToolContentHandler)this.forumToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof Forum)) {
                throw new ImportToolContentException("Import Forum tool content failed. Deserialized object is " + toolPOJO);
            }
            Forum toolContentObj = (Forum)toolPOJO;
            toolContentObj.setContentId(toolContentId);
            ForumUser user = this.forumUserDao.getByUserId(new Long(newUserUid.longValue()));
            if (user == null) {
                user = new ForumUser();
                UserDTO sysUser = ((User)this.userManagementService.findById(User.class, (Serializable)newUserUid)).getUserDTO();
                user.setFirstName(sysUser.getFirstName());
                user.setLastName(sysUser.getLastName());
                user.setLoginName(sysUser.getLogin());
                user.setUserId(new Long(newUserUid.longValue()));
                this.createUser(user);
            }
            toolContentObj.setCreatedBy(user);
            this.forumDao.saveOrUpdate(toolContentObj);
            Set items = toolContentObj.getMessages();
            for (Message item : items) {
                item.setCreatedBy(user);
                item.setIsAuthored(true);
                item.setForum(toolContentObj);
                item.setSessionClones(new HashSet());
                this.createRootTopic(toolContentObj.getUid(), (ForumToolSession)null, item);
            }
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Long toolContentId) throws ToolException {
        Forum forum = this.getForum(toolContentId);
        if (forum == null) {
            forum = this.getDefaultForum();
        }
        return this.getForumOutputFactory().getToolOutputDefinitions(forum);
    }

    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) throws ToolException {
        ForumToolSession session = new ForumToolSession();
        session.setSessionId(toolSessionId);
        session.setSessionName(toolSessionName);
        Forum forum = this.forumDao.getByContentId(toolContentId);
        session.setForum(forum);
        log.debug((Object)("Clone tool content [" + forum.getContentId() + "] topics for session [" + session.getSessionId() + "]"));
        Set contentTopics = forum.getMessages();
        if (contentTopics != null && contentTopics.size() > 0) {
            for (Message msg : contentTopics) {
                if (!msg.getIsAuthored() || msg.getToolSession() != null) continue;
                Message newMsg = Message.newInstance(msg, this.forumToolContentHandler);
                msg.getSessionClones().add(newMsg);
                this.createRootTopic(forum.getContentId(), session, newMsg);
            }
        }
        session.setStatus(1);
        this.forumToolSessionDao.saveOrUpdate(session);
        log.debug((Object)("tool session [" + session.getSessionId() + "] created."));
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        if (toolSessionId == null) {
            log.error((Object)"Fail to leave tool Session based on null tool session id.");
            throw new ToolException("Fail to remove tool Session based on null tool session id.");
        }
        if (learnerId == null) {
            log.error((Object)"Fail to leave tool Session based on null learner.");
            throw new ToolException("Fail to remove tool Session based on null learner.");
        }
        ForumToolSession session = this.forumToolSessionDao.getBySessionId(toolSessionId);
        if (session == null) {
            log.error((Object)("Fail to leave tool Session.Could not find submit file session by given session id: " + toolSessionId));
            throw new DataMissingException("Fail to leave tool Session.Could not find submit file session by given session id: " + toolSessionId);
        }
        this.forumToolSessionDao.saveOrUpdate(session);
        return this.learnerService.completeToolSession(toolSessionId, learnerId);
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        return null;
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) throws DataMissingException, ToolException {
        return null;
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        this.forumToolSessionDao.delete(toolSessionId);
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, Long toolSessionId, Long learnerId) {
        return this.forumOutputFactory.getToolOutput(names, (IForumService)this, toolSessionId, learnerId);
    }

    public ToolOutput getToolOutput(String name, Long toolSessionId, Long learnerId) {
        return this.forumOutputFactory.getToolOutput(name, (IForumService)this, toolSessionId, learnerId);
    }

    @Override
    public Forum getDefaultContent(Long contentID) {
        if (contentID == null) {
            String error = "Could not retrieve default content id for Forum tool";
            log.error((Object)error);
            throw new ForumException(error);
        }
        Forum defaultContent = this.getDefaultForum();
        Forum content = new Forum();
        content = Forum.newInstance(defaultContent, contentID, this.forumToolContentHandler);
        Set topics = content.getMessages();
        if (topics != null) {
            for (Message msg : topics) {
                msg.setForum(null);
            }
        }
        return content;
    }

    @Override
    public List<MessageDTO> getAllTopicsFromSession(Long sessionID) {
        return MessageDTO.getMessageDTO(this.messageDao.getBySession(sessionID));
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        block7: {
            Date now = new Date();
            Forum toolContentObj = new Forum();
            try {
                toolContentObj.setTitle((String)importValues.get("title"));
                toolContentObj.setAllowAnonym(Boolean.FALSE);
                toolContentObj.setAllowEdit(Boolean.TRUE);
                toolContentObj.setAllowNewTopic(Boolean.TRUE);
                toolContentObj.setAllowRichEditor(Boolean.FALSE);
                toolContentObj.setAllowUpload(Boolean.TRUE);
                toolContentObj.setContentId(toolContentId);
                toolContentObj.setContentInUse(Boolean.FALSE);
                toolContentObj.setCreated(now);
                toolContentObj.setDefineLater(Boolean.FALSE);
                toolContentObj.setInstructions(WebUtil.convertNewlines((String)((String)importValues.get("body"))));
                toolContentObj.setLimitedChar(5000);
                toolContentObj.setReflectOnActivity(Boolean.FALSE);
                toolContentObj.setReflectInstructions(null);
                Boolean bool = WDDXProcessor.convertToBoolean((Hashtable)importValues, (String)"isReusable");
                toolContentObj.setLockWhenFinished(bool != null ? !bool.booleanValue() : false);
                toolContentObj.setMaximumReply(0);
                toolContentObj.setMinimumReply(0);
                toolContentObj.setOfflineInstructions(null);
                toolContentObj.setOnlineInstructions(null);
                toolContentObj.setRunOffline(Boolean.FALSE);
                toolContentObj.setUpdated(now);
                ForumUser forumUser = new ForumUser();
                forumUser.setUserId(new Long(user.getUserID().longValue()));
                forumUser.setFirstName(user.getFirstName());
                forumUser.setLastName(user.getLastName());
                forumUser.setLoginName(user.getLogin());
                this.createUser(forumUser);
                toolContentObj.setCreatedBy(forumUser);
                this.forumDao.saveOrUpdate(toolContentObj);
                TreeMap<Integer, Hashtable> messageMaps = new TreeMap<Integer, Hashtable>();
                Vector topics = (Vector)importValues.get("topics");
                Date msgDate = null;
                if (topics == null) break block7;
                for (Map messageMap : topics) {
                    Integer order = WDDXProcessor.convertToInteger((Hashtable)messageMap, (String)"number");
                    messageMaps.put(order, (Hashtable)messageMap);
                }
                for (Map messageMap : messageMaps.values()) {
                    Message message = new Message();
                    message.setIsAuthored(true);
                    if (msgDate != null) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    msgDate = new Date();
                    message.setCreated(msgDate);
                    message.setCreatedBy(forumUser);
                    message.setUpdated(msgDate);
                    message.setLastReplyDate(msgDate);
                    message.setSubject((String)messageMap.get("title"));
                    message.setBody(WebUtil.convertNewlines((String)((String)messageMap.get("message"))));
                    message.setHideFlag(Boolean.FALSE);
                    message.setIsAnonymous(Boolean.FALSE);
                    this.createRootTopic(toolContentObj.getUid(), (ForumToolSession)null, message);
                }
            }
            catch (WDDXProcessorConversionException e) {
                log.error((Object)("Unable to content for activity " + toolContentObj.getTitle() + "properly due to a WDDXProcessorConversionException."), (Throwable)e);
                throw new ToolException("Invalid import data format for activity " + toolContentObj.getTitle() + "- WDDX caused an exception. Some data from the design will have been lost. See log for more details.");
            }
        }
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        Forum toolContentObj = this.getForumByContentId(toolContentId);
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        toolContentObj.setReflectOnActivity(Boolean.TRUE);
        toolContentObj.setReflectInstructions(description);
    }

    public ILamsToolService getToolService() {
        return this.toolService;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public AttachmentDao getAttachmentDao() {
        return this.attachmentDao;
    }

    public void setAttachmentDao(AttachmentDao attachmentDao) {
        this.attachmentDao = attachmentDao;
    }

    public ForumDao getForumDao() {
        return this.forumDao;
    }

    public void setForumDao(ForumDao forumDao) {
        this.forumDao = forumDao;
    }

    public MessageDao getMessageDao() {
        return this.messageDao;
    }

    public void setMessageDao(MessageDao messageDao) {
        this.messageDao = messageDao;
    }

    public MessageSeqDao getMessageSeqDao() {
        return this.messageSeqDao;
    }

    public void setMessageSeqDao(MessageSeqDao messageSeqDao) {
        this.messageSeqDao = messageSeqDao;
    }

    public ForumToolSessionDao getForumToolSessionDao() {
        return this.forumToolSessionDao;
    }

    public void setForumToolSessionDao(ForumToolSessionDao forumToolSessionDao) {
        this.forumToolSessionDao = forumToolSessionDao;
    }

    public ForumUserDao getForumUserDao() {
        return this.forumUserDao;
    }

    public void setForumUserDao(ForumUserDao forumUserDao) {
        this.forumUserDao = forumUserDao;
    }

    public IRepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(IRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public ForumToolContentHandler getForumToolContentHandler() {
        return this.forumToolContentHandler;
    }

    public void setForumToolContentHandler(ForumToolContentHandler toolContentHandler) {
        this.forumToolContentHandler = toolContentHandler;
    }

    public ILearnerService getLearnerService() {
        return this.learnerService;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public IUserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public ForumReportDAO getForumReportDAO() {
        return this.forumReportDAO;
    }

    public void setForumReportDAO(ForumReportDAO forumReportDAO) {
        this.forumReportDAO = forumReportDAO;
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }
}

