/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.forum.persistence.Forum;
import org.lamsfoundation.lams.tool.forum.persistence.ForumException;

public class ForumWebUtils {
    public static boolean isForumEditable(Forum forum) {
        if (forum.isDefineLater() && forum.isContentInUse()) {
            throw new ForumException("An exception has occurred: There is a bug in this tool, conflicting flags are set");
        }
        if (forum.isDefineLater() && !forum.isContentInUse()) {
            return true;
        }
        return !forum.isDefineLater() && !forum.isContentInUse();
    }

    public static ToolAccessMode getAccessMode(HttpServletRequest request) {
        ToolAccessMode mode = null;
        String modeStr = request.getParameter("mode");
        if (StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString())) {
            mode = ToolAccessMode.TEACHER;
        } else if (StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.AUTHOR.toString())) {
            mode = ToolAccessMode.AUTHOR;
        } else if (StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.LEARNER.toString())) {
            mode = ToolAccessMode.LEARNER;
        }
        return mode;
    }
}

