/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.util;

import java.util.Comparator;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.forum.persistence.Message;
import org.lamsfoundation.lams.tool.forum.persistence.MessageSeq;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicComparator
implements Comparator<MessageSeq> {
    private static final Logger log = Logger.getLogger(TopicComparator.class);

    @Override
    public int compare(MessageSeq msgSeq1, MessageSeq msgSeq2) {
        int level2;
        Message msg1 = msgSeq1.getMessage();
        Message msg2 = msgSeq2.getMessage();
        int level1 = msgSeq1.getMessageLevel();
        int lessLevel = level1 > (level2 = msgSeq2.getMessageLevel()) ? level2 : level1;
        for (int compareLevel = 0; compareLevel <= lessLevel; ++compareLevel) {
            Message parent1 = msg1;
            Message parent2 = msg2;
            level2 = msgSeq2.getMessageLevel();
            for (level1 = msgSeq1.getMessageLevel(); level1 > compareLevel; level1 = (short)(level1 - 1)) {
                if (parent1 == null) {
                    log.error((Object)("Message " + parent1 + " level " + level1 + " has null parent"));
                    return 0;
                }
                parent1 = parent1.getParent();
            }
            while (level2 > compareLevel) {
                if (parent2 == null) {
                    log.error((Object)("Message " + parent2 + " level " + level2 + " has null parent"));
                    return 0;
                }
                parent2 = parent2.getParent();
                level2 = (short)(level2 - 1);
            }
            if (parent1 != parent2) {
                return parent1.getUpdated().before(parent2.getUpdated()) ? -1 : 1;
            }
            if (compareLevel != lessLevel) continue;
            if (msgSeq1.getMessageLevel() != msgSeq2.getMessageLevel()) {
                return msgSeq1.getMessageLevel() - msgSeq2.getMessageLevel();
            }
            return msg1.getUpdated().before(msg2.getUpdated()) ? -1 : 1;
        }
        return msg1.getUpdated().before(msg2.getUpdated()) ? -1 : 1;
    }
}

