/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.web.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.forum.dto.MessageDTO;
import org.lamsfoundation.lams.tool.forum.persistence.Attachment;
import org.lamsfoundation.lams.tool.forum.persistence.Forum;
import org.lamsfoundation.lams.tool.forum.persistence.ForumUser;
import org.lamsfoundation.lams.tool.forum.persistence.Message;
import org.lamsfoundation.lams.tool.forum.persistence.PersistenceException;
import org.lamsfoundation.lams.tool.forum.service.IForumService;
import org.lamsfoundation.lams.tool.forum.util.DateComparator;
import org.lamsfoundation.lams.tool.forum.util.ForumWebUtils;
import org.lamsfoundation.lams.tool.forum.web.forms.ForumForm;
import org.lamsfoundation.lams.tool.forum.web.forms.MessageForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AuthoringAction
extends Action {
    private static Logger log = Logger.getLogger(AuthoringAction.class);
    private IForumService forumService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, PersistenceException {
        String param = mapping.getParameter();
        if (param.equals("initPage")) {
            request.setAttribute("mode", (Object)ToolAccessMode.AUTHOR);
            return this.initPage(mapping, form, request, response);
        }
        if (param.equals("defineLater")) {
            request.setAttribute("mode", (Object)ToolAccessMode.TEACHER);
            this.forumService = this.getForumManager();
            Long contentId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
            Forum forum = this.forumService.getForumByContentId(contentId);
            boolean isForumEditable = ForumWebUtils.isForumEditable(forum);
            if (!isForumEditable) {
                request.setAttribute("isPageEditable", (Object)new Boolean(isForumEditable));
                return mapping.findForward("forbidden");
            }
            if (!forum.isContentInUse()) {
                forum.setDefineLater(true);
                this.forumService.updateForum(forum);
            }
            return this.initPage(mapping, form, request, response);
        }
        if (param.equals("updateContent")) {
            return this.updateContent(mapping, form, request, response);
        }
        if (param.equals("uploadOnlineFile")) {
            return this.uploadOnline(mapping, form, request, response);
        }
        if (param.equals("uploadOfflineFile")) {
            return this.uploadOffline(mapping, form, request, response);
        }
        if (param.equals("deleteOnlineFile")) {
            return this.deleteOnlineFile(mapping, form, request, response);
        }
        if (param.equals("deleteOfflineFile")) {
            return this.deleteOfflineFile(mapping, form, request, response);
        }
        if (param.equals("newTopic")) {
            return this.newTopic(mapping, form, request, response);
        }
        if (param.equals("createTopic")) {
            return this.createTopic(mapping, form, request, response);
        }
        if (param.equals("editTopic")) {
            return this.editTopic(mapping, form, request, response);
        }
        if (param.equals("updateTopic")) {
            return this.updateTopic(mapping, form, request, response);
        }
        if (param.equals("viewTopic")) {
            return this.viewTopic(mapping, form, request, response);
        }
        if (param.equals("deleteTopic")) {
            return this.deleteTopic(mapping, form, request, response);
        }
        if (param.equals("deleteAttachment")) {
            return this.deleteAttachment(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    protected ActionForward initPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        Long contentId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        ForumForm forumForm = (ForumForm)form;
        forumForm.setSessionMapID(sessionMap.getSessionID());
        forumForm.setContentFolderID(contentFolderID);
        sessionMap.put((Object)"contentFolderID", (Object)contentFolderID);
        this.forumService = this.getForumManager();
        List<MessageDTO> topics = null;
        Forum forum = null;
        try {
            forum = this.forumService.getForumByContentId(contentId);
            if (forum == null) {
                forum = this.forumService.getDefaultContent(contentId);
                if (forum.getMessages() != null) {
                    TreeMap<Date, Message> map = new TreeMap<Date, Message>(new DateComparator());
                    for (Message topic : forum.getMessages()) {
                        if (topic.getCreatedBy() == null && !StringUtils.equals((String)contentFolderID, (String)"-1")) {
                            HttpSession ss = SessionManager.getSession();
                            UserDTO user = (UserDTO)ss.getAttribute("user");
                            ForumUser fuser = new ForumUser(user, null);
                            topic.setCreatedBy(fuser);
                        }
                        map.put(topic.getCreated(), topic);
                    }
                    topics = MessageDTO.getMessageDTO(new ArrayList(map.values()));
                } else {
                    topics = null;
                }
            } else {
                topics = this.forumService.getAuthoredTopics(forum.getUid());
                if (!StringUtils.equals((String)contentFolderID, (String)"-1")) {
                    for (MessageDTO messageDTO : topics) {
                        if (!StringUtils.isBlank((String)messageDTO.getAuthor())) continue;
                        HttpSession ss = SessionManager.getSession();
                        UserDTO user = (UserDTO)ss.getAttribute("user");
                        ForumUser fuser = new ForumUser(user, null);
                        messageDTO.setAuthor(fuser.getFirstName() + " " + fuser.getLastName());
                    }
                }
            }
            List attachmentList = this.getAttachmentList(sessionMap);
            attachmentList.addAll(forum.getAttachments());
            forumForm.setForum((Forum)forum.clone());
        }
        catch (Exception e) {
            log.error((Object)e);
            return mapping.findForward("error");
        }
        if (topics == null) {
            topics = new ArrayList<MessageDTO>();
        }
        sessionMap.put((Object)"topicList", topics);
        return mapping.findForward("success");
    }

    public ActionForward updateContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ToolAccessMode mode = this.getAccessMode(request);
        ForumForm forumForm = (ForumForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(forumForm.getSessionMapID());
        ActionMessages errors = this.validate(forumForm, mapping, request);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            if (mode.isAuthor()) {
                return mapping.findForward("author");
            }
            return mapping.findForward("monitor");
        }
        Forum forum = forumForm.getForum();
        forum.setContentId(forumForm.getToolContentID());
        try {
            Forum forumPO;
            HttpSession ss;
            UserDTO user;
            this.forumService = this.getForumManager();
            String contentFolderID = (String)sessionMap.get((Object)"contentFolderID");
            ForumUser forumUser = null;
            if (!StringUtils.equals((String)contentFolderID, (String)"-1") && (forumUser = this.forumService.getUserByID(new Long((user = (UserDTO)(ss = SessionManager.getSession()).getAttribute("user")).getUserID().intValue()))) == null) {
                forumUser = new ForumUser(user, null);
                this.forumService.createUser(forumUser);
            }
            if ((forumPO = this.forumService.getForumByContentId(forumForm.getToolContentID())) == null) {
                forumPO = forum;
                forumPO.setContentId(forumForm.getToolContentID());
            } else if (mode.isAuthor()) {
                Long uid = forumPO.getUid();
                PropertyUtils.copyProperties((Object)forumPO, (Object)forum);
                forumPO.setUid(uid);
            } else {
                forumPO.setInstructions(forum.getInstructions());
                forumPO.setTitle(forum.getTitle());
                forumPO.setDefineLater(false);
            }
            forumPO.setCreatedBy(forumUser);
            HashSet<Attachment> attPOSet = forumPO.getAttachments();
            if (attPOSet == null) {
                attPOSet = new HashSet<Attachment>();
            }
            List attachmentList = this.getAttachmentList(sessionMap);
            List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
            for (Attachment newAtt : attachmentList) {
                attPOSet.add(newAtt);
            }
            attachmentList.clear();
            Iterator iter = deleteAttachmentList.iterator();
            while (iter.hasNext()) {
                Attachment delAtt = (Attachment)iter.next();
                iter.remove();
                if (delAtt.getUid() == null) continue;
                Iterator attIter = attPOSet.iterator();
                while (attIter.hasNext()) {
                    Attachment att = (Attachment)attIter.next();
                    if (!delAtt.getUid().equals(att.getUid())) continue;
                    attIter.remove();
                    break;
                }
                this.forumService.deleteForumAttachment(delAtt.getUid());
            }
            forumPO.setAttachments(attPOSet);
            forum = this.forumService.updateForum(forumPO);
            List topicDeleteAttachmentList = this.getTopicDeletedAttachmentList(sessionMap);
            iter = topicDeleteAttachmentList.iterator();
            while (iter.hasNext()) {
                Attachment delAtt = (Attachment)iter.next();
                iter.remove();
            }
            List topics = this.getTopicList(sessionMap);
            for (MessageDTO dto : topics) {
                if (dto.getMessage() == null) continue;
                dto.getMessage().setCreatedBy(forumUser);
                dto.getMessage().setModifiedBy(forumUser);
                this.forumService.createRootTopic(forum.getUid(), null, dto.getMessage());
            }
            List delTopics = this.getDeletedTopicList(sessionMap);
            iter = delTopics.iterator();
            while (iter.hasNext()) {
                MessageDTO dto = (MessageDTO)iter.next();
                iter.remove();
                if (dto.getMessage() == null || dto.getMessage().getUid() == null) continue;
                this.forumService.deleteTopic(dto.getMessage().getUid());
            }
            attachmentList = this.getAttachmentList(sessionMap);
            attachmentList.addAll(forum.getAttachments());
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
        if (mode.isAuthor()) {
            return mapping.findForward("author");
        }
        return mapping.findForward("monitor");
    }

    public ActionForward uploadOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.uploadFile(mapping, form, "ONLINE", request);
    }

    public ActionForward uploadOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.uploadFile(mapping, form, "OFFLINE", request);
    }

    private ActionForward uploadFile(ActionMapping mapping, ActionForm form, String type, HttpServletRequest request) {
        ForumForm forumForm = (ForumForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(forumForm.getSessionMapID());
        FormFile file = StringUtils.equals((String)"OFFLINE", (String)type) ? forumForm.getOfflineFile() : forumForm.getOnlineFile();
        if (file == null || StringUtils.isBlank((String)file.getFileName())) {
            return mapping.findForward("success");
        }
        ActionMessages errors = new ActionMessages();
        FileValidatorUtil.validateFileSize((FormFile)file, (boolean)true, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return mapping.findForward("success");
        }
        this.forumService = this.getForumManager();
        Attachment att = this.forumService.uploadInstructionFile(file, type);
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        Iterator iter = attachmentList.iterator();
        while (iter.hasNext()) {
            Attachment existAtt = (Attachment)iter.next();
            if (!StringUtils.equals((String)existAtt.getFileName(), (String)att.getFileName()) || !StringUtils.equals((String)existAtt.getFileType(), (String)att.getFileType())) continue;
            deleteAttachmentList.add(existAtt);
            iter.remove();
            break;
        }
        attachmentList.add(att);
        return mapping.findForward("success");
    }

    public ActionForward deleteOfflineFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, form, request, response, "OFFLINE");
    }

    public ActionForward deleteOnlineFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, form, request, response, "ONLINE");
    }

    private ActionForward deleteFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String type) {
        Long versionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"versionID"));
        Long uuID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"uuID"));
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        Iterator iter = attachmentList.iterator();
        while (iter.hasNext()) {
            Attachment existAtt = (Attachment)iter.next();
            if (!existAtt.getFileUuid().equals(uuID) || !existAtt.getFileVersionId().equals(versionID)) continue;
            deleteAttachmentList.add(existAtt);
            iter.remove();
        }
        request.setAttribute("fileTypeFlag", (Object)type);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ActionForward newTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        ((MessageForm)form).setSessionMapID(sessionMapID);
        return mapping.findForward("success");
    }

    public ActionForward createTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, PersistenceException {
        MessageForm messageForm = (MessageForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(messageForm.getSessionMapID());
        request.setAttribute("sessionMapID", (Object)messageForm.getSessionMapID());
        List topics = this.getTopicList(sessionMap);
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Message message = messageForm.getMessage();
        message.setIsAuthored(true);
        message.setCreated(new Date());
        message.setUpdated(new Date());
        message.setLastReplyDate(new Date());
        ForumUser forumUser = this.forumService.getUserByID(new Long(user.getUserID().intValue()));
        String contentFolderID = (String)sessionMap.get((Object)"contentFolderID");
        if (forumUser == null && !StringUtils.equals((String)contentFolderID, (String)"-1")) {
            forumUser = new ForumUser(user, null);
        }
        message.setCreatedBy(forumUser);
        message.setModifiedBy(forumUser);
        HashSet<Attachment> attSet = null;
        if (messageForm.getAttachmentFile() != null && !StringUtils.isEmpty((String)messageForm.getAttachmentFile().getFileName())) {
            this.forumService = this.getForumManager();
            Attachment att = this.forumService.uploadAttachment(messageForm.getAttachmentFile());
            attSet = new HashSet<Attachment>();
            attSet.add(att);
        }
        message.setAttachments(attSet);
        topics.add(MessageDTO.getMessageDTO(message));
        return mapping.findForward("success");
    }

    public ActionForward viewTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws PersistenceException {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        List topics = this.getTopicList(sessionMap);
        String topicIndex = request.getParameter("topicIndex");
        int topicIdx = NumberUtils.stringToInt((String)topicIndex, (int)-1);
        if (topicIdx == -1) {
            topicIndex = (String)request.getAttribute("topicIndex");
            topicIdx = NumberUtils.stringToInt((String)topicIndex, (int)-1);
        }
        if (topicIdx != -1) {
            MessageDTO topic = (MessageDTO)topics.get(topicIdx);
            request.setAttribute("topicIndex", (Object)topicIndex);
            request.setAttribute("topic", (Object)topic);
        }
        return mapping.findForward("success");
    }

    public ActionForward deleteTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws PersistenceException {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        List topics = this.getTopicList(sessionMap);
        String topicIndex = request.getParameter("topicIndex");
        int topicIdx = NumberUtils.stringToInt((String)topicIndex, (int)-1);
        if (topicIdx != -1) {
            Object obj = topics.remove(topicIdx);
            List delList = this.getDeletedTopicList(sessionMap);
            delList.add(obj);
        }
        return mapping.findForward("success");
    }

    public ActionForward editTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws PersistenceException {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        MessageForm msgForm = (MessageForm)form;
        msgForm.setSessionMapID(sessionMapID);
        List topics = this.getTopicList(sessionMap);
        String topicIndex = request.getParameter("topicIndex");
        int topicIdx = NumberUtils.stringToInt((String)topicIndex, (int)-1);
        if (topicIdx != -1) {
            MessageDTO topic = (MessageDTO)topics.get(topicIdx);
            if (topic != null) {
                if (topic.getMessage() != null && topic.getMessage().getCreatedBy() != null) {
                    HttpSession ss = SessionManager.getSession();
                    UserDTO user = (UserDTO)ss.getAttribute("user");
                    Long topicAuthorId = topic.getMessage().getCreatedBy().getUserId();
                    if (!new Long(user.getUserID().intValue()).equals(topicAuthorId)) {
                        return mapping.findForward("forbiden");
                    }
                }
                msgForm.setMessage(topic.getMessage());
            }
            request.setAttribute("topic", (Object)topic);
        }
        request.setAttribute("topicIndex", (Object)topicIndex);
        return mapping.findForward("success");
    }

    public ActionForward updateTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws PersistenceException {
        MessageForm messageForm = (MessageForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(messageForm.getSessionMapID());
        request.setAttribute("sessionMapID", (Object)messageForm.getSessionMapID());
        List topics = this.getTopicList(sessionMap);
        String topicIndex = request.getParameter("topicIndex");
        int topicIdx = NumberUtils.stringToInt((String)topicIndex, (int)-1);
        if (topicIdx != -1) {
            Message message = messageForm.getMessage();
            MessageDTO newMsg = (MessageDTO)topics.get(topicIdx);
            if (newMsg.getMessage() == null) {
                newMsg.setMessage(new Message());
            }
            newMsg.getMessage().setSubject(message.getSubject());
            newMsg.getMessage().setBody(message.getBody());
            newMsg.getMessage().setUpdated(new Date());
            if (messageForm.getAttachmentFile() != null && !StringUtils.isEmpty((String)messageForm.getAttachmentFile().getFileName())) {
                this.forumService = this.getForumManager();
                Attachment att = this.forumService.uploadAttachment(messageForm.getAttachmentFile());
                HashSet<Attachment> attSet = new HashSet<Attachment>();
                attSet.add(att);
                newMsg.setHasAttachment(true);
                newMsg.getMessage().setAttachments(attSet);
            } else if (!messageForm.isHasAttachment()) {
                Set att = newMsg.getMessage().getAttachments();
                if (att != null && att.size() > 0) {
                    List delTopicAtt = this.getTopicDeletedAttachmentList(sessionMap);
                    delTopicAtt.add(att.iterator().next());
                }
                newMsg.setHasAttachment(false);
                newMsg.getMessage().setAttachments(null);
            }
        }
        request.setAttribute("topicIndex", (Object)topicIndex);
        return mapping.findForward("success");
    }

    private ActionForward deleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("itemAttachment", null);
        return mapping.findForward("success");
    }

    private IForumService getForumManager() {
        if (this.forumService == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            this.forumService = (IForumService)wac.getBean("forumService");
        }
        return this.forumService;
    }

    private List getAttachmentList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "attachmentList");
    }

    private List getDeletedAttachmentList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deletedAttachmentList");
    }

    private List getTopicList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "topicList");
    }

    private List getTopicDeletedAttachmentList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deletedAttachmentList");
    }

    private List getDeletedTopicList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deletedAuthoringTopicList");
    }

    private List getListFromSession(SessionMap sessionMap, String name) {
        ArrayList list = (ArrayList)sessionMap.get((Object)name);
        if (list == null) {
            list = new ArrayList();
            sessionMap.put((Object)name, list);
        }
        return list;
    }

    private ToolAccessMode getAccessMode(HttpServletRequest request) {
        String modeStr = request.getParameter("mode");
        ToolAccessMode mode = StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : ToolAccessMode.AUTHOR;
        return mode;
    }

    public ActionMessages validate(ForumForm form, ActionMapping mapping, HttpServletRequest request) {
        ActionMessages errors = new ActionMessages();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(form.getSessionMapID());
        try {
            ActionMessage error;
            List topics;
            String modeStr = request.getParameter("mode");
            boolean allowNewTopic = form.getForum().isAllowNewTopic();
            if (StringUtils.equals((String)modeStr, (String)ToolAccessMode.TEACHER.toString())) {
                this.forumService = this.getForumManager();
                Forum forumPO = this.forumService.getForumByContentId(form.getToolContentID());
                if (forumPO != null) {
                    allowNewTopic = forumPO.isAllowNewTopic();
                } else {
                    log.error((Object)("ERROR: Can not found Forum by toolContentID:" + form.getToolContentID()));
                    allowNewTopic = true;
                }
            }
            if (!allowNewTopic && (topics = this.getTopicList(sessionMap)).size() == 0) {
                ActionMessage error2 = new ActionMessage("error.must.have.topic");
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error2);
            }
            if (StringUtils.equals((String)modeStr, (String)ToolAccessMode.TEACHER.toString())) {
                return errors;
            }
            if (!form.getForum().isAllowRichEditor() && form.getForum().isLimitedInput() && form.getForum().getLimitedChar() <= 0) {
                error = new ActionMessage("error.limit.char.less.zero");
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
            }
            if (!form.getForum().isAllowNewTopic() && form.getForum().getMaximumReply() != 0 && form.getForum().getMaximumReply() < form.getForum().getMinimumReply()) {
                error = new ActionMessage("error.min.less.max");
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
            }
        }
        catch (Exception e) {
            log.error((Object)e.toString());
        }
        return errors;
    }

    private float convertToMeg(int numBytes) {
        return numBytes != 0 ? (float)(numBytes / 1024 / 1024) : 0.0f;
    }
}

