/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.web.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.forum.dto.MessageDTO;
import org.lamsfoundation.lams.tool.forum.dto.UserDTO;
import org.lamsfoundation.lams.tool.forum.persistence.Attachment;
import org.lamsfoundation.lams.tool.forum.persistence.Forum;
import org.lamsfoundation.lams.tool.forum.persistence.ForumException;
import org.lamsfoundation.lams.tool.forum.persistence.ForumToolSession;
import org.lamsfoundation.lams.tool.forum.persistence.ForumUser;
import org.lamsfoundation.lams.tool.forum.service.ForumServiceProxy;
import org.lamsfoundation.lams.tool.forum.service.IForumService;
import org.lamsfoundation.lams.tool.forum.util.ForumToolContentHandler;
import org.lamsfoundation.lams.usermanagement.util.LastNameAlphabeticComparator;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportServlet
extends AbstractExportPortfolioServlet {
    private static final long serialVersionUID = -4529093489007108143L;
    private static Logger logger = Logger.getLogger(ExportServlet.class);
    private final String FILENAME = "forum_main.html";
    ForumToolContentHandler handler;
    private static IForumService forumService;

    public void init() throws ServletException {
        forumService = ForumServiceProxy.getForumService(this.getServletContext());
        super.init();
    }

    protected String doOfflineExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.toolContentID == null && this.toolSessionID == null) {
            logger.error((Object)"Tool content Id or and session Id are null. Unable to activity title");
        } else {
            Forum forum = null;
            if (this.toolContentID != null) {
                forum = forumService.getForumByContentId(this.toolContentID);
            } else {
                ForumToolSession session = forumService.getSessionBySessionId(this.toolSessionID);
                if (session != null) {
                    forum = session.getForum();
                }
            }
            if (forum != null) {
                this.activityTitle = forum.getTitle();
            }
        }
        return super.doOfflineExport(request, response, directoryName, cookies);
    }

    public String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.LEARNER.toString())) {
            sessionMap.put((Object)"mode", (Object)ToolAccessMode.LEARNER);
            this.learner(request, response, directoryName, cookies, (HashMap)sessionMap);
        } else if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.TEACHER.toString())) {
            sessionMap.put((Object)"mode", (Object)ToolAccessMode.TEACHER);
            this.teacher(request, response, directoryName, cookies, (HashMap)sessionMap);
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        this.writeResponseToFile(basePath + "/jsps/export/exportportfolio.jsp?sessionMapID=" + sessionMap.getSessionID(), directoryName, "forum_main.html", cookies);
        return "forum_main.html";
    }

    public void learner(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies, HashMap sessionMap) {
        if (this.userID == null || this.toolSessionID == null) {
            String error = "Tool session Id or user Id is null. Unable to continue";
            logger.error((Object)error);
            throw new ForumException(error);
        }
        ForumUser forumUser = forumService.getUserByUserAndSession(this.userID, this.toolSessionID);
        ForumToolSession session = forumUser.getSession();
        Forum content = session.getForum();
        if (forumUser == null) {
            String error = "The user with user id " + this.userID + " does not exist in this session or session may not exist.";
            logger.error((Object)error);
            throw new ForumException(error);
        }
        List<MessageDTO> msgDtoList = this.getSessionTopicList(this.toolSessionID, directoryName);
        this.setAuthorMark(msgDtoList);
        TreeSet<UserDTO> userDTOSet = null;
        if (content.isReflectOnActivity()) {
            userDTOSet = new TreeSet<UserDTO>((Comparator<UserDTO>)new LastNameAlphabeticComparator());
            userDTOSet.add(this.getReflectionEntry(forumUser));
        }
        Object[] pair = new Object[]{msgDtoList, userDTOSet};
        TreeMap<String, Object[]> sessionTopicMap = new TreeMap<String, Object[]>();
        sessionTopicMap.put(session.getSessionName(), pair);
        sessionMap.put("ToolContentTopicList", sessionTopicMap);
        sessionMap.put("title", content.getTitle());
    }

    public void teacher(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies, HashMap sessionMap) {
        if (this.toolContentID == null) {
            String error = "Tool Content Id is missing. Unable to continue";
            logger.error((Object)error);
            throw new ForumException(error);
        }
        Forum content = forumService.getForumByContentId(this.toolContentID);
        if (content == null) {
            String error = "Data is missing from the database. Unable to Continue";
            logger.error((Object)error);
            throw new ForumException(error);
        }
        List sessionList = forumService.getSessionsByContentId(this.toolContentID);
        TreeMap<String, Object[]> topicsByUser = new TreeMap<String, Object[]>(new StringComparator());
        for (ForumToolSession session : sessionList) {
            List<MessageDTO> sessionMsgDTO = this.getSessionTopicList(session.getSessionId(), directoryName);
            TreeSet<UserDTO> userDTOSet = null;
            if (content.isReflectOnActivity()) {
                List forumUserList = forumService.getUsersBySessionId(session.getSessionId());
                userDTOSet = new TreeSet<UserDTO>((Comparator<UserDTO>)new LastNameAlphabeticComparator());
                for (ForumUser forumUser : forumUserList) {
                    userDTOSet.add(this.getReflectionEntry(forumUser));
                }
            }
            Object[] pair = new Object[]{sessionMsgDTO, userDTOSet};
            topicsByUser.put(session.getSessionName(), pair);
        }
        sessionMap.put("ToolContentTopicList", topicsByUser);
        sessionMap.put("title", content.getTitle());
    }

    private List<MessageDTO> getSessionTopicList(Long toolSessionID, String directoryName) {
        List rootTopics = forumService.getRootTopics(toolSessionID);
        ArrayList<MessageDTO> msgDtoList = new ArrayList<MessageDTO>();
        for (MessageDTO msgDto : rootTopics) {
            List topics = forumService.getTopicThread(msgDto.getMessage().getUid());
            for (MessageDTO topic : topics) {
                if (!topic.getHasAttachment()) continue;
                for (Attachment att : topic.getMessage().getAttachments()) {
                    File local;
                    topic.setAttachmentName(att.getFileName());
                    int idx = 1;
                    String userName = topic.getAuthor();
                    while (true) {
                        String localDir;
                        if (!(local = new File(localDir = FileUtil.getFullPath((String)directoryName, (String)(userName + "/" + idx)))).exists()) break;
                        ++idx;
                    }
                    local.mkdirs();
                    topic.setAttachmentLocalUrl(userName + "/" + idx + "/" + att.getFileUuid() + '.' + FileUtil.getFileExtension((String)att.getFileName()));
                    try {
                        this.handler = this.getToolContentHandler();
                        this.handler.saveFile(att.getFileUuid(), FileUtil.getFullPath((String)directoryName, (String)topic.getAttachmentLocalUrl()));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Export forum topic attachment failed: " + e.toString()));
                    }
                }
            }
            msgDtoList.addAll(topics);
        }
        return msgDtoList;
    }

    private ForumToolContentHandler getToolContentHandler() {
        if (this.handler == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            this.handler = (ForumToolContentHandler)((Object)wac.getBean("forumToolContentHandler"));
        }
        return this.handler;
    }

    private void setAuthorMark(List<MessageDTO> msgDtoList) {
        HttpSession ss = SessionManager.getSession();
        org.lamsfoundation.lams.usermanagement.dto.UserDTO user = (org.lamsfoundation.lams.usermanagement.dto.UserDTO)ss.getAttribute("user");
        Long currUserId = new Long(user.getUserID().intValue());
        for (MessageDTO dto : msgDtoList) {
            if (dto.getMessage().getCreatedBy() != null && currUserId.equals(dto.getMessage().getCreatedBy().getUserId())) {
                dto.setAuthor(true);
                continue;
            }
            dto.setAuthor(false);
        }
    }

    private UserDTO getReflectionEntry(ForumUser forumUser) {
        UserDTO userDTO = new UserDTO();
        userDTO.setFullName(forumUser.getFirstName() + " " + forumUser.getLastName());
        NotebookEntry notebookEntry = forumService.getEntry(forumUser.getSession().getSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lafrum11", forumUser.getUserId().intValue());
        if (notebookEntry != null) {
            userDTO.setReflect(notebookEntry.getEntry());
            logger.debug((Object)("Could not find notebookEntry for ForumUser: " + forumUser.getUid()));
        }
        return userDTO;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 != null && o2 != null) {
                return o1.compareTo(o2);
            }
            if (o1 != null) {
                return 1;
            }
            return -1;
        }
    }
}

