/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.web.actions;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.forum.dto.MessageDTO;
import org.lamsfoundation.lams.tool.forum.persistence.Attachment;
import org.lamsfoundation.lams.tool.forum.persistence.Forum;
import org.lamsfoundation.lams.tool.forum.persistence.ForumException;
import org.lamsfoundation.lams.tool.forum.persistence.ForumToolSession;
import org.lamsfoundation.lams.tool.forum.persistence.ForumUser;
import org.lamsfoundation.lams.tool.forum.persistence.Message;
import org.lamsfoundation.lams.tool.forum.persistence.PersistenceException;
import org.lamsfoundation.lams.tool.forum.service.ForumServiceProxy;
import org.lamsfoundation.lams.tool.forum.service.IForumService;
import org.lamsfoundation.lams.tool.forum.web.forms.MessageForm;
import org.lamsfoundation.lams.tool.forum.web.forms.ReflectionForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LearningAction
extends Action {
    private static Logger log = Logger.getLogger(LearningAction.class);
    private static final boolean MODE_OPTIONAL = false;
    private IForumService forumService;

    public final ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = mapping.getParameter();
        if (param.equals("viewForum")) {
            return this.viewForum(mapping, form, request, response);
        }
        if (param.equals("finish")) {
            return this.finish(mapping, form, request, response);
        }
        if (param.equals("viewTopic")) {
            return this.viewTopic(mapping, form, request, response);
        }
        if (param.equals("newTopic")) {
            return this.newTopic(mapping, form, request, response);
        }
        if (param.equals("createTopic")) {
            return this.createTopic(mapping, form, request, response);
        }
        if (param.equals("newReplyTopic")) {
            return this.newReplyTopic(mapping, form, request, response);
        }
        if (param.equals("replyTopic")) {
            return this.replyTopic(mapping, form, request, response);
        }
        if (param.equals("editTopic")) {
            return this.editTopic(mapping, form, request, response);
        }
        if (param.equals("updateTopic")) {
            return this.updateTopic(mapping, form, request, response);
        }
        if (param.equals("deleteAttachment")) {
            return this.deleteAttachment(mapping, form, request, response);
        }
        if (param.equals("updateMessageHideFlag")) {
            return this.updateMessageHideFlag(mapping, form, request, response);
        }
        if (param.equals("newReflection")) {
            return this.newReflection(mapping, form, request, response);
        }
        if (param.equals("submitReflection")) {
            return this.submitReflection(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward viewForum(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SessionMap sessionMap;
        String sessionMapID = request.getParameter("sessionMapID");
        if (sessionMapID != null) {
            sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        } else {
            sessionMap = new SessionMap();
            request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        }
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        ToolAccessMode mode = null;
        try {
            mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)false);
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (mode == null) {
            mode = ToolAccessMode.LEARNER;
        }
        Long sessionId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        this.forumService = this.getForumManager();
        ForumToolSession session = this.forumService.getSessionBySessionId(sessionId);
        if (session == null || session.getForum() == null) {
            log.error((Object)("Failed on getting session by given sessionID:" + sessionId));
            throw new Exception("Failed on getting session by given sessionID:" + sessionId);
        }
        Forum forum = session.getForum();
        ForumUser forumUser = this.getCurrentUser(request, sessionId);
        boolean lock = forum.getLockWhenFinished() && forumUser.isSessionFinished();
        Long forumId = forum.getUid();
        Boolean allowRichEditor = new Boolean(forum.isAllowRichEditor());
        int allowNumber = forum.isLimitedInput() || forum.isAllowRichEditor() ? forum.getLimitedChar() : 0;
        sessionMap.put((Object)"forum_id", (Object)forumId);
        sessionMap.put((Object)"mode", (Object)mode);
        sessionMap.put((Object)"finishedLock", (Object)new Boolean(lock));
        sessionMap.put((Object)"lockedWhenFinished", (Object)forum.getLockWhenFinished());
        sessionMap.put((Object)"userFinished", (Object)forumUser.isSessionFinished());
        sessionMap.put((Object)"allowEdit", (Object)forum.isAllowEdit());
        sessionMap.put((Object)"allowUpload", (Object)forum.isAllowUpload());
        sessionMap.put((Object)"allowNewTopics", (Object)forum.isAllowNewTopic());
        sessionMap.put((Object)"allowRichEditor", (Object)allowRichEditor);
        sessionMap.put((Object)"limitedChars", (Object)new Integer(allowNumber));
        sessionMap.put((Object)"toolSessionID", (Object)sessionId);
        sessionMap.put((Object)"title", (Object)forum.getTitle());
        sessionMap.put((Object)"instruction", (Object)forum.getInstructions());
        sessionMap.put((Object)"minimumReply", (Object)forum.getMinimumReply());
        sessionMap.put((Object)"maximumReply", (Object)forum.getMaximumReply());
        boolean hideReflection = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"hideReflection", (boolean)false);
        sessionMap.put((Object)"hideReflection", (Object)hideReflection);
        if (hideReflection) {
            sessionMap.put((Object)"reflectOn", (Object)false);
            sessionMap.put((Object)"reflectInstructions", (Object)"");
            sessionMap.put((Object)"reflectEntry", (Object)"");
        } else {
            sessionMap.put((Object)"reflectOn", (Object)forum.isReflectOnActivity());
            sessionMap.put((Object)"reflectInstructions", (Object)forum.getReflectInstructions());
            NotebookEntry notebookEntry = this.forumService.getEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "lafrum11", forumUser.getUserId().intValue());
            sessionMap.put((Object)"reflectEntry", (Object)(notebookEntry != null ? notebookEntry.getEntry() : ""));
        }
        if (forum.isDefineLater()) {
            return mapping.findForward("defineLater");
        }
        forum.setContentInUse(true);
        forum.setDefineLater(false);
        this.forumService.updateForum(forum);
        if (forum.getRunOffline()) {
            return mapping.findForward("runOffline");
        }
        List rootTopics = this.forumService.getRootTopics(sessionId);
        if (!forum.isAllowNewTopic()) {
            this.updateNumOfPosts(rootTopics, forumUser);
        }
        request.setAttribute("topicList", (Object)rootTopics);
        return mapping.findForward("success");
    }

    private void updateNumOfPosts(List rootTopics, ForumUser forumUser) {
        for (MessageDTO messageDTO : rootTopics) {
            int numOfPosts = this.forumService.getNumOfPostsByTopic(forumUser.getUserId(), messageDTO.getMessage().getUid());
            messageDTO.setNumOfPosts(numOfPosts);
        }
    }

    private ActionForward finish(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        ToolAccessMode mode = (ToolAccessMode)sessionMap.get((Object)"mode");
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        this.forumService = this.getForumManager();
        if (mode == ToolAccessMode.LEARNER || mode == ToolAccessMode.AUTHOR) {
            if (!this.validateBeforeFinish(request, sessionMapID)) {
                return mapping.getInputForward();
            }
            try {
                HttpSession ss = SessionManager.getSession();
                UserDTO user = (UserDTO)ss.getAttribute("user");
                Long userID = new Long(user.getUserID().longValue());
                this.forumService.finishUserSession(this.getCurrentUser(request, sessionId));
                ToolSessionManager sessionMgrService = ForumServiceProxy.getToolSessionManager(this.getServlet().getServletContext());
                String nextActivityUrl = sessionMgrService.leaveToolSession(sessionId, userID);
                response.sendRedirect(nextActivityUrl);
            }
            catch (DataMissingException e) {
                throw new ForumException(e);
            }
            catch (ToolException e) {
                throw new ForumException(e);
            }
            catch (IOException e) {
                throw new ForumException(e);
            }
            return null;
        }
        List rootTopics = this.forumService.getRootTopics(sessionId);
        request.setAttribute("topicList", (Object)rootTopics);
        return mapping.getInputForward();
    }

    private ActionForward submitReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReflectionForm refForm = (ReflectionForm)form;
        Integer userId = refForm.getUserID();
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        NotebookEntry entry = this.forumService.getEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "lafrum11", userId);
        if (entry == null) {
            this.forumService.createNotebookEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "lafrum11", userId, refForm.getEntryText());
        } else {
            entry.setEntry(refForm.getEntryText());
            entry.setLastModified(new Date());
            this.forumService.updateEntry(entry);
        }
        return this.finish(mapping, form, request, response);
    }

    private ActionForward newReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        if (!this.validateBeforeFinish(request, sessionMapID)) {
            return mapping.getInputForward();
        }
        ReflectionForm refForm = (ReflectionForm)form;
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        refForm.setUserID(user.getUserID());
        refForm.setSessionMapID(sessionMapID);
        IForumService submitFilesService = this.getForumManager();
        SessionMap map = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long toolSessionID = (Long)map.get((Object)"toolSessionID");
        NotebookEntry entry = submitFilesService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lafrum11", user.getUserID());
        if (entry != null) {
            refForm.setEntryText(entry.getEntry());
        }
        return mapping.findForward("success");
    }

    private ActionForward viewTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.forumService = this.getForumManager();
        Long rootTopicId = WebUtil.readLongParam((HttpServletRequest)request, (String)"topicID");
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        sessionMap.put((Object)"rootUid", (Object)rootTopicId);
        ForumUser forumUser = this.getCurrentUser(request, (Long)sessionMap.get((Object)"toolSessionID"));
        Forum forum = forumUser.getSession().getForum();
        List msgDtoList = this.forumService.getTopicThread(rootTopicId);
        this.updateMesssageFlag(msgDtoList);
        request.setAttribute("topicThread", (Object)msgDtoList);
        int numOfPosts = this.forumService.getNumOfPostsByTopic(forumUser.getUserId(), ((MessageDTO)msgDtoList.get(0)).getMessage().getUid());
        boolean noMorePosts = forum.getMaximumReply() != 0 && numOfPosts >= forum.getMaximumReply() && !forum.isAllowNewTopic() ? Boolean.TRUE : Boolean.FALSE;
        request.setAttribute("noMorePosts", (Object)noMorePosts);
        request.setAttribute("numOfPosts", (Object)numOfPosts);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        boolean hideReflection = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"hideReflection", (boolean)false);
        sessionMap.put((Object)"hideReflection", (Object)hideReflection);
        return mapping.findForward("success");
    }

    private ActionForward newTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((MessageForm)form).setSessionMapID(WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID"));
        return mapping.findForward("success");
    }

    public ActionForward createTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, PersistenceException {
        MessageForm messageForm = (MessageForm)form;
        SessionMap sessionMap = this.getSessionMap(request, messageForm);
        Long forumId = (Long)sessionMap.get((Object)"forum_id");
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        Message message = messageForm.getMessage();
        message.setIsAuthored(false);
        message.setCreated(new Date());
        message.setUpdated(new Date());
        message.setLastReplyDate(new Date());
        ForumUser forumUser = this.getCurrentUser(request, sessionId);
        message.setCreatedBy(forumUser);
        message.setModifiedBy(forumUser);
        this.setAttachment(messageForm, message);
        this.forumService = this.getForumManager();
        this.forumService.createRootTopic(forumId, sessionId, message);
        List rootTopics = this.forumService.getRootTopics(sessionId);
        request.setAttribute("topicList", (Object)rootTopics);
        request.setAttribute("sessionMapID", (Object)messageForm.getSessionMapID());
        return mapping.findForward("success");
    }

    private ActionForward newReplyTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = request.getParameter("sessionMapID");
        MessageForm msgForm = (MessageForm)form;
        msgForm.setSessionMapID(sessionMapID);
        Long parentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"parentID");
        MessageDTO topic = this.getTopic(parentId);
        if (topic != null && topic.getMessage() != null) {
            String reTitle = topic.getMessage().getSubject();
            MessageDTO originalMessage = MessageDTO.getMessageDTO(topic.getMessage());
            request.setAttribute("originalMessage", (Object)originalMessage);
            if (reTitle != null && !reTitle.trim().startsWith("Re:")) {
                msgForm.getMessage().setSubject("Re:" + reTitle);
            } else {
                msgForm.getMessage().setSubject(reTitle);
            }
        }
        SessionMap sessionMap = this.getSessionMap(request, msgForm);
        sessionMap.put((Object)"parentID", (Object)parentId);
        boolean hideReflection = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"hideReflection", (boolean)false);
        sessionMap.put((Object)"hideReflection", (Object)hideReflection);
        return mapping.findForward("success");
    }

    private ActionForward replyTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MessageForm messageForm = (MessageForm)form;
        SessionMap sessionMap = this.getSessionMap(request, messageForm);
        Long parentId = (Long)sessionMap.get((Object)"parentID");
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        Message message = messageForm.getMessage();
        message.setIsAuthored(false);
        message.setCreated(new Date());
        message.setUpdated(new Date());
        message.setLastReplyDate(new Date());
        ForumUser forumUser = this.getCurrentUser(request, sessionId);
        message.setCreatedBy(forumUser);
        message.setModifiedBy(forumUser);
        this.setAttachment(messageForm, message);
        this.forumService = this.getForumManager();
        this.forumService.replyTopic(parentId, sessionId, message);
        Long rootTopicId = this.forumService.getRootTopicId(parentId);
        List msgDtoList = this.forumService.getTopicThread(rootTopicId);
        this.updateMesssageFlag(msgDtoList);
        request.setAttribute("topicThread", (Object)msgDtoList);
        request.setAttribute("sessionMapID", (Object)messageForm.getSessionMapID());
        ForumToolSession session = this.forumService.getSessionBySessionId(sessionId);
        Forum forum = session.getForum();
        int numOfPosts = this.forumService.getNumOfPostsByTopic(forumUser.getUserId(), ((MessageDTO)msgDtoList.get(0)).getMessage().getUid());
        boolean noMorePosts = forum.getMaximumReply() != 0 && numOfPosts >= forum.getMaximumReply() && !forum.isAllowNewTopic() ? Boolean.TRUE : Boolean.FALSE;
        request.setAttribute("noMorePosts", (Object)noMorePosts);
        request.setAttribute("numOfPosts", (Object)numOfPosts);
        sessionMap.remove((Object)"originalMessage");
        return mapping.findForward("success");
    }

    public ActionForward editTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws PersistenceException {
        Long topicId = WebUtil.readLongParam((HttpServletRequest)request, (String)"topicID");
        MessageDTO topic = this.getTopic(topicId);
        MessageForm msgForm = (MessageForm)form;
        if (topic != null) {
            msgForm.setMessage(topic.getMessage());
            request.setAttribute("topic", (Object)topic);
        }
        SessionMap sessionMap = this.getSessionMap(request, msgForm);
        sessionMap.put((Object)"topicID", (Object)topicId);
        boolean hideReflection = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"hideReflection", (boolean)false);
        sessionMap.put((Object)"hideReflection", (Object)hideReflection);
        return mapping.findForward("success");
    }

    private ActionForward deleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MessageDTO dto = new MessageDTO();
        dto.setHasAttachment(false);
        request.setAttribute("topic", (Object)dto);
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID"));
        request.setAttribute("allowUpload", sessionMap.get((Object)"allowUpload"));
        return mapping.findForward("success");
    }

    public ActionForward updateTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws PersistenceException {
        this.forumService = this.getForumManager();
        MessageForm messageForm = (MessageForm)form;
        SessionMap sessionMap = this.getSessionMap(request, messageForm);
        Long topicId = (Long)sessionMap.get((Object)"topicID");
        Message message = messageForm.getMessage();
        boolean makeAuditEntry = ToolAccessMode.TEACHER.equals((Object)((ToolAccessMode)sessionMap.get((Object)"mode")));
        String oldMessageString = null;
        Message messagePO = this.forumService.getMessage(topicId);
        if (makeAuditEntry) {
            oldMessageString = messagePO.toString();
        }
        messagePO.setSubject(message.getSubject());
        messagePO.setBody(message.getBody());
        messagePO.setUpdated(new Date());
        messagePO.setModifiedBy(this.getCurrentUser(request, (Long)sessionMap.get((Object)"toolSessionID")));
        this.setAttachment(messageForm, messagePO);
        if (makeAuditEntry) {
            Long userId = 0L;
            String loginName = "Default";
            if (message.getCreatedBy() != null) {
                userId = message.getCreatedBy().getUserId();
                loginName = message.getCreatedBy().getLoginName();
            }
            this.forumService.getAuditService().logChange("lafrum11", userId, loginName, oldMessageString, messagePO.toString());
        }
        this.forumService.updateTopic(messagePO);
        Long rootTopicId = this.forumService.getRootTopicId(topicId);
        List msgDtoList = this.forumService.getTopicThread(rootTopicId);
        this.updateMesssageFlag(msgDtoList);
        ForumUser forumUser = this.getCurrentUser(request, (Long)sessionMap.get((Object)"toolSessionID"));
        Forum forum = forumUser.getSession().getForum();
        int numOfPosts = this.forumService.getNumOfPostsByTopic(forumUser.getUserId(), ((MessageDTO)msgDtoList.get(0)).getMessage().getUid());
        boolean noMorePosts = forum.getMaximumReply() != 0 && numOfPosts >= forum.getMaximumReply() && !forum.isAllowNewTopic() ? Boolean.TRUE : Boolean.FALSE;
        request.setAttribute("noMorePosts", (Object)noMorePosts);
        request.setAttribute("numOfPosts", (Object)numOfPosts);
        request.setAttribute("topicThread", (Object)msgDtoList);
        request.setAttribute("sessionMapID", (Object)messageForm.getSessionMapID());
        return mapping.findForward("success");
    }

    public ActionForward updateMessageHideFlag(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long msgId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"topicID"));
        Boolean hideFlag = new Boolean(WebUtil.readBooleanParam((HttpServletRequest)request, (String)"hideFlag"));
        this.forumService = this.getForumManager();
        this.forumService.updateMessageHideFlag(msgId, hideFlag);
        Long rootTopicId = this.forumService.getRootTopicId(msgId);
        List msgDtoList = this.forumService.getTopicThread(rootTopicId);
        this.updateMesssageFlag(msgDtoList);
        request.setAttribute("topicThread", (Object)msgDtoList);
        request.setAttribute("sessionMapID", (Object)WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID"));
        return mapping.findForward("success");
    }

    private boolean validateBeforeFinish(HttpServletRequest request, String sessionMapID) {
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        ForumToolSession session = this.forumService.getSessionBySessionId(sessionId);
        Forum forum = session.getForum();
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Long userID = new Long(user.getUserID().longValue());
        if (!forum.getRunOffline() && !forum.isAllowNewTopic()) {
            List list = this.forumService.getRootTopics(sessionId);
            for (MessageDTO msgDto : list) {
                Long topicId = msgDto.getMessage().getUid();
                int numOfPostsInTopic = this.forumService.getNumOfPostsByTopic(userID, topicId);
                if (numOfPostsInTopic >= forum.getMinimumReply()) continue;
                ActionMessages errors = new ActionMessages();
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.less.mini.post", (Object)forum.getMinimumReply()));
                this.saveErrors(request, errors);
                List rootTopics = this.forumService.getRootTopics(sessionId);
                request.setAttribute("topicList", (Object)rootTopics);
                request.setAttribute("sessionMapID", (Object)sessionMapID);
                return false;
            }
        }
        return true;
    }

    private void updateMesssageFlag(List msgDtoList) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Long currUserId = new Long(user.getUserID().intValue());
        for (MessageDTO dto : msgDtoList) {
            if (dto.getMessage().getCreatedBy() != null && currUserId.equals(dto.getMessage().getCreatedBy().getUserId())) {
                dto.setAuthor(true);
                continue;
            }
            dto.setAuthor(false);
        }
    }

    private MessageDTO getTopic(Long topicId) {
        this.forumService = this.getForumManager();
        MessageDTO topic = MessageDTO.getMessageDTO(this.forumService.getMessage(topicId));
        return topic;
    }

    private ForumUser getCurrentUser(HttpServletRequest request, Long sessionId) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        ForumUser forumUser = this.forumService.getUserByUserAndSession(new Long(user.getUserID().intValue()), sessionId);
        if (forumUser == null) {
            ForumToolSession session = this.forumService.getSessionBySessionId(sessionId);
            forumUser = new ForumUser(user, session);
            this.forumService.createUser(forumUser);
        }
        return forumUser;
    }

    private IForumService getForumManager() {
        if (this.forumService == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            this.forumService = (IForumService)wac.getBean("forumService");
        }
        return this.forumService;
    }

    private void setAttachment(MessageForm messageForm, Message message) {
        if (messageForm.getAttachmentFile() != null && !StringUtils.isBlank((String)messageForm.getAttachmentFile().getFileName())) {
            this.forumService = this.getForumManager();
            Attachment att = this.forumService.uploadAttachment(messageForm.getAttachmentFile());
            HashSet<Attachment> attSet = message.getAttachments();
            if (attSet == null) {
                attSet = new HashSet<Attachment>();
            }
            attSet.clear();
            attSet.add(att);
            message.setAttachments(attSet);
        } else if (!messageForm.isHasAttachment()) {
            if (message.getAttachments() != null) {
                Set atts = message.getAttachments();
                atts.clear();
                message.setAttachments(atts);
            } else {
                message.setAttachments(null);
            }
        }
    }

    private SessionMap getSessionMap(HttpServletRequest request, MessageForm messageForm) {
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(messageForm.getSessionMapID());
        return sessionMap;
    }
}

